/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import gnu.java.awt.ClasspathToolkit;
import gnu.java.awt.peer.ClasspathFontPeer;
import java.awt.FontFormatException;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.peer.FontPeer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Font
implements Serializable {
    public static final int PLAIN = 0;
    public static final int BOLD = 1;
    public static final int ITALIC = 2;
    public static final int ROMAN_BASELINE = 0;
    public static final int CENTER_BASELINE = 1;
    public static final int HANGING_BASELINE = 2;
    public static final int TRUETYPE_FONT = 0;
    public static final int TYPE1_FONT = 1;
    public static final int LAYOUT_LEFT_TO_RIGHT = 0;
    public static final int LAYOUT_RIGHT_TO_LEFT = 1;
    public static final int LAYOUT_NO_START_CONTEXT = 2;
    public static final int LAYOUT_NO_LIMIT_CONTEXT = 4;
    public static final String DIALOG = "Dialog";
    public static final String DIALOG_INPUT = "DialogInput";
    public static final String MONOSPACED = "Monospaced";
    public static final String SANS_SERIF = "SansSerif";
    public static final String SERIF = "Serif";
    protected String name;
    protected int size;
    protected float pointSize;
    protected int style;
    private static final long serialVersionUID = -4206021311591459213L;
    private transient ClasspathFontPeer peer;

    public static Font decode(String fontspec) {
        if (fontspec == null) {
            fontspec = "Dialog-PLAIN-12";
        }
        String name = null;
        int style = 0;
        int size = 12;
        StringTokenizer st = new StringTokenizer(fontspec, "- ");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (name == null) {
                name = token;
                continue;
            }
            if (token.toUpperCase().equals("BOLD")) {
                style = 1;
                continue;
            }
            if (token.toUpperCase().equals("ITALIC")) {
                style = 2;
                continue;
            }
            if (token.toUpperCase().equals("BOLDITALIC")) {
                style = 3;
                continue;
            }
            int tokenval = 0;
            try {
                tokenval = Integer.parseInt(token);
            }
            catch (NumberFormatException numberFormatException) {}
            if (tokenval == 0) continue;
            size = tokenval;
        }
        HashMap attrs = new HashMap();
        ClasspathFontPeer.copyStyleToAttrs(style, attrs);
        ClasspathFontPeer.copySizeToAttrs(size, attrs);
        return Font.getFontFromToolkit(name, attrs);
    }

    static ClasspathToolkit tk() {
        return (ClasspathToolkit)Toolkit.getDefaultToolkit();
    }

    static Font getFontFromToolkit(String name, Map attribs) {
        return Font.tk().getFont(name, attribs);
    }

    static ClasspathFontPeer getPeerFromToolkit(String name, Map attrs) {
        return Font.tk().getClasspathFontPeer(name, attrs);
    }

    public static Font getFont(String propname, Font defval) {
        String propval = System.getProperty(propname);
        if (propval != null) {
            return Font.decode(propval);
        }
        return defval;
    }

    public static Font getFont(String propname) {
        return Font.getFont(propname, null);
    }

    protected Font(Font font) {
        this(font.getName(), font.getAttributes());
    }

    public Font(String name, int style, int size) {
        HashMap attrs = new HashMap();
        ClasspathFontPeer.copyStyleToAttrs(style, attrs);
        ClasspathFontPeer.copySizeToAttrs(size, attrs);
        this.peer = Font.getPeerFromToolkit(name, attrs);
        this.size = size;
        this.pointSize = size;
        this.name = name != null ? name : this.peer.getName(this);
    }

    public Font(Map<? extends AttributedCharacterIterator.Attribute, ?> attrs) {
        this(null, attrs);
    }

    Font(String name, Map attrs) {
        if (attrs == null) {
            attrs = new HashMap();
        }
        this.peer = Font.getPeerFromToolkit(name, attrs);
        this.size = (int)this.peer.getSize(this);
        this.pointSize = this.peer.getSize(this);
        this.name = name != null ? name : this.peer.getName(this);
    }

    public String getName() {
        return this.peer.getName(this);
    }

    public int getSize() {
        return this.size;
    }

    public float getSize2D() {
        return this.pointSize;
    }

    public boolean isPlain() {
        return this.peer.isPlain(this);
    }

    public boolean isBold() {
        return this.peer.isBold(this);
    }

    public boolean isItalic() {
        return this.peer.isItalic(this);
    }

    public String getFamily() {
        return this.peer.getFamily(this);
    }

    public int getStyle() {
        return this.peer.getStyle(this);
    }

    public boolean canDisplay(char c) {
        return this.canDisplay((int)c);
    }

    public boolean canDisplay(int codePoint) {
        return this.peer.canDisplay(this, codePoint);
    }

    public int canDisplayUpTo(String s) {
        return this.peer.canDisplayUpTo(this, new StringCharacterIterator(s), 0, s.length() - 1);
    }

    public int canDisplayUpTo(char[] text, int start, int limit) {
        return this.peer.canDisplayUpTo(this, new StringCharacterIterator(new String(text)), start, limit);
    }

    public int canDisplayUpTo(CharacterIterator i, int start, int limit) {
        return this.peer.canDisplayUpTo(this, i, start, limit);
    }

    public static Font createFont(int fontFormat, InputStream is) throws FontFormatException, IOException {
        return Font.tk().createFont(fontFormat, is);
    }

    public static Font createFont(int fontFormat, File file) throws FontFormatException, IOException {
        if (file == null) {
            throw new NullPointerException("Null file argument");
        }
        return Font.tk().createFont(fontFormat, new FileInputStream(file));
    }

    public GlyphVector createGlyphVector(FontRenderContext ctx, String str) {
        return this.peer.createGlyphVector(this, ctx, new StringCharacterIterator(str));
    }

    public GlyphVector createGlyphVector(FontRenderContext ctx, CharacterIterator i) {
        return this.peer.createGlyphVector(this, ctx, i);
    }

    public GlyphVector createGlyphVector(FontRenderContext ctx, char[] chars) {
        return this.peer.createGlyphVector(this, ctx, new StringCharacterIterator(new String(chars)));
    }

    public GlyphVector createGlyphVector(FontRenderContext ctx, int[] glyphCodes) {
        return this.peer.createGlyphVector(this, ctx, glyphCodes);
    }

    public Font deriveFont(int style, float size) {
        return this.peer.deriveFont(this, style, size);
    }

    public Font deriveFont(float size) {
        return this.peer.deriveFont(this, size);
    }

    public Font deriveFont(int style) {
        return this.peer.deriveFont(this, style);
    }

    public Font deriveFont(int style, AffineTransform a) {
        if (a == null) {
            throw new IllegalArgumentException("Affine transformation is null");
        }
        return this.peer.deriveFont(this, style, a);
    }

    public Font deriveFont(AffineTransform a) {
        if (a == null) {
            throw new IllegalArgumentException("Affine transformation is null");
        }
        return this.peer.deriveFont(this, a);
    }

    public Font deriveFont(Map<? extends AttributedCharacterIterator.Attribute, ?> attributes) {
        return this.peer.deriveFont(this, attributes);
    }

    public Map<TextAttribute, ?> getAttributes() {
        return this.peer.getAttributes(this);
    }

    public AttributedCharacterIterator.Attribute[] getAvailableAttributes() {
        return this.peer.getAvailableAttributes(this);
    }

    public byte getBaselineFor(char c) {
        return this.peer.getBaselineFor(this, c);
    }

    public String getFamily(Locale lc) {
        return this.peer.getFamily(this, lc);
    }

    public static Font getFont(Map<? extends AttributedCharacterIterator.Attribute, ?> attributes) {
        return Font.getFontFromToolkit(null, attributes);
    }

    public String getFontName() {
        return this.peer.getFontName(this);
    }

    public String getFontName(Locale lc) {
        return this.peer.getFontName(this, lc);
    }

    public float getItalicAngle() {
        return this.peer.getItalicAngle(this);
    }

    public LineMetrics getLineMetrics(String text, int begin, int limit, FontRenderContext rc) {
        return this.peer.getLineMetrics(this, new StringCharacterIterator(text), begin, limit, rc);
    }

    public LineMetrics getLineMetrics(char[] chars, int begin, int limit, FontRenderContext rc) {
        return this.peer.getLineMetrics(this, new StringCharacterIterator(new String(chars)), begin, limit, rc);
    }

    public LineMetrics getLineMetrics(CharacterIterator ci, int begin, int limit, FontRenderContext rc) {
        return this.peer.getLineMetrics(this, ci, begin, limit, rc);
    }

    public Rectangle2D getMaxCharBounds(FontRenderContext rc) {
        return this.peer.getMaxCharBounds(this, rc);
    }

    public int getMissingGlyphCode() {
        return this.peer.getMissingGlyphCode(this);
    }

    public int getNumGlyphs() {
        return this.peer.getNumGlyphs(this);
    }

    public String getPSName() {
        return this.peer.getPostScriptName(this);
    }

    public Rectangle2D getStringBounds(String str, FontRenderContext frc) {
        char[] chars = str.toCharArray();
        return this.getStringBounds(chars, 0, chars.length, frc);
    }

    public Rectangle2D getStringBounds(String str, int begin, int limit, FontRenderContext frc) {
        String sub = str.substring(begin, limit);
        return this.getStringBounds(sub, frc);
    }

    public Rectangle2D getStringBounds(CharacterIterator ci, int begin, int limit, FontRenderContext frc) {
        int start = ci.getBeginIndex();
        ci.getEndIndex();
        char[] chars = new char[limit - start];
        ci.setIndex(start);
        int index = 0;
        while (index < chars.length) {
            chars[index] = ci.current();
            ci.next();
            ++index;
        }
        return this.getStringBounds(chars, 0, chars.length, frc);
    }

    public Rectangle2D getStringBounds(char[] chars, int begin, int limit, FontRenderContext frc) {
        String str = new String(chars, begin, limit - begin);
        TextLayout layout = new TextLayout(str, this, frc);
        return new Rectangle2D.Float(0.0f, -layout.getAscent(), layout.getAdvance(), layout.getDescent() + layout.getLeading());
    }

    public AffineTransform getTransform() {
        return this.peer.getTransform(this);
    }

    public boolean hasUniformLineMetrics() {
        return this.peer.hasUniformLineMetrics(this);
    }

    public boolean isTransformed() {
        return this.peer.isTransformed(this);
    }

    public GlyphVector layoutGlyphVector(FontRenderContext frc, char[] chars, int start, int limit, int flags) {
        return this.peer.layoutGlyphVector(this, frc, chars, start, limit, flags);
    }

    public FontPeer getPeer() {
        return this.peer;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Font)) {
            return false;
        }
        Font f = (Font)obj;
        return f.getName().equals(this.getName()) && f.getFamily().equals(this.getFamily()) && f.getFontName().equals(this.getFontName()) && f.getTransform().equals(this.getTransform()) && f.getSize() == this.getSize() && f.getStyle() == this.getStyle();
    }

    public String toString() {
        String styleString = "";
        switch (this.getStyle()) {
            case 0: {
                styleString = "plain";
                break;
            }
            case 1: {
                styleString = "bold";
                break;
            }
            case 2: {
                styleString = "italic";
                break;
            }
            default: {
                styleString = "unknown";
            }
        }
        return String.valueOf(this.getClass().getName()) + "[family=" + this.getFamily() + ",name=" + this.getFontName() + ",style=" + styleString + ",size=" + this.getSize() + "]";
    }

    public LineMetrics getLineMetrics(String str, FontRenderContext frc) {
        return this.getLineMetrics(str, 0, str.length() - 1, frc);
    }

    public boolean hasLayoutAttributes() {
        return false;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ois.defaultReadObject();
        HashMap attrs = new HashMap();
        ClasspathFontPeer.copyStyleToAttrs(this.style, attrs);
        ClasspathFontPeer.copySizeToAttrs(this.size, attrs);
        this.peer = Font.getPeerFromToolkit(this.name, attrs);
    }
}

