/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.jpeg;

import gnu.javax.imageio.jpeg.JPEGMarkerFoundException;
import java.io.IOException;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public class JPEGImageInputStream
extends ImageInputStreamImpl {
    private ImageInputStream in;
    byte marker;

    public JPEGImageInputStream(ImageInputStream in) {
        this.in = in;
    }

    public int read() throws IOException {
        this.setBitOffset(0);
        return this.in.read();
    }

    public int read(byte[] data, int offset, int len) throws IOException {
        this.setBitOffset(0);
        return this.in.read(data, offset, len);
    }

    private byte pullByte() throws IOException, JPEGMarkerFoundException {
        byte secondbyte;
        byte mybyte = this.readByte();
        if (mybyte == -1 && (secondbyte = this.readByte()) != 0) {
            this.marker = secondbyte;
            throw new JPEGMarkerFoundException();
        }
        return mybyte;
    }

    public byte getMarker() {
        return this.marker;
    }

    public int readBit() throws IOException, JPEGMarkerFoundException {
        this.checkClosed();
        int newOffset = this.bitOffset + 1 & 7;
        byte data = this.pullByte();
        if (this.bitOffset != 0) {
            this.seek(this.getStreamPosition() - 1L);
            data = (byte)(data >> 8 - newOffset);
        }
        this.bitOffset = newOffset;
        return data & 1;
    }

    public byte findNextMarker() throws IOException {
        boolean marked0xff = false;
        byte byteinfo = 0;
        this.setBitOffset(0);
        while (true) {
            byteinfo = this.readByte();
            if (!marked0xff) {
                if (byteinfo != -1) continue;
                marked0xff = true;
                continue;
            }
            if (byteinfo == -1) continue;
            if (byteinfo != 0) break;
            marked0xff = false;
        }
        return byteinfo;
    }
}

