/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.rmic;

import gnu.classpath.tools.rmic.AbstractMethodGenerator;
import gnu.classpath.tools.rmic.GiopIo;
import gnu.classpath.tools.rmic.SourceGiopRmicCompiler;
import java.lang.reflect.Method;
import java.util.Properties;

public class MethodGenerator
implements AbstractMethodGenerator {
    Method method;
    SourceGiopRmicCompiler rmic;
    MethodGenerator previous = null;
    int hashCharPosition;

    public MethodGenerator(Method aMethod, SourceGiopRmicCompiler aRmic) {
        this.method = aMethod;
        this.rmic = aRmic;
    }

    public String getGiopMethodName() {
        String m = this.method.getName();
        if (m.startsWith("get")) {
            return "_get_J" + m.substring("get".length());
        }
        if (m.startsWith("set")) {
            return "_set_J" + m.substring("set".length());
        }
        return m;
    }

    public String getArgumentList() {
        StringBuffer b = new StringBuffer();
        Class<?>[] args = this.method.getParameterTypes();
        int i = 0;
        while (i < args.length) {
            b.append(this.rmic.name(args[i]));
            b.append(" p" + i);
            if (i < args.length - 1) {
                b.append(", ");
            }
            ++i;
        }
        return b.toString();
    }

    public String getArgumentNames() {
        StringBuffer b = new StringBuffer();
        Class<?>[] args = this.method.getParameterTypes();
        int i = 0;
        while (i < args.length) {
            b.append(" p" + i);
            if (i < args.length - 1) {
                b.append(", ");
            }
            ++i;
        }
        return b.toString();
    }

    public String getThrows() {
        StringBuffer b = new StringBuffer();
        Class<?>[] args = this.method.getExceptionTypes();
        int i = 0;
        while (i < args.length) {
            b.append(this.rmic.name(args[i]));
            if (i < args.length - 1) {
                b.append(", ");
            }
            ++i;
        }
        return b.toString();
    }

    public String generateStubMethod() {
        String templateName;
        Properties vars = new Properties(this.rmic.vars);
        vars.put("#return_type", this.rmic.name(this.method.getReturnType()));
        vars.put("#method_name", this.method.getName());
        vars.put("#giop_method_name", this.getGiopMethodName());
        vars.put("#argument_list", this.getArgumentList());
        vars.put("#argument_names", this.getArgumentNames());
        vars.put("#argument_write", this.getStubParaWriteStatement());
        if (this.method.getReturnType().equals(Void.TYPE)) {
            vars.put("#read_return", "return;");
        } else {
            vars.put("#read_return", "return " + GiopIo.getReadStatement(this.method.getReturnType(), this.rmic));
        }
        String thr = this.getThrows();
        if (thr.length() > 0) {
            vars.put("#throws", "\n    throws " + thr);
        } else {
            vars.put("#throws", "");
        }
        if (this.method.getReturnType().equals(Void.TYPE)) {
            templateName = "StubMethodVoid.jav";
        } else {
            vars.put("#write_result", GiopIo.getWriteStatement(this.method.getReturnType(), "result", this.rmic));
            templateName = "StubMethod.jav";
        }
        String template = this.rmic.getResource(templateName);
        String generated = this.rmic.replaceAll(template, vars);
        return generated;
    }

    public String generateTieMethod() {
        String templateName;
        Properties vars = new Properties(this.rmic.vars);
        vars.put("#return_type", this.rmic.name(this.method.getReturnType()));
        vars.put("#method_name", this.method.getName());
        vars.put("#giop_method_name", this.getGiopMethodName());
        vars.put("#argument_list", this.getArgumentList());
        vars.put("#argument_names", this.getArgumentNames());
        vars.put("#argument_write", this.getStubParaWriteStatement());
        if (this.previous == null || this.previous.getHashChar() != this.getHashChar()) {
            vars.put("#hashCodeLabel", "    case '" + this.getHashChar() + "':");
        } else {
            vars.put("#hashCodeLabel", "    // also '" + this.getHashChar() + "':");
        }
        if (this.method.getReturnType().equals(Void.TYPE)) {
            templateName = "TieMethodVoid.jav";
        } else {
            vars.put("#write_result", GiopIo.getWriteStatement(this.method.getReturnType(), "result", this.rmic));
            templateName = "TieMethod.jav";
        }
        vars.put("#read_and_define_args", this.getRda());
        String template = this.rmic.getResource(templateName);
        String generated = this.rmic.replaceAll(template, vars);
        return generated;
    }

    public String getRda() {
        StringBuffer b = new StringBuffer();
        Class<?>[] args = this.method.getParameterTypes();
        int i = 0;
        while (i < args.length) {
            b.append("                ");
            b.append(this.rmic.name(args[i]));
            b.append(" ");
            b.append("p" + i);
            b.append(" = ");
            b.append(GiopIo.getReadStatement(args[i], this.rmic));
            if (i < args.length - 1) {
                b.append("\n");
            }
            ++i;
        }
        return b.toString();
    }

    public String getStubParaWriteStatement() {
        StringBuffer b = new StringBuffer();
        Class<?>[] args = this.method.getParameterTypes();
        int i = 0;
        while (i < args.length) {
            b.append("             ");
            b.append(GiopIo.getWriteStatement(args[i], "p" + i, this.rmic));
            b.append("\n");
            ++i;
        }
        return b.toString();
    }

    public char getHashChar() {
        return this.getGiopMethodName().charAt(this.hashCharPosition);
    }
}

