/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.TreePath;

public class MetalTreeUI
extends BasicTreeUI {
    private static final String LINE_STYLE_PROPERTY = "JTree.lineStyle";
    private static final String LINE_STYLE_VALUE_NONE = "None";
    private static final String LINE_STYLE_VALUE_ANGLED = "Angled";
    private static final String LINE_STYLE_VALUE_HORIZONTAL = "Horizontal";
    private static final int LINE_STYLE_NONE = 0;
    private static final int LINE_STYLE_ANGLED = 1;
    private static final int LINE_STYLE_HORIZONTAL = 2;
    private int lineStyle;
    private PropertyChangeListener lineStyleListener;

    public static ComponentUI createUI(JComponent component) {
        return new MetalTreeUI();
    }

    protected int getHorizontalLegBuffer() {
        return super.getHorizontalLegBuffer();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        Object lineStyleProp = c.getClientProperty(LINE_STYLE_PROPERTY);
        this.decodeLineStyle(lineStyleProp);
        if (this.lineStyleListener == null) {
            this.lineStyleListener = new LineStyleListener();
        }
        c.addPropertyChangeListener(this.lineStyleListener);
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        if (this.lineStyleListener != null) {
            c.removePropertyChangeListener(this.lineStyleListener);
        }
        this.lineStyleListener = null;
    }

    protected void decodeLineStyle(Object lineStyleFlag) {
        this.lineStyle = lineStyleFlag == null || lineStyleFlag.equals(LINE_STYLE_VALUE_ANGLED) ? 1 : (lineStyleFlag.equals(LINE_STYLE_VALUE_HORIZONTAL) ? 2 : (lineStyleFlag.equals(LINE_STYLE_VALUE_NONE) ? 0 : 1));
    }

    protected boolean isLocationInExpandControl(int row, int rowLevel, int mouseX, int mouseY) {
        return super.isLocationInExpandControl(this.tree.getPathForRow(row), mouseX, mouseY);
    }

    public void paint(Graphics g, JComponent c) {
        super.paint(g, c);
        if (this.lineStyle == 2) {
            this.paintHorizontalSeparators(g, c);
        }
    }

    protected void paintHorizontalSeparators(Graphics g, JComponent c) {
        g.setColor(UIManager.getColor("Tree.line"));
        Rectangle clip = g.getClipBounds();
        int row0 = this.getRowForPath(this.tree, this.getClosestPathForLocation(this.tree, 0, clip.y));
        int row1 = this.getRowForPath(this.tree, this.getClosestPathForLocation(this.tree, 0, clip.y + clip.height - 1));
        if (row0 >= 0 && row1 >= 0) {
            int i = row0;
            while (i <= row1) {
                Rectangle r;
                TreePath p = this.getPathForRow(this.tree, i);
                if (p != null && p.getPathCount() == 2 && (r = this.getPathBounds(this.tree, this.getPathForRow(this.tree, i))) != null) {
                    g.drawLine(clip.x, r.y, clip.x + clip.width, r.y);
                }
                ++i;
            }
        }
    }

    protected void paintVerticalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, TreePath path) {
        if (this.lineStyle == 1) {
            super.paintVerticalPartOfLeg(g, clipBounds, insets, path);
        }
    }

    protected void paintHorizontalPartOfLeg(Graphics g, Rectangle clipBounds, Insets insets, Rectangle bounds, TreePath path, int row, boolean isExpanded, boolean hasBeenExpanded, boolean isLeaf) {
        if (this.lineStyle == 1) {
            super.paintHorizontalPartOfLeg(g, clipBounds, insets, bounds, path, row, isExpanded, hasBeenExpanded, isLeaf);
        }
    }

    private class LineStyleListener
    implements PropertyChangeListener {
        private LineStyleListener() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            if (e.getPropertyName().equals(MetalTreeUI.LINE_STYLE_PROPERTY)) {
                MetalTreeUI.this.decodeLineStyle(e.getNewValue());
            }
        }
    }
}

