/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.LookAndFeel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolTipUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.View;

public class BasicToolTipUI
extends ToolTipUI {
    private static BasicToolTipUI shared;
    private String text;
    private PropertyChangeListener propertyChangeHandler;

    public static ComponentUI createUI(JComponent c) {
        if (shared == null) {
            shared = new BasicToolTipUI();
        }
        return shared;
    }

    public Dimension getMaximumSize(JComponent c) {
        Dimension d = this.getPreferredSize(c);
        View view = (View)c.getClientProperty("html");
        if (view != null) {
            d.width = (int)((float)d.width + (view.getMaximumSpan(0) - view.getPreferredSpan(0)));
        }
        return d;
    }

    public Dimension getMinimumSize(JComponent c) {
        Dimension d = this.getPreferredSize(c);
        View view = (View)c.getClientProperty("html");
        if (view != null) {
            d.width = (int)((float)d.width - (view.getPreferredSpan(0) - view.getMinimumSpan(0)));
        }
        return d;
    }

    public Dimension getPreferredSize(JComponent c) {
        JToolTip tip = (JToolTip)c;
        String str = tip.getTipText();
        FontMetrics fm = c.getFontMetrics(c.getFont());
        Insets i = c.getInsets();
        Dimension d = new Dimension(i.left + i.right, i.top + i.bottom);
        if (str != null && !str.equals("")) {
            View view = (View)c.getClientProperty("html");
            if (view != null) {
                d.width += (int)view.getPreferredSpan(0);
                d.height += (int)view.getPreferredSpan(1);
            } else {
                d.width += fm.stringWidth(str) + 6;
                d.height += fm.getHeight();
            }
        }
        return d;
    }

    protected void installDefaults(JComponent c) {
        LookAndFeel.installColorsAndFont(c, "ToolTip.background", "ToolTip.foreground", "ToolTip.font");
        LookAndFeel.installBorder(c, "ToolTip.border");
    }

    protected void installListeners(JComponent c) {
        this.propertyChangeHandler = new PropertyChangeHandler();
        c.addPropertyChangeListener(this.propertyChangeHandler);
    }

    public void installUI(JComponent c) {
        c.setOpaque(true);
        this.installDefaults(c);
        BasicHTML.updateRenderer(c, ((JToolTip)c).getTipText());
        this.installListeners(c);
    }

    public void paint(Graphics g, JComponent c) {
        JToolTip tip = (JToolTip)c;
        String text = tip.getTipText();
        Font font = c.getFont();
        FontMetrics fm = c.getFontMetrics(font);
        int ascent = fm.getAscent();
        Insets i = c.getInsets();
        Dimension size = c.getSize();
        Rectangle paintR = new Rectangle(i.left, i.top, size.width - i.left - i.right, size.height - i.top - i.bottom);
        Color saved = g.getColor();
        Font oldFont = g.getFont();
        g.setColor(Color.BLACK);
        View view = (View)c.getClientProperty("html");
        if (view != null) {
            view.paint(g, paintR);
        } else {
            g.drawString(text, paintR.x + 3, paintR.y + ascent);
        }
        g.setFont(oldFont);
        g.setColor(saved);
    }

    protected void uninstallDefaults(JComponent c) {
        c.setForeground(null);
        c.setBackground(null);
        c.setFont(null);
        c.setBorder(null);
    }

    protected void uninstallListeners(JComponent c) {
        if (this.propertyChangeHandler != null) {
            c.removePropertyChangeListener(this.propertyChangeHandler);
            this.propertyChangeHandler = null;
        }
    }

    public void uninstallUI(JComponent c) {
        this.uninstallDefaults(c);
        BasicHTML.updateRenderer(c, "");
        this.uninstallListeners(c);
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop.equals("tiptext") || prop.equals("font") || prop.equals("foreground")) {
                JToolTip tip = (JToolTip)e.getSource();
                String text = tip.getTipText();
                BasicHTML.updateRenderer(tip, text);
            }
        }
    }
}

