/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Adjustable;
import java.awt.Dimension;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ScrollBarUI;

public class JScrollBar
extends JComponent
implements Adjustable,
Accessible {
    private static final long serialVersionUID = -8195169869225066566L;
    protected int blockIncrement = 10;
    protected BoundedRangeModel model;
    protected int orientation = 1;
    protected int unitIncrement = 1;
    private ChangeListener sbChangeListener;

    public JScrollBar() {
        this(1, 0, 10, 0, 100);
    }

    public JScrollBar(int orientation) {
        this(orientation, 0, 10, 0, 100);
    }

    public JScrollBar(int orientation, int value, int extent, int min, int max) {
        this.model = new DefaultBoundedRangeModel(value, extent, min, max);
        this.sbChangeListener = new ScrollBarChangeListener();
        this.model.addChangeListener(this.sbChangeListener);
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException(String.valueOf(orientation) + " is not a legal orientation");
        }
        this.orientation = orientation;
        this.updateUI();
    }

    public void setUI(ScrollBarUI ui) {
        super.setUI(ui);
    }

    public ScrollBarUI getUI() {
        return (ScrollBarUI)this.ui;
    }

    public void updateUI() {
        this.setUI((ScrollBarUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "ScrollBarUI";
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("orientation must be one of HORIZONTAL or VERTICAL");
        }
        if (orientation != this.orientation) {
            int oldOrientation = this.orientation;
            this.orientation = orientation;
            this.firePropertyChange("orientation", oldOrientation, this.orientation);
        }
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    public void setModel(BoundedRangeModel newModel) {
        BoundedRangeModel oldModel = this.model;
        if (oldModel != null) {
            oldModel.removeChangeListener(this.sbChangeListener);
        }
        this.model = newModel;
        if (this.model != null) {
            this.model.addChangeListener(this.sbChangeListener);
        }
        this.firePropertyChange("model", oldModel, this.model);
    }

    public int getUnitIncrement(int direction) {
        return this.unitIncrement;
    }

    public void setUnitIncrement(int unitIncrement) {
        if (unitIncrement != this.unitIncrement) {
            int oldInc = this.unitIncrement;
            this.unitIncrement = unitIncrement;
            this.firePropertyChange("unitIncrement", oldInc, this.unitIncrement);
        }
    }

    public int getBlockIncrement(int direction) {
        return this.blockIncrement;
    }

    public void setBlockIncrement(int blockIncrement) {
        if (blockIncrement != this.blockIncrement) {
            int oldInc = this.blockIncrement;
            this.blockIncrement = blockIncrement;
            this.firePropertyChange("blockIncrement", oldInc, this.blockIncrement);
        }
    }

    public int getUnitIncrement() {
        return this.unitIncrement;
    }

    public int getBlockIncrement() {
        return this.blockIncrement;
    }

    public int getValue() {
        return this.model.getValue();
    }

    public void setValue(int value) {
        this.model.setValue(value);
    }

    public int getVisibleAmount() {
        return this.model.getExtent();
    }

    public void setVisibleAmount(int extent) {
        this.model.setExtent(extent);
    }

    public int getMinimum() {
        return this.model.getMinimum();
    }

    public void setMinimum(int minimum) {
        this.model.setMinimum(minimum);
    }

    public int getMaximum() {
        return this.model.getMaximum();
    }

    public void setMaximum(int maximum) {
        this.model.setMaximum(maximum);
    }

    public boolean getValueIsAdjusting() {
        return this.model.getValueIsAdjusting();
    }

    public void setValueIsAdjusting(boolean b) {
        this.model.setValueIsAdjusting(b);
    }

    public void setValues(int newValue, int newExtent, int newMin, int newMax) {
        this.model.setRangeProperties(newValue, newExtent, newMin, newMax, this.model.getValueIsAdjusting());
    }

    public void addAdjustmentListener(AdjustmentListener listener) {
        this.listenerList.add(AdjustmentListener.class, listener);
    }

    public void removeAdjustmentListener(AdjustmentListener listener) {
        this.listenerList.remove(AdjustmentListener.class, listener);
    }

    public AdjustmentListener[] getAdjustmentListeners() {
        return (AdjustmentListener[])this.listenerList.getListeners(AdjustmentListener.class);
    }

    protected void fireAdjustmentValueChanged(int id, int type, int value) {
        this.fireAdjustmentValueChanged(id, type, value, this.getValueIsAdjusting());
    }

    void fireAdjustmentValueChanged(int id, int type, int value, boolean isAdjusting) {
        Object[] adjustmentListeners = this.listenerList.getListenerList();
        AdjustmentEvent adjustmentEvent = new AdjustmentEvent(this, id, type, value, isAdjusting);
        int i = adjustmentListeners.length - 2;
        while (i >= 0) {
            if (adjustmentListeners[i] == AdjustmentListener.class) {
                ((AdjustmentListener)adjustmentListeners[i + 1]).adjustmentValueChanged(adjustmentEvent);
            }
            i -= 2;
        }
    }

    public Dimension getMinimumSize() {
        return this.ui.getMinimumSize(this);
    }

    public Dimension getMaximumSize() {
        return this.ui.getMaximumSize(this);
    }

    public void setEnabled(boolean x) {
        super.setEnabled(x);
    }

    protected String paramString() {
        StringBuffer sb = new StringBuffer(super.paramString());
        sb.append(",blockIncrement=").append(this.blockIncrement);
        sb.append(",orientation=");
        if (this.orientation == 0) {
            sb.append("HORIZONTAL");
        } else {
            sb.append("VERTICAL");
        }
        sb.append(",unitIncrement=").append(this.unitIncrement);
        return sb.toString();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJScrollBar();
        }
        return this.accessibleContext;
    }

    protected class AccessibleJScrollBar
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private static final long serialVersionUID = -7758162392045586663L;

        protected AccessibleJScrollBar() {
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet result = super.getAccessibleStateSet();
            if (JScrollBar.this.orientation == 0) {
                result.add(AccessibleState.HORIZONTAL);
            } else if (JScrollBar.this.orientation == 1) {
                result.add(AccessibleState.VERTICAL);
            }
            return result;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SCROLL_BAR;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(JScrollBar.this.getValue());
        }

        public boolean setCurrentAccessibleValue(Number value) {
            if (value == null) {
                return false;
            }
            Number oldValue = this.getCurrentAccessibleValue();
            JScrollBar.this.setValue(value.intValue());
            this.firePropertyChange("AccessibleValue", oldValue, new Integer(JScrollBar.this.getValue()));
            return true;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(JScrollBar.this.getMinimum());
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(JScrollBar.this.getMaximum() - JScrollBar.this.model.getExtent());
        }
    }

    private class ScrollBarChangeListener
    implements ChangeListener {
        private ScrollBarChangeListener() {
        }

        public void stateChanged(ChangeEvent event) {
            Object o = event.getSource();
            if (o instanceof BoundedRangeModel) {
                BoundedRangeModel m = (BoundedRangeModel)o;
                JScrollBar.this.fireAdjustmentValueChanged(601, 5, m.getValue(), m.getValueIsAdjusting());
            }
        }
    }
}

