/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.ReadOnlyBufferException;

final class CharSequenceBuffer
extends CharBuffer {
    private CharSequence charSequence;

    CharSequenceBuffer(CharSequence charSeq, int capacity, int limit, int position, int mark, int offs) {
        super(capacity, limit, position, mark);
        this.charSequence = charSeq;
        this.array_offset = offs;
    }

    CharSequenceBuffer(CharSequence charSeq, int start, int end) {
        this(charSeq, charSeq.length(), end, start, -1, 0);
    }

    public CharBuffer asReadOnlyBuffer() {
        return this.duplicate();
    }

    public CharBuffer compact() {
        throw new ReadOnlyBufferException();
    }

    public CharBuffer duplicate() {
        return new CharSequenceBuffer(this.charSequence, this.cap, this.limit, this.pos, this.mark, 0);
    }

    public char get() {
        if (this.pos >= this.limit) {
            throw new BufferUnderflowException();
        }
        return this.charSequence.charAt(this.array_offset + this.pos++);
    }

    public char get(int index) {
        if (index < 0 || index >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return this.charSequence.charAt(this.array_offset + index);
    }

    public boolean isDirect() {
        return false;
    }

    public ByteOrder order() {
        return ByteOrder.nativeOrder();
    }

    public CharBuffer put(char b) {
        throw new ReadOnlyBufferException();
    }

    public CharBuffer put(int index, char b) {
        throw new ReadOnlyBufferException();
    }

    public CharBuffer slice() {
        int newCapacity = this.limit - this.pos;
        return new CharSequenceBuffer(this.charSequence, newCapacity, newCapacity, 0, -1, this.pos);
    }

    public CharSequence subSequence(int start, int length) {
        int begin = this.array_offset + start + this.pos;
        return this.charSequence.subSequence(begin, begin + length);
    }

    public boolean isReadOnly() {
        return true;
    }
}

