/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import gnu.java.lang.reflect.MethodSignatureParser;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Method
extends AccessibleObject
implements Member,
GenericDeclaration {
    static final int METHOD_MODIFIERS = 3391;
    private Class declaringClass;
    Class[] exception_types;
    private String name;
    Class[] parameter_types;
    Class return_type;
    private int offset;

    private Method() {
    }

    @Override
    public Class<?> getDeclaringClass() {
        return this.declaringClass;
    }

    @Override
    public native String getName();

    private native int getModifiersInternal();

    @Override
    public int getModifiers() {
        return this.getModifiersInternal() & 0xD3F;
    }

    public boolean isBridge() {
        return (this.getModifiersInternal() & 0x40) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return (this.getModifiersInternal() & 0x1000) != 0;
    }

    public boolean isVarArgs() {
        return (this.getModifiersInternal() & 0x80) != 0;
    }

    public Class<?> getReturnType() {
        if (this.return_type == null) {
            this.getType();
        }
        return this.return_type;
    }

    public Class<?>[] getParameterTypes() {
        if (this.parameter_types == null) {
            this.getType();
        }
        return (Class[])this.parameter_types.clone();
    }

    final Class<?>[] internalGetParameterTypes() {
        if (this.parameter_types == null) {
            this.getType();
        }
        return this.parameter_types;
    }

    public Class<?>[] getExceptionTypes() {
        if (this.exception_types == null) {
            this.getType();
        }
        return (Class[])this.exception_types.clone();
    }

    final Class<?>[] internalGetExceptionTypes() {
        if (this.exception_types == null) {
            this.getType();
        }
        return this.exception_types;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Method)) {
            return false;
        }
        Method m = (Method)obj;
        return this.declaringClass == m.declaringClass && this.offset == m.offset;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        if (this.parameter_types == null) {
            this.getType();
        }
        StringBuffer b = new StringBuffer();
        int mods = this.getModifiers();
        if (mods != 0) {
            Modifier.toString(mods, b);
            b.append(" ");
        }
        Method.appendClassName(b, this.return_type);
        b.append(" ");
        Method.appendClassName(b, this.declaringClass);
        b.append(".");
        b.append(this.getName());
        b.append("(");
        int i = 0;
        while (i < this.parameter_types.length) {
            Method.appendClassName(b, this.parameter_types[i]);
            if (i < this.parameter_types.length - 1) {
                b.append(",");
            }
            ++i;
        }
        b.append(")");
        if (this.exception_types.length > 0) {
            b.append(" throws ");
            i = 0;
            while (i < this.exception_types.length) {
                Method.appendClassName(b, this.exception_types[i]);
                if (i < this.exception_types.length - 1) {
                    b.append(",");
                }
                ++i;
            }
        }
        return b.toString();
    }

    public String toGenericString() {
        int i;
        StringBuilder sb = new StringBuilder(128);
        Modifier.toString(this.getModifiers(), sb).append(' ');
        Constructor.addTypeParameters(sb, this.getTypeParameters());
        sb.append(this.getGenericReturnType()).append(' ');
        sb.append(this.getDeclaringClass().getName()).append('.');
        sb.append(this.getName()).append('(');
        Type[] types = this.getGenericParameterTypes();
        if (types.length > 0) {
            sb.append(types[0]);
            i = 1;
            while (i < types.length) {
                sb.append(',').append(types[i]);
                ++i;
            }
        }
        sb.append(')');
        types = this.getGenericExceptionTypes();
        if (types.length > 0) {
            sb.append(" throws ").append(types[0]);
            i = 1;
            while (i < types.length) {
                sb.append(',').append(types[i]);
                ++i;
            }
        }
        return sb.toString();
    }

    public native Object invoke(Object var1, Object ... var2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException;

    public TypeVariable<Method>[] getTypeParameters() {
        String sig = this.getSignature();
        if (sig == null) {
            return new TypeVariable[0];
        }
        MethodSignatureParser p = new MethodSignatureParser(this, sig);
        return p.getTypeParameters();
    }

    private native String getSignature();

    public Type[] getGenericExceptionTypes() {
        String sig = this.getSignature();
        if (sig == null) {
            return this.getExceptionTypes();
        }
        MethodSignatureParser p = new MethodSignatureParser(this, sig);
        return p.getGenericExceptionTypes();
    }

    public Type[] getGenericParameterTypes() {
        String sig = this.getSignature();
        if (sig == null) {
            return this.getParameterTypes();
        }
        MethodSignatureParser p = new MethodSignatureParser(this, sig);
        return p.getGenericParameterTypes();
    }

    public Type getGenericReturnType() {
        String sig = this.getSignature();
        if (sig == null) {
            return this.getReturnType();
        }
        MethodSignatureParser p = new MethodSignatureParser(this, sig);
        return p.getGenericReturnType();
    }

    public native Object getDefaultValue();

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annoClass) {
        Annotation[] annos = this.getDeclaredAnnotations();
        int i = 0;
        while (i < annos.length) {
            if (annos[i].annotationType() == annoClass) {
                return (T)annos[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        Annotation[] result = this.getDeclaredAnnotationsInternal();
        if (result == null) {
            result = new Annotation[]{};
        }
        return result;
    }

    public Annotation[][] getParameterAnnotations() {
        Annotation[][] result = this.getParameterAnnotationsInternal();
        if (result == null) {
            result = new Annotation[0][0];
        }
        return result;
    }

    private native Annotation[] getDeclaredAnnotationsInternal();

    private native Annotation[][] getParameterAnnotationsInternal();

    private native void getType();

    static void appendClassName(StringBuffer buf, Class k) {
        if (k.isArray()) {
            Method.appendClassName(buf, k.getComponentType());
            buf.append("[]");
        } else {
            buf.append(k.getName());
        }
    }
}

