/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.dom;

import gnu.xml.dom.DTDElementTypeInfo;
import gnu.xml.dom.DomCharacterData;
import gnu.xml.dom.DomDOMException;
import gnu.xml.dom.DomDoctype;
import gnu.xml.dom.DomDocument;
import gnu.xml.dom.DomNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Text;

public class DomText
extends DomCharacterData
implements Text {
    protected DomText(DomDocument owner, String value) {
        super((short)3, owner, value);
    }

    protected DomText(DomDocument owner, char[] buf, int off, int len) {
        super((short)3, owner, buf, off, len);
    }

    DomText(short nodeType, DomDocument owner, String value) {
        super(nodeType, owner, value);
    }

    DomText(short nodeType, DomDocument owner, char[] buf, int off, int len) {
        super(nodeType, owner, buf, off, len);
    }

    public String getNodeName() {
        return "#text";
    }

    public Text splitText(int offset) {
        if (this.isReadonly()) {
            throw new DomDOMException(7);
        }
        try {
            String text = this.getNodeValue();
            String before = text.substring(0, offset);
            String after = text.substring(offset);
            Text next = this.getNodeType() == 3 ? this.owner.createTextNode(after) : this.owner.createCDATASection(after);
            if (this.next != null) {
                this.parent.insertBefore(next, this.next);
            } else {
                this.parent.appendChild(next);
            }
            this.setNodeValue(before);
            return next;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DomDOMException(1);
        }
    }

    public boolean isElementContentWhitespace() {
        DTDElementTypeInfo info;
        DomDoctype doctype;
        if (this.parent != null && (doctype = (DomDoctype)this.owner.getDoctype()) != null && (info = doctype.getElementTypeInfo(this.parent.getNodeName())) != null) {
            if (info.model == null && info.model.indexOf("#PCDATA") != -1) {
                return false;
            }
            return this.getNodeValue().trim().length() == 0;
        }
        return false;
    }

    public String getWholeText() {
        DomNode ref = this;
        DomNode ctx = this.previous;
        while (ctx != null && (ctx.nodeType == 3 || ctx.nodeType == 4)) {
            ref = ctx;
            ctx = ctx.previous;
        }
        StringBuffer buf = new StringBuffer(((DomNode)ref).getNodeValue());
        ctx = ref.next;
        while (ctx != null && (ctx.nodeType == 3 || ctx.nodeType == 4)) {
            buf.append(ctx.getNodeValue());
            ctx = ctx.next;
        }
        return buf.toString();
    }

    public Text replaceWholeText(String content) throws DOMException {
        boolean isEmpty;
        boolean bl = isEmpty = content == null || content.length() == 0;
        if (!isEmpty) {
            this.setNodeValue(content);
        }
        DomNode ref = this;
        DomNode ctx = this.previous;
        while (ctx != null && (ctx.nodeType == 3 || ctx.nodeType == 4)) {
            ref = ctx;
            ctx = ctx.previous;
        }
        ctx = ref.next;
        if ((isEmpty || ref != this) && this.parent != null) {
            this.parent.removeChild(ref);
        }
        while (ctx != null && (ctx.nodeType == 3 || ctx.nodeType == 4)) {
            ref = ctx.next;
            if ((isEmpty || ctx != this) && this.parent != null) {
                this.parent.removeChild(ctx);
            }
            ctx = ref;
        }
        return isEmpty ? null : this;
    }
}

