/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.imageio.png;

import gnu.javax.imageio.png.PNGChunk;
import gnu.javax.imageio.png.PNGException;
import java.awt.color.ColorSpace;
import java.awt.image.IndexColorModel;

public class PNGPalette
extends PNGChunk {
    private int[] red;
    private int[] green;
    private int[] blue;

    protected PNGPalette(int type, byte[] data, int crc) throws PNGException {
        super(type, data, crc);
        double l = data.length;
        if ((l /= 3.0) - Math.floor(l) != 0.0) {
            throw new PNGException("Invalid size of palette chunk.");
        }
        int nEntries = (int)l;
        this.red = new int[nEntries];
        this.green = new int[nEntries];
        this.blue = new int[nEntries];
        int i = 0;
        while (i < nEntries) {
            this.red[i] = data[i * 3] & 0xFF;
            this.green[i] = data[i * 3 + 1] & 0xFF;
            this.blue[i] = data[i * 3 + 2] & 0xFF;
            ++i;
        }
    }

    public PNGPalette(IndexColorModel cm) {
        super(1347179589);
        int n = cm.getMapSize();
        this.data = new byte[n * 3];
        this.red = new int[n];
        this.green = new int[n];
        this.blue = new int[n];
        int i = 0;
        while (i < n) {
            byte by = (byte)cm.getRed(i);
            this.data[i * 3] = by;
            this.red[i] = by;
            byte by2 = (byte)cm.getGreen(i);
            this.data[i * 3 + 1] = by2;
            this.green[i] = by2;
            byte by3 = (byte)cm.getBlue(i);
            this.data[i * 3 + 2] = by3;
            this.blue[i] = by3;
            ++i;
        }
    }

    public IndexColorModel getPalette(ColorSpace cs) {
        int nc = this.red.length;
        byte[] r = new byte[nc];
        byte[] g = new byte[nc];
        byte[] b = new byte[nc];
        if (cs == null) {
            int i = 0;
            while (i < nc) {
                r[i] = (byte)this.red[i];
                g[i] = (byte)this.green[i];
                b[i] = (byte)this.blue[i];
                ++i;
            }
        } else {
            int i = 0;
            while (i < nc) {
                float[] in = new float[]{(float)this.red[i] / 255.0f, (float)this.green[i] / 255.0f, (float)this.blue[i] / 255.0f};
                float[] out = cs.toRGB(in);
                r[i] = (byte)Math.round((double)out[0] * 255.0);
                g[i] = (byte)Math.round((double)out[1] * 255.0);
                b[i] = (byte)Math.round((double)out[2] * 255.0);
                ++i;
            }
        }
        return new IndexColorModel(8, nc, r, g, b);
    }

    public String toString() {
        String s = "PNG Palette:\n";
        int i = 0;
        while (i < this.red.length) {
            s = String.valueOf(s) + "Index " + i + ": [" + this.red[i] + ", " + this.green[i] + ", " + this.blue[i] + "]\n";
            ++i;
        }
        return s;
    }
}

