/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp;

import gnu.classpath.jdwp.Jdwp;
import gnu.classpath.jdwp.VMFrame;
import gnu.classpath.jdwp.VMMethod;
import gnu.classpath.jdwp.event.EventRequest;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.util.MethodResult;
import gnu.classpath.jdwp.util.MonitorInfo;
import gnu.classpath.jdwp.value.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;

public class VMVirtualMachine {
    public static final boolean canWatchFieldModification = false;
    public static final boolean canWatchFieldAccess = false;
    public static final boolean canGetBytecodes = false;
    public static final boolean canGetSyntheticAttribute = false;
    public static final boolean canGetOwnedMonitorInfo = false;
    public static final boolean canGetCurrentContendedMonitor = false;
    public static final boolean canGetMonitorInfo = false;
    public static final boolean canRedefineClasses = false;
    public static final boolean canAddMethod = false;
    public static final boolean canUnrestrictedlyRedefineClasses = false;
    public static final boolean canPopFrames = false;
    public static final boolean canUseInstanceFilters = false;
    public static final boolean canGetSourceDebugExtension = false;
    public static final boolean canRequestVMDeathEvent = false;
    public static final boolean canSetDefaultStratum = false;
    private static Hashtable _jdwp_suspend_counts;
    static Hashtable _stepping_threads;
    static ArrayList _event_list;

    public static native void initialize();

    public static native void suspendThread(Thread var0) throws JdwpException;

    public static void suspendAllThreads() throws JdwpException {
        ThreadGroup jdwpGroup;
        Thread current = Thread.currentThread();
        ThreadGroup group = jdwpGroup = Jdwp.getDefault().getJdwpThreadGroup();
        ThreadGroup parent = group.getParent();
        while (parent != null) {
            group = parent;
            parent = group.getParent();
        }
        int num = group.activeCount();
        Thread[] threads = new Thread[num];
        group.enumerate(threads);
        int i = 0;
        while (i < num) {
            Thread t = threads[i];
            if (t != null && t.getThreadGroup() != jdwpGroup && t != current) {
                VMVirtualMachine.suspendThread(t);
            }
            ++i;
        }
        if (current.getThreadGroup() != jdwpGroup) {
            VMVirtualMachine.suspendThread(current);
        }
    }

    public static native void resumeThread(Thread var0) throws JdwpException;

    public static void resumeAllThreads() throws JdwpException {
        ThreadGroup jdwpGroup;
        Thread current = Thread.currentThread();
        ThreadGroup group = jdwpGroup = current.getThreadGroup();
        ThreadGroup parent = group.getParent();
        while (parent != null) {
            group = parent;
            parent = group.getParent();
        }
        int num = group.activeCount();
        Thread[] threads = new Thread[num];
        group.enumerate(threads);
        int i = 0;
        while (i < num) {
            Thread t = threads[i];
            if (t != null && t.getThreadGroup() != jdwpGroup && t != current) {
                VMVirtualMachine.resumeThread(t);
            }
            ++i;
        }
    }

    public static native int getSuspendCount(Thread var0) throws JdwpException;

    public static native Collection getAllLoadedClasses() throws JdwpException;

    public static native int getClassStatus(Class var0) throws JdwpException;

    public static native VMMethod[] getAllClassMethods(Class var0) throws JdwpException;

    public static native VMMethod getClassMethod(Class var0, long var1) throws JdwpException;

    public static native ArrayList getFrames(Thread var0, int var1, int var2) throws JdwpException;

    public static native VMFrame getFrame(Thread var0, long var1) throws JdwpException;

    public static native int getFrameCount(Thread var0) throws JdwpException;

    public static native int getThreadStatus(Thread var0) throws JdwpException;

    public static native ArrayList getLoadRequests(ClassLoader var0) throws JdwpException;

    public static native MethodResult executeMethod(Object var0, Thread var1, Class var2, VMMethod var3, Value[] var4, int var5) throws JdwpException;

    public static native String getSourceFile(Class var0) throws JdwpException;

    public static native void registerEvent(EventRequest var0) throws JdwpException;

    public static native void unregisterEvent(EventRequest var0) throws JdwpException;

    public static native void clearEvents(byte var0) throws JdwpException;

    public static native void redefineClasses(Class[] var0, byte[][] var1) throws JdwpException;

    public static native void setDefaultStratum(String var0) throws JdwpException;

    public static native String getSourceDebugExtension(Class var0) throws JdwpException;

    public static native byte[] getBytecodes(VMMethod var0) throws JdwpException;

    public static native MonitorInfo getMonitorInfo(Object var0) throws JdwpException;

    public static native Object[] getOwnedMonitors(Thread var0) throws JdwpException;

    public static native Object getCurrentContendedMonitor(Thread var0) throws JdwpException;

    public static native void popFrames(Thread var0, long var1);
}

