/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.javah;

import gnu.classpath.tools.javah.ClassWrapper;
import gnu.classpath.tools.javah.CniPrintStream;
import java.lang.reflect.Modifier;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class MethodHelper {
    public static boolean overrides(MethodNode derived, MethodNode base) {
        if (!derived.name.equals(base.name)) {
            return false;
        }
        return derived.desc.equals(base.desc);
    }

    public static String getBridgeTarget(MethodNode meth) {
        if ((meth.access & 0x40) == 0) {
            return null;
        }
        for (AbstractInsnNode insn : meth.instructions) {
            if (!(insn instanceof MethodInsnNode)) continue;
            return ((MethodInsnNode)insn).desc;
        }
        return null;
    }

    public static void print(CniPrintStream out, MethodNode meth, ClassWrapper declarer, String realMethodName) {
        if ("<clinit>".equals(meth.name)) {
            return;
        }
        boolean isInit = "<init>".equals(meth.name);
        out.setModifiers(meth.access);
        out.print("  ");
        if (Modifier.isStatic(meth.access)) {
            out.print("static ");
        } else if (!(isInit || Modifier.isPrivate(meth.access) || Modifier.isFinal(declarer.access))) {
            out.print("virtual ");
        }
        if (!isInit) {
            out.print(Type.getReturnType((String)meth.desc));
            out.print(" ");
            out.print(realMethodName);
        } else {
            String name = declarer.name;
            int index = name.lastIndexOf(47);
            name = name.substring(index + 1);
            out.print(name);
        }
        out.print("(");
        Type[] argTypes = Type.getArgumentTypes((String)meth.desc);
        int i = 0;
        while (i < argTypes.length) {
            if (i > 0) {
                out.print(", ");
            }
            out.print(argTypes[i]);
            ++i;
        }
        out.print(")");
        if (Modifier.isAbstract(meth.access)) {
            out.print(" = 0");
        }
        out.println(";");
    }
}

