/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.javah;

import gnu.classpath.tools.javah.ClassWrapper;
import gnu.classpath.tools.javah.JniHelper;
import gnu.classpath.tools.javah.Main;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;

public class JniPrintStream
extends PrintStream {
    Main classpath;
    HashMap methodNameMap = new HashMap();

    public JniPrintStream(Main classpath, OutputStream out, ClassWrapper klass) {
        super(out);
        this.classpath = classpath;
        this.computeOverloads(klass);
    }

    private void computeOverloads(ClassWrapper klass) {
        for (MethodNode method : klass.methods) {
            if (!Modifier.isNative(method.access)) continue;
            if (this.methodNameMap.containsKey(method.name)) {
                Integer val = (Integer)this.methodNameMap.get(method.name);
                this.methodNameMap.put(method.name, new Integer(val + 1));
                continue;
            }
            this.methodNameMap.put(method.name, new Integer(1));
        }
    }

    public void print(Type type) throws IOException {
        this.print(JniHelper.getName(this.classpath, type));
    }

    public void print(MethodNode method, String className) throws IOException {
        this.print("Java_");
        this.print(className);
        this.print("_");
        this.print(JniHelper.mangle(method.name));
        Integer overloadCount = (Integer)this.methodNameMap.get(method.name);
        if (overloadCount > 1) {
            this.print("__");
            int lastOffset = method.desc.lastIndexOf(41);
            this.print(JniHelper.mangle(method.desc.substring(1, lastOffset)));
        }
        this.print(" (JNIEnv *env");
        if (Modifier.isStatic(method.access)) {
            this.print(", jclass");
        } else {
            this.print(", jobject");
        }
        Type[] types = Type.getArgumentTypes((String)method.desc);
        int i = 0;
        while (i < types.length) {
            this.print(", ");
            this.print(types[i]);
            ++i;
        }
        this.print(")");
    }
}

