/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class TableColumn
implements Serializable {
    static final long serialVersionUID = -6113660025878112608L;
    public static final String COLUMN_WIDTH_PROPERTY = "columWidth";
    public static final String HEADER_VALUE_PROPERTY = "headerValue";
    public static final String HEADER_RENDERER_PROPERTY = "headerRenderer";
    public static final String CELL_RENDERER_PROPERTY = "cellRenderer";
    protected int modelIndex;
    protected Object identifier;
    protected int width;
    protected int minWidth;
    private int preferredWidth;
    protected int maxWidth;
    protected TableCellRenderer headerRenderer;
    protected Object headerValue;
    protected TableCellRenderer cellRenderer;
    protected TableCellEditor cellEditor;
    protected boolean isResizable;
    protected transient int resizedPostingDisableCount;
    private SwingPropertyChangeSupport changeSupport;

    private /* synthetic */ void finit$() {
        this.minWidth = 15;
        this.maxWidth = Integer.MAX_VALUE;
        this.isResizable = true;
        this.changeSupport = new SwingPropertyChangeSupport(this);
    }

    public TableColumn() {
        this(0, 75, null, null);
    }

    public TableColumn(int n) {
        this(n, 75, null, null);
    }

    public TableColumn(int n, int n2) {
        this(n, n2, null, null);
    }

    public TableColumn(int n, int n2, TableCellRenderer tableCellRenderer, TableCellEditor tableCellEditor) {
        this.finit$();
        this.modelIndex = n;
        this.width = n2;
        this.preferredWidth = n2;
        this.cellRenderer = tableCellRenderer;
        this.cellEditor = tableCellEditor;
        this.headerValue = null;
        this.identifier = null;
    }

    public void setModelIndex(int n) {
        if (this.modelIndex != n) {
            int n2 = this.modelIndex;
            this.modelIndex = n;
            this.changeSupport.firePropertyChange("modelIndex", n2, n);
        }
    }

    public int getModelIndex() {
        return this.modelIndex;
    }

    public void setIdentifier(Object object) {
        if (this.identifier != object) {
            Object object2 = this.identifier;
            this.identifier = object;
            this.changeSupport.firePropertyChange("identifier", object2, object);
        }
    }

    public Object getIdentifier() {
        if (this.identifier == null) {
            return this.getHeaderValue();
        }
        return this.identifier;
    }

    public void setHeaderValue(Object object) {
        if (this.headerValue == object) {
            return;
        }
        Object object2 = this.headerValue;
        this.headerValue = object;
        this.changeSupport.firePropertyChange(HEADER_VALUE_PROPERTY, object2, object);
    }

    public Object getHeaderValue() {
        return this.headerValue;
    }

    public void setHeaderRenderer(TableCellRenderer tableCellRenderer) {
        if (this.headerRenderer == tableCellRenderer) {
            return;
        }
        TableCellRenderer tableCellRenderer2 = this.headerRenderer;
        this.headerRenderer = tableCellRenderer;
        this.changeSupport.firePropertyChange(HEADER_RENDERER_PROPERTY, tableCellRenderer2, this.headerRenderer);
    }

    public TableCellRenderer getHeaderRenderer() {
        return this.headerRenderer;
    }

    public void setCellRenderer(TableCellRenderer tableCellRenderer) {
        if (this.cellRenderer == tableCellRenderer) {
            return;
        }
        TableCellRenderer tableCellRenderer2 = this.cellRenderer;
        this.cellRenderer = tableCellRenderer;
        this.changeSupport.firePropertyChange(CELL_RENDERER_PROPERTY, tableCellRenderer2, this.cellRenderer);
    }

    public TableCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellEditor(TableCellEditor tableCellEditor) {
        if (this.cellEditor != tableCellEditor) {
            TableCellEditor tableCellEditor2 = this.cellEditor;
            this.cellEditor = tableCellEditor;
            this.changeSupport.firePropertyChange("cellEditor", tableCellEditor2, tableCellEditor);
        }
    }

    public TableCellEditor getCellEditor() {
        return this.cellEditor;
    }

    public void setWidth(int n) {
        int n2 = this.width;
        this.width = n < this.minWidth ? this.minWidth : (n > this.maxWidth ? this.maxWidth : n);
        if (this.width == n2) {
            return;
        }
        this.changeSupport.firePropertyChange("width", n2, this.width);
    }

    public int getWidth() {
        return this.width;
    }

    public void setPreferredWidth(int n) {
        int n2 = this.preferredWidth;
        this.preferredWidth = n < this.minWidth ? this.minWidth : (n > this.maxWidth ? this.maxWidth : n);
        this.changeSupport.firePropertyChange("preferredWidth", n2, this.preferredWidth);
    }

    public int getPreferredWidth() {
        return this.preferredWidth;
    }

    public void setMinWidth(int n) {
        if (n < 0) {
            n = 0;
        }
        if (this.minWidth != n) {
            if (this.width < n) {
                this.setWidth(n);
            }
            if (this.preferredWidth < n) {
                this.setPreferredWidth(n);
            }
            int n2 = this.minWidth;
            this.minWidth = n;
            this.changeSupport.firePropertyChange("minWidth", n2, n);
        }
    }

    public int getMinWidth() {
        return this.minWidth;
    }

    public void setMaxWidth(int n) {
        if (this.maxWidth != n) {
            if (this.width > n) {
                this.setWidth(n);
            }
            if (this.preferredWidth > n) {
                this.setPreferredWidth(n);
            }
            int n2 = this.maxWidth;
            this.maxWidth = n;
            this.changeSupport.firePropertyChange("maxWidth", n2, n);
        }
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setResizable(boolean bl) {
        if (this.isResizable != bl) {
            this.isResizable = bl;
            this.changeSupport.firePropertyChange("isResizable", this.isResizable ^ true, bl);
        }
    }

    public boolean getResizable() {
        return this.isResizable;
    }

    public void sizeWidthToFit() {
        if (this.headerRenderer == null) {
            return;
        }
        Component component = this.headerRenderer.getTableCellRendererComponent(null, this.getHeaderValue(), false, false, 0, 0);
        Dimension dimension = component.getMinimumSize();
        Dimension dimension2 = component.getMaximumSize();
        Dimension dimension3 = component.getPreferredSize();
        this.setMinWidth(dimension.width);
        this.setMaxWidth(dimension2.width);
        this.setPreferredWidth(dimension3.width);
        this.setWidth(dimension3.width);
    }

    public void disableResizedPosting() {
    }

    public void enableResizedPosting() {
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.changeSupport.getPropertyChangeListeners();
    }

    protected TableCellRenderer createDefaultHeaderRenderer() {
        return new DefaultTableCellRenderer();
    }
}

