/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicArrowButton;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class BasicSplitPaneDivider
extends Container
implements PropertyChangeListener {
    static final long serialVersionUID = 1463404307042803342L;
    protected static final int ONE_TOUCH_SIZE = 6;
    protected static final int ONE_TOUCH_OFFSET = 2;
    protected DragController dragger;
    protected BasicSplitPaneUI splitPaneUI;
    protected int dividerSize;
    protected Component hiddenDivider;
    protected JSplitPane splitPane;
    protected MouseHandler mouseHandler;
    protected int orientation;
    protected JButton leftButton;
    protected JButton rightButton;
    private Border border;
    transient int currentDividerLocation;

    private /* synthetic */ void finit$() {
        this.mouseHandler = new MouseHandler(this);
        this.currentDividerLocation = 1;
    }

    public BasicSplitPaneDivider(BasicSplitPaneUI basicSplitPaneUI) {
        this.finit$();
        this.setLayout(new DividerLayout(this));
        this.setBasicSplitPaneUI(basicSplitPaneUI);
        this.setDividerSize(this.splitPane.getDividerSize());
    }

    public void setBasicSplitPaneUI(BasicSplitPaneUI basicSplitPaneUI) {
        if (this.splitPane != null) {
            this.splitPane.removePropertyChangeListener(this);
            this.removeMouseListener(this.mouseHandler);
            this.removeMouseMotionListener(this.mouseHandler);
            this.splitPane = null;
            this.hiddenDivider = null;
        }
        this.splitPaneUI = basicSplitPaneUI;
        if (this.splitPaneUI != null) {
            this.splitPane = basicSplitPaneUI.getSplitPane();
        }
        if (this.splitPane != null) {
            this.splitPane.addPropertyChangeListener(this);
            this.addMouseListener(this.mouseHandler);
            this.addMouseMotionListener(this.mouseHandler);
            this.hiddenDivider = this.splitPaneUI.getNonContinuousLayoutDivider();
            this.orientation = this.splitPane.getOrientation();
            this.oneTouchExpandableChanged();
        }
    }

    public BasicSplitPaneUI getBasicSplitPaneUI() {
        return this.splitPaneUI;
    }

    public void setDividerSize(int n) {
        this.dividerSize = n;
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setBorder(Border border) {
        if (border != this.border) {
            Border border2 = this.border;
            this.border = border;
            this.firePropertyChange("border", border2, border);
        }
    }

    public Border getBorder() {
        return this.border;
    }

    public Insets getInsets() {
        if (this.border != null) {
            return this.border.getBorderInsets(this);
        }
        return super.getInsets();
    }

    public Dimension getPreferredSize() {
        return this.getLayout().preferredLayoutSize(this);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("oneTouchExpandable")) {
            this.oneTouchExpandableChanged();
        } else if (propertyChangeEvent.getPropertyName().equals("orientation")) {
            this.orientation = this.splitPane.getOrientation();
            if (this.splitPane.isOneTouchExpandable()) {
                this.layout();
                this.repaint();
            }
        } else if (propertyChangeEvent.getPropertyName().equals("dividerSize")) {
            this.dividerSize = this.splitPane.getDividerSize();
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.border != null) {
            Dimension dimension = this.getSize();
            this.border.paintBorder(this, graphics, 0, 0, dimension.width, dimension.height);
        }
        if (this.splitPane.isOneTouchExpandable()) {
            ((BasicArrowButton)this.rightButton).paint(graphics);
            ((BasicArrowButton)this.leftButton).paint(graphics);
        }
    }

    protected void oneTouchExpandableChanged() {
        if (this.splitPane.isOneTouchExpandable()) {
            this.leftButton = this.createLeftOneTouchButton();
            this.rightButton = this.createRightOneTouchButton();
            this.add(this.leftButton);
            this.add(this.rightButton);
            this.leftButton.addMouseListener(this.mouseHandler);
            this.rightButton.addMouseListener(this.mouseHandler);
            this.currentDividerLocation = 1;
        } else if (this.leftButton != null && this.rightButton != null) {
            this.leftButton.removeMouseListener(this.mouseHandler);
            this.rightButton.removeMouseListener(this.mouseHandler);
            this.remove(this.leftButton);
            this.remove(this.rightButton);
            this.leftButton = null;
            this.rightButton = null;
        }
        this.layout();
        this.repaint();
    }

    protected JButton createLeftOneTouchButton() {
        int n = 7;
        if (this.orientation == 0) {
            n = 1;
        }
        BasicArrowButton basicArrowButton = new BasicArrowButton(n);
        basicArrowButton.setBorder(null);
        return basicArrowButton;
    }

    protected JButton createRightOneTouchButton() {
        int n = 3;
        if (this.orientation == 0) {
            n = 5;
        }
        BasicArrowButton basicArrowButton = new BasicArrowButton(n);
        basicArrowButton.setBorder(null);
        return basicArrowButton;
    }

    protected void prepareForDragging() {
        if (this.splitPaneUI != null) {
            this.splitPaneUI.startDragging();
        }
    }

    protected void dragDividerTo(int n) {
        if (this.splitPaneUI != null) {
            this.splitPaneUI.dragDividerTo(n);
        }
    }

    protected void finishDraggingTo(int n) {
        if (this.splitPaneUI != null) {
            this.splitPaneUI.finishDraggingTo(n);
        }
    }

    void moveDividerTo(int n) {
        Insets insets = this.splitPane.getInsets();
        switch (n) {
            case 1: {
                this.splitPane.setDividerLocation(this.splitPane.getLastDividerLocation());
                break;
            }
            case 0: {
                int n2 = this.orientation == 1 ? insets.left : insets.top;
                this.splitPane.setDividerLocation(n2);
                break;
            }
            case 2: {
                int n3 = this.orientation == 1 ? this.splitPane.getBounds().width - insets.right - this.dividerSize : this.splitPane.getBounds().height - insets.bottom - this.dividerSize;
                this.splitPane.setDividerLocation(n3);
            }
        }
    }

    protected class DividerLayout
    implements LayoutManager {
        private /* synthetic */ BasicSplitPaneDivider this$0;

        protected DividerLayout(BasicSplitPaneDivider basicSplitPaneDivider) {
            this.this$0 = basicSplitPaneDivider;
        }

        public void addLayoutComponent(String string, Component component) {
        }

        public void layoutContainer(Container container) {
            if (this.this$0.splitPane.isOneTouchExpandable()) {
                this.changeButtonOrientation();
                this.positionButtons();
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            return this.preferredLayoutSize(container);
        }

        public Dimension preferredLayoutSize(Container container) {
            return new Dimension(this.this$0.dividerSize, this.this$0.dividerSize);
        }

        public void removeLayoutComponent(Component component) {
        }

        private void changeButtonOrientation() {
            if (this.this$0.orientation == 1) {
                ((BasicArrowButton)this.this$0.rightButton).setDirection(3);
                ((BasicArrowButton)this.this$0.leftButton).setDirection(7);
            } else {
                ((BasicArrowButton)this.this$0.rightButton).setDirection(5);
                ((BasicArrowButton)this.this$0.leftButton).setDirection(1);
            }
        }

        private void positionButtons() {
            int n = 0;
            int n2 = 0;
            if (this.this$0.orientation == 1) {
                this.this$0.rightButton.setLocation(2, 2);
                this.this$0.leftButton.setLocation(2, 14);
                n = this.this$0.dividerSize - 4;
                n2 = 12;
            } else {
                this.this$0.leftButton.setLocation(2, 2);
                this.this$0.rightButton.setLocation(14, 2);
                n2 = this.this$0.dividerSize - 4;
                n = 12;
            }
            Dimension dimension = new Dimension(n, n2);
            this.this$0.leftButton.setSize(dimension);
            this.this$0.rightButton.setSize(dimension);
        }
    }

    protected class VerticalDragController
    extends DragController {
        private /* synthetic */ BasicSplitPaneDivider this$0;

        protected VerticalDragController(BasicSplitPaneDivider basicSplitPaneDivider, MouseEvent mouseEvent) {
            this.this$0 = basicSplitPaneDivider;
            super(basicSplitPaneDivider, mouseEvent);
            this.offset = mouseEvent.getY();
        }

        protected int getNeededLocation(int n, int n2) {
            return n2;
        }

        protected int positionForMouseEvent(MouseEvent mouseEvent) {
            return mouseEvent.getY() + this.this$0.getY() - this.offset;
        }

        int adjust(int n, int n2) {
            return this.getNeededLocation(n, n2) + this.this$0.getY() - this.offset;
        }
    }

    protected class DragController {
        private /* synthetic */ BasicSplitPaneDivider this$0;
        transient int offset;

        protected DragController(BasicSplitPaneDivider basicSplitPaneDivider, MouseEvent mouseEvent) {
            this.this$0 = basicSplitPaneDivider;
            this.offset = mouseEvent.getX();
        }

        protected boolean isValid() {
            return true;
        }

        protected int positionForMouseEvent(MouseEvent mouseEvent) {
            return mouseEvent.getX() + this.this$0.getX() - this.offset;
        }

        protected int getNeededLocation(int n, int n2) {
            return n;
        }

        protected void continueDrag(int n, int n2) {
            if (this.isValid()) {
                this.this$0.dragDividerTo(this.adjust(n, n2));
            }
        }

        protected void continueDrag(MouseEvent mouseEvent) {
            if (this.isValid()) {
                this.this$0.dragDividerTo(this.positionForMouseEvent(mouseEvent));
            }
        }

        protected void completeDrag(int n, int n2) {
            this.this$0.finishDraggingTo(this.adjust(n, n2));
        }

        protected void completeDrag(MouseEvent mouseEvent) {
            this.this$0.finishDraggingTo(this.positionForMouseEvent(mouseEvent));
        }

        int adjust(int n, int n2) {
            return this.getNeededLocation(n, n2) + this.this$0.getX() - this.offset;
        }
    }

    protected class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        private /* synthetic */ BasicSplitPaneDivider this$0;
        private transient boolean isDragging;

        public void mousePressed(MouseEvent mouseEvent) {
            if (this.this$0.splitPane.isOneTouchExpandable()) {
                if (mouseEvent.getSource() == this.this$0.leftButton) {
                    --this.this$0.currentDividerLocation;
                    if (this.this$0.currentDividerLocation < 0) {
                        this.this$0.currentDividerLocation = 0;
                    }
                    this.this$0.moveDividerTo(this.this$0.currentDividerLocation);
                    return;
                }
                if (mouseEvent.getSource() == this.this$0.rightButton) {
                    ++this.this$0.currentDividerLocation;
                    if (this.this$0.currentDividerLocation > 2) {
                        this.this$0.currentDividerLocation = 2;
                    }
                    this.this$0.moveDividerTo(this.this$0.currentDividerLocation);
                    return;
                }
            }
            this.isDragging = true;
            this.this$0.currentDividerLocation = 1;
            this.this$0.dragger = this.this$0.orientation == 1 ? new DragController(this.this$0, mouseEvent) : new VerticalDragController(this.this$0, mouseEvent);
            this.this$0.prepareForDragging();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.isDragging) {
                this.this$0.dragger.completeDrag(mouseEvent);
            }
            this.isDragging = false;
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.this$0.dragger != null) {
                this.this$0.dragger.continueDrag(mouseEvent);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        protected MouseHandler(BasicSplitPaneDivider basicSplitPaneDivider) {
            this.this$0 = basicSplitPaneDivider;
        }
    }
}

