/*
 * Decompiled with CFR 0.152.
 */
package javax.net.ssl;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class SSLContext {
    private static final String SSL_CONTEXT = "SSLContext";
    private final SSLContextSpi ctxSpi;
    private final Provider provider;
    private final String protocol;

    protected SSLContext(SSLContextSpi sSLContextSpi, Provider provider, String string) {
        this.ctxSpi = sSLContextSpi;
        this.provider = provider;
        this.protocol = string;
    }

    public static final SSLContext getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        for (int i = 0; i < providerArray.length; ++i) {
            try {
                return SSLContext.getInstance(string, providerArray[i]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
        }
        throw new NoSuchAlgorithmException(string);
    }

    public static final SSLContext getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 == null) {
            throw new IllegalArgumentException("null provider");
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return SSLContext.getInstance(string, provider);
    }

    public static final SSLContext getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        try {
            return new SSLContext((SSLContextSpi)Engine.getInstance(SSL_CONTEXT, string, provider), provider, string);
        }
        catch (InvocationTargetException invocationTargetException) {
            NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(string);
            throw (NoSuchAlgorithmException)noSuchAlgorithmException.initCause(invocationTargetException);
        }
        catch (ClassCastException classCastException) {
            NoSuchAlgorithmException noSuchAlgorithmException = new NoSuchAlgorithmException(string);
            throw (NoSuchAlgorithmException)noSuchAlgorithmException.initCause(classCastException);
        }
    }

    public final SSLSessionContext getClientSessionContext() {
        return this.ctxSpi.engineGetClientSessionContext();
    }

    public final String getProtocol() {
        return this.protocol;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final SSLSessionContext getServerSessionContext() {
        return this.ctxSpi.engineGetServerSessionContext();
    }

    public final SSLServerSocketFactory getServerSocketFactory() {
        return this.ctxSpi.engineGetServerSocketFactory();
    }

    public final SSLSocketFactory getSocketFactory() {
        return this.ctxSpi.engineGetSocketFactory();
    }

    public final void init(KeyManager[] keyManagerArray, TrustManager[] trustManagerArray, SecureRandom secureRandom) throws KeyManagementException {
        this.ctxSpi.engineInit(keyManagerArray, trustManagerArray, secureRandom);
    }
}

