/*
 * Decompiled with CFR 0.152.
 */
package java.rmi;

import gnu.java.rmi.RMIMarshalledObjectInputStream;
import gnu.java.rmi.RMIMarshalledObjectOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;

public final class MarshalledObject
implements Serializable {
    private static final long serialVersionUID = 8988374069173025854L;
    byte[] objBytes;
    byte[] locBytes;
    int hash;

    public MarshalledObject(Object object) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        RMIMarshalledObjectOutputStream rMIMarshalledObjectOutputStream = new RMIMarshalledObjectOutputStream(byteArrayOutputStream);
        rMIMarshalledObjectOutputStream.writeObject(object);
        rMIMarshalledObjectOutputStream.flush();
        this.objBytes = byteArrayOutputStream.toByteArray();
        this.locBytes = rMIMarshalledObjectOutputStream.getLocBytes();
        this.hash = 0;
        for (n = 0; n < this.objBytes.length; ++n) {
            this.hash = this.hash * 31 + this.objBytes[n];
        }
        if (this.locBytes != null) {
            for (n = 0; n < this.locBytes.length; ++n) {
                this.hash = this.hash * 31 + this.locBytes[n];
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof MarshalledObject)) {
            return false;
        }
        if (object.hashCode() != this.hash) {
            return false;
        }
        MarshalledObject marshalledObject = (MarshalledObject)object;
        if (this.objBytes == null || marshalledObject.objBytes == null) {
            return this.objBytes == marshalledObject.objBytes;
        }
        if (this.objBytes.length != marshalledObject.objBytes.length) {
            return false;
        }
        for (int i = 0; i < this.objBytes.length; ++i) {
            if (this.objBytes[i] == marshalledObject.objBytes[i]) continue;
            return false;
        }
        return true;
    }

    public Object get() throws IOException, ClassNotFoundException {
        if (this.objBytes == null) {
            return null;
        }
        RMIMarshalledObjectInputStream rMIMarshalledObjectInputStream = new RMIMarshalledObjectInputStream(this.objBytes, this.locBytes);
        return rMIMarshalledObjectInputStream.readObject();
    }

    public int hashCode() {
        return this.hash;
    }
}

