/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderMalfunctionError;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public abstract class CharsetEncoder {
    private static final int STATE_RESET = 0;
    private static final int STATE_CODING = 1;
    private static final int STATE_END = 2;
    private static final int STATE_FLUSHED = 3;
    private static final byte[] DEFAULT_REPLACEMENT = new byte[]{63};
    private final Charset charset;
    private final float averageBytesPerChar;
    private final float maxBytesPerChar;
    private byte[] replacement;
    private int state;
    private CodingErrorAction malformedInputAction;
    private CodingErrorAction unmappableCharacterAction;

    private /* synthetic */ void finit$() {
        this.state = 0;
        this.malformedInputAction = CodingErrorAction.REPORT;
        this.unmappableCharacterAction = CodingErrorAction.REPORT;
    }

    protected CharsetEncoder(Charset charset, float f, float f2) {
        this(charset, f, f2, DEFAULT_REPLACEMENT);
    }

    protected CharsetEncoder(Charset charset, float f, float f2, byte[] byArray) {
        this.finit$();
        if (f <= 0.0f) {
            throw new IllegalArgumentException("Non-positive averageBytesPerChar");
        }
        if (f2 <= 0.0f) {
            throw new IllegalArgumentException("Non-positive maxBytesPerChar");
        }
        this.charset = charset;
        this.averageBytesPerChar = f;
        this.maxBytesPerChar = f2;
        this.replacement = byArray;
        this.implReplaceWith(byArray);
    }

    public final float averageBytesPerChar() {
        return this.averageBytesPerChar;
    }

    public boolean canEncode(char c) {
        CharBuffer charBuffer = CharBuffer.allocate(1).put(c);
        charBuffer.flip();
        return this.canEncode(charBuffer);
    }

    public boolean canEncode(CharSequence charSequence) {
        CharBuffer charBuffer = charSequence instanceof CharBuffer ? ((CharBuffer)charSequence).duplicate() : CharBuffer.wrap(charSequence);
        return this.canEncode(charBuffer);
    }

    private boolean canEncode(CharBuffer charBuffer) {
        CodingErrorAction codingErrorAction;
        block14: {
            if (this.state == 3) {
                this.reset();
            } else if (this.state != 0) {
                throw new IllegalStateException();
            }
            CodingErrorAction codingErrorAction2 = this.malformedInputAction;
            codingErrorAction = this.unmappableCharacterAction;
            try {
                try {
                    if (codingErrorAction2 != CodingErrorAction.REPORT) {
                        this.onMalformedInput(CodingErrorAction.REPORT);
                    }
                    if (codingErrorAction != CodingErrorAction.REPORT) {
                        this.onUnmappableCharacter(CodingErrorAction.REPORT);
                    }
                }
                catch (Exception exception) {
                    boolean bl = false;
                    Object var6_7 = null;
                    if (codingErrorAction2 != CodingErrorAction.REPORT) {
                        this.onMalformedInput(codingErrorAction2);
                    }
                    if (codingErrorAction != CodingErrorAction.REPORT) {
                        this.onUnmappableCharacter(codingErrorAction);
                    }
                    return bl;
                }
                Object var6_8 = null;
                if (codingErrorAction2 == CodingErrorAction.REPORT) break block14;
                this.onMalformedInput(codingErrorAction2);
            }
            catch (Throwable throwable) {
                Object var6_9 = null;
                if (codingErrorAction2 != CodingErrorAction.REPORT) {
                    this.onMalformedInput(codingErrorAction2);
                }
                if (codingErrorAction != CodingErrorAction.REPORT) {
                    this.onUnmappableCharacter(codingErrorAction);
                }
                throw throwable;
            }
        }
        if (codingErrorAction != CodingErrorAction.REPORT) {
            this.onUnmappableCharacter(codingErrorAction);
        }
        boolean bl = true;
        return bl;
    }

    public final Charset charset() {
        return this.charset;
    }

    public final ByteBuffer encode(CharBuffer charBuffer) throws CharacterCodingException {
        if (this.state != 0) {
            throw new IllegalStateException();
        }
        int n = charBuffer.remaining();
        int n2 = (int)((float)n * this.maxBytesPerChar());
        ByteBuffer byteBuffer = ByteBuffer.allocate(n2);
        if (n == 0) {
            this.state = 3;
            return byteBuffer;
        }
        CoderResult coderResult = this.encode(charBuffer, byteBuffer, true);
        if (coderResult.isError()) {
            coderResult.throwException();
        }
        if ((coderResult = this.flush(byteBuffer)).isError()) {
            coderResult.throwException();
        }
        byteBuffer.flip();
        byte[] byArray = new byte[byteBuffer.remaining()];
        byteBuffer.get(byArray);
        return ByteBuffer.wrap(byArray);
    }

    public final CoderResult encode(CharBuffer charBuffer, ByteBuffer byteBuffer, boolean bl) {
        int n;
        int n2 = n = bl ? 2 : 1;
        if (!(this.state == 0 || this.state == 1 || bl && this.state == 2)) {
            throw new IllegalStateException();
        }
        this.state = n;
        while (true) {
            CodingErrorAction codingErrorAction;
            CoderResult coderResult;
            try {
                coderResult = this.encodeLoop(charBuffer, byteBuffer);
            }
            catch (RuntimeException runtimeException) {
                throw new CoderMalfunctionError(runtimeException);
            }
            if (coderResult.isOverflow()) {
                return coderResult;
            }
            if (coderResult.isUnderflow()) {
                if (bl && charBuffer.hasRemaining()) {
                    coderResult = CoderResult.malformedForLength(charBuffer.remaining());
                } else {
                    return coderResult;
                }
            }
            CodingErrorAction codingErrorAction2 = codingErrorAction = coderResult.isMalformed() ? this.malformedInputAction : this.unmappableCharacterAction;
            if (codingErrorAction == CodingErrorAction.REPORT) {
                return coderResult;
            }
            if (codingErrorAction == CodingErrorAction.REPLACE) {
                if (byteBuffer.remaining() < this.replacement.length) {
                    return CoderResult.OVERFLOW;
                }
                byteBuffer.put(this.replacement);
            }
            charBuffer.position(charBuffer.position() + coderResult.length());
        }
    }

    protected abstract CoderResult encodeLoop(CharBuffer var1, ByteBuffer var2);

    public final CoderResult flush(ByteBuffer byteBuffer) {
        if (this.state != 0 && this.state != 2) {
            throw new IllegalStateException();
        }
        this.state = 3;
        return this.implFlush(byteBuffer);
    }

    protected CoderResult implFlush(ByteBuffer byteBuffer) {
        return CoderResult.UNDERFLOW;
    }

    protected void implOnMalformedInput(CodingErrorAction codingErrorAction) {
    }

    protected void implOnUnmappableCharacter(CodingErrorAction codingErrorAction) {
    }

    protected void implReplaceWith(byte[] byArray) {
    }

    protected void implReset() {
    }

    public boolean isLegalReplacement(byte[] byArray) {
        CharsetDecoder charsetDecoder = this.charset.newDecoder();
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        CharBuffer charBuffer = CharBuffer.allocate((int)((float)byArray.length * charsetDecoder.maxCharsPerByte()));
        return charsetDecoder.decode(byteBuffer, charBuffer, true).isError() ^ true;
    }

    public CodingErrorAction malformedInputAction() {
        return this.malformedInputAction;
    }

    public final float maxBytesPerChar() {
        return this.maxBytesPerChar;
    }

    public final CharsetEncoder onMalformedInput(CodingErrorAction codingErrorAction) {
        if (codingErrorAction == null) {
            throw new IllegalArgumentException("Null action");
        }
        this.malformedInputAction = codingErrorAction;
        this.implOnMalformedInput(codingErrorAction);
        return this;
    }

    public CodingErrorAction unmappableCharacterAction() {
        return this.unmappableCharacterAction;
    }

    public final CharsetEncoder onUnmappableCharacter(CodingErrorAction codingErrorAction) {
        if (codingErrorAction == null) {
            throw new IllegalArgumentException("Null action");
        }
        this.unmappableCharacterAction = codingErrorAction;
        this.implOnUnmappableCharacter(codingErrorAction);
        return this;
    }

    public final byte[] replacement() {
        return this.replacement;
    }

    public final CharsetEncoder replaceWith(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Null replacement");
        }
        if (byArray.length == 0) {
            throw new IllegalArgumentException("Empty replacement");
        }
        if (!this.isLegalReplacement(byArray)) {
            throw new IllegalArgumentException("Illegal replacement");
        }
        this.replacement = byArray;
        this.implReplaceWith(byArray);
        return this;
    }

    public final CharsetEncoder reset() {
        this.state = 0;
        this.implReset();
        return this;
    }
}

