/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import gnu.java.lang.reflect.FieldSignatureParser;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

public final class Field
extends AccessibleObject
implements Member {
    private Class declaringClass;
    private String name;
    private int offset;
    private Class type;
    private static final int FIELD_MODIFIERS = 223;

    Field() {
    }

    public Class getDeclaringClass() {
        return this.declaringClass;
    }

    public native String getName();

    private native int getModifiersInternal();

    public int getModifiers() {
        return this.getModifiersInternal() & 0xDF;
    }

    public boolean isSynthetic() {
        return (this.getModifiersInternal() & 0x1000) != 0;
    }

    public boolean isEnumConstant() {
        return (this.getModifiersInternal() & 0x4000) != 0;
    }

    public native Class getType();

    public boolean equals(Object object) {
        if (!(object instanceof Field)) {
            return false;
        }
        Field field = (Field)object;
        return this.declaringClass == field.declaringClass && this.offset == field.offset;
    }

    public int hashCode() {
        return this.getDeclaringClass().getName().hashCode() ^ this.getName().hashCode();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getModifiers();
        if (n != 0) {
            Modifier.toString(n, stringBuffer);
            stringBuffer.append(' ');
        }
        Method.appendClassName(stringBuffer, this.getType());
        stringBuffer.append(' ');
        Method.appendClassName(stringBuffer, this.getDeclaringClass());
        stringBuffer.append('.');
        stringBuffer.append(this.getName());
        return stringBuffer.toString();
    }

    public String toGenericString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        Modifier.toString(this.getModifiers(), stringBuilder).append(' ');
        stringBuilder.append(this.getGenericType()).append(' ');
        stringBuilder.append(this.getDeclaringClass().getName()).append('.');
        stringBuilder.append(this.getName());
        return stringBuilder.toString();
    }

    public Object get(Object object) throws IllegalAccessException {
        return this.get(null, object);
    }

    public boolean getBoolean(Object object) throws IllegalAccessException {
        return this.getBoolean(null, object);
    }

    public byte getByte(Object object) throws IllegalAccessException {
        return this.getByte(null, object);
    }

    public char getChar(Object object) throws IllegalAccessException {
        return this.getChar(null, object);
    }

    public short getShort(Object object) throws IllegalAccessException {
        return this.getShort(null, object);
    }

    public int getInt(Object object) throws IllegalAccessException {
        return this.getInt(null, object);
    }

    public long getLong(Object object) throws IllegalAccessException {
        return this.getLong(null, object);
    }

    public float getFloat(Object object) throws IllegalAccessException {
        return this.getFloat(null, object);
    }

    public double getDouble(Object object) throws IllegalAccessException {
        return this.getDouble(null, object);
    }

    private native boolean getBoolean(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native char getChar(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native byte getByte(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native short getShort(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native int getInt(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native long getLong(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native float getFloat(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native double getDouble(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    private native Object get(Class var1, Object var2) throws IllegalArgumentException, IllegalAccessException;

    public void set(Object object, Object object2) throws IllegalAccessException {
        this.set(null, object, object2);
    }

    public void setBoolean(Object object, boolean bl) throws IllegalAccessException {
        this.setBoolean(null, object, bl, true);
    }

    public void setByte(Object object, byte by) throws IllegalAccessException {
        this.setByte(null, object, by, true);
    }

    public void setChar(Object object, char c) throws IllegalAccessException {
        this.setChar(null, object, c, true);
    }

    public void setShort(Object object, short s) throws IllegalAccessException {
        this.setShort(null, object, s, true);
    }

    public void setInt(Object object, int n) throws IllegalAccessException {
        this.setInt(null, object, n, true);
    }

    public void setLong(Object object, long l) throws IllegalArgumentException, IllegalAccessException {
        this.setLong(null, object, l, true);
    }

    public void setFloat(Object object, float f) throws IllegalAccessException {
        this.setFloat(null, object, f, true);
    }

    public void setDouble(Object object, double d) throws IllegalAccessException {
        this.setDouble(null, object, d, true);
    }

    public Type getGenericType() {
        String string = this.getSignature();
        if (string == null) {
            return this.getType();
        }
        FieldSignatureParser fieldSignatureParser = new FieldSignatureParser(this.getDeclaringClass(), string);
        return fieldSignatureParser.getFieldType();
    }

    private String getSignature() {
        return null;
    }

    native void setByte(Class var1, Object var2, byte var3, boolean var4) throws IllegalArgumentException, IllegalAccessException;

    native void setShort(Class var1, Object var2, short var3, boolean var4) throws IllegalArgumentException, IllegalAccessException;

    native void setInt(Class var1, Object var2, int var3, boolean var4) throws IllegalArgumentException, IllegalAccessException;

    native void setLong(Class var1, Object var2, long var3, boolean var5) throws IllegalArgumentException, IllegalAccessException;

    native void setFloat(Class var1, Object var2, float var3, boolean var4) throws IllegalArgumentException, IllegalAccessException;

    native void setDouble(Class var1, Object var2, double var3, boolean var5) throws IllegalArgumentException, IllegalAccessException;

    native void setChar(Class var1, Object var2, char var3, boolean var4) throws IllegalArgumentException, IllegalAccessException;

    native void setBoolean(Class var1, Object var2, boolean var3, boolean var4) throws IllegalArgumentException, IllegalAccessException;

    native void set(Class var1, Object var2, Object var3, Class var4, boolean var5) throws IllegalArgumentException, IllegalAccessException;

    private void set(Class clazz, Object object, Object object2) throws IllegalArgumentException, IllegalAccessException {
        Class clazz2 = this.getType();
        if (!clazz2.isPrimitive()) {
            this.set(clazz, object, object2, clazz2, true);
        } else if (object2 instanceof Byte) {
            this.setByte(clazz, object, (Byte)object2, true);
        } else if (object2 instanceof Short) {
            this.setShort(clazz, object, (Short)object2, true);
        } else if (object2 instanceof Integer) {
            this.setInt(clazz, object, (Integer)object2, true);
        } else if (object2 instanceof Long) {
            this.setLong(clazz, object, (Long)object2, true);
        } else if (object2 instanceof Float) {
            this.setFloat(clazz, object, ((Float)object2).floatValue(), true);
        } else if (object2 instanceof Double) {
            this.setDouble(clazz, object, (Double)object2, true);
        } else if (object2 instanceof Character) {
            this.setChar(clazz, object, ((Character)object2).charValue(), true);
        } else if (object2 instanceof Boolean) {
            this.setBoolean(clazz, object, (Boolean)object2, true);
        } else {
            throw new IllegalArgumentException();
        }
    }
}

