/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.Permission;

public final class FilePermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 7930732926638008763L;
    private static final String ALL_FILES = "<<ALL FILES>>";
    private boolean readPerm;
    private boolean writePerm;
    private boolean executePerm;
    private boolean deletePerm;
    private final String actionsString;

    private /* synthetic */ void finit$() {
        this.readPerm = false;
        this.writePerm = false;
        this.executePerm = false;
        this.deletePerm = false;
    }

    private void checkPerms() throws IllegalArgumentException {
        String string;
        int n = this.actionsString.indexOf(44);
        int n2 = 0;
        while (n != -1) {
            string = this.actionsString.substring(n2, n).trim().toLowerCase();
            if (string.equals("read")) {
                this.readPerm = true;
            } else if (string.equals("write")) {
                this.writePerm = true;
            } else if (string.equals("execute")) {
                this.executePerm = true;
            } else if (string.equals("delete")) {
                this.deletePerm = true;
            } else {
                throw new IllegalArgumentException("Unknown action: " + string);
            }
            n2 = n + 1;
            n = this.actionsString.indexOf(44, n2);
        }
        string = this.actionsString.substring(n2).trim().toLowerCase();
        if (string.equals("read")) {
            this.readPerm = true;
        } else if (string.equals("write")) {
            this.writePerm = true;
        } else if (string.equals("execute")) {
            this.executePerm = true;
        } else if (string.equals("delete")) {
            this.deletePerm = true;
        } else {
            throw new IllegalArgumentException("Unknown action: " + string);
        }
    }

    public FilePermission(String string, String string2) {
        super(string);
        this.finit$();
        if (string == null) {
            throw new NullPointerException("pathExpression");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("actionsString");
        }
        this.actionsString = string2;
        this.checkPerms();
    }

    public String getActions() {
        return this.actionsString;
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.actionsString.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof FilePermission)) {
            return false;
        }
        FilePermission filePermission = (FilePermission)object;
        String string = this.getName();
        String string2 = filePermission.getName();
        if (string.length() > 0 && string.charAt(string.length() - 1) == File.separatorChar ? (string2.length() > 0 && string2.charAt(string2.length() - 1) == File.separatorChar ? !string2.equals(string) : !string2.equals(string.substring(0, string.length() - 1))) : (string2.length() > 0 && string2.charAt(string2.length() - 1) == File.separatorChar ? !string.equals(string2.substring(0, string2.length() - 1)) : !string.equals(string2))) {
            return false;
        }
        return this.readPerm == filePermission.readPerm && this.writePerm == filePermission.writePerm && this.executePerm == filePermission.executePerm && this.deletePerm == filePermission.deletePerm;
    }

    public boolean implies(Permission permission) {
        if (!(permission instanceof FilePermission)) {
            return false;
        }
        String string = this.getName();
        if (string.equals(ALL_FILES)) {
            return true;
        }
        FilePermission filePermission = (FilePermission)permission;
        String string2 = filePermission.getName();
        if (string2.equals(ALL_FILES)) {
            return false;
        }
        try {
            string = new File(string).getCanonicalPath();
            string2 = new File(string2).getCanonicalPath();
        }
        catch (IOException iOException) {
            return false;
        }
        switch (string.charAt(string.length() - 1)) {
            case '*': {
                String string3 = string.substring(0, string.length() - 1);
                if (string2.length() <= string3.length()) {
                    return false;
                }
                if (string2.charAt(string3.length() - 1) == File.separatorChar) {
                    if (!string2.substring(0, string3.length()).equals(string3)) {
                        return false;
                    }
                    if (string2.substring(string3.length() + 1).indexOf(File.separatorChar) == -1) break;
                    return false;
                }
                return false;
            }
            case '-': {
                String string4 = string.substring(0, string.length() - 2);
                if (string2.length() < string4.length()) {
                    return false;
                }
                if (string2.length() > string4.length() && string2.charAt(string4.length()) != File.separatorChar) {
                    return false;
                }
                if (string2.substring(0, string4.length()).equals(string4)) break;
                return false;
            }
            default: {
                if (string.equals(string2)) break;
                return false;
            }
        }
        if (filePermission.readPerm && !this.readPerm) {
            return false;
        }
        if (filePermission.writePerm && !this.writePerm) {
            return false;
        }
        if (filePermission.executePerm && !this.executePerm) {
            return false;
        }
        return !filePermission.deletePerm || this.deletePerm;
    }
}

