/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Alert;
import gnu.javax.net.ssl.provider.AlertException;
import gnu.javax.net.ssl.provider.SSLSocket;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class SSLSocketInputStream
extends FilterInputStream {
    private final SSLSocket socket;
    private final boolean checkHandshake;

    SSLSocketInputStream(InputStream inputStream, SSLSocket sSLSocket) {
        this(inputStream, sSLSocket, true);
    }

    SSLSocketInputStream(InputStream inputStream, SSLSocket sSLSocket, boolean bl) {
        super(inputStream);
        this.socket = sSLSocket;
        this.checkHandshake = bl;
    }

    public int available() throws IOException {
        if (this.checkHandshake) {
            this.socket.checkHandshakeDone();
        }
        int n = 0;
        try {
            n = super.available();
        }
        catch (AlertException alertException) {
            Alert alert = alertException.getAlert();
            if (alert.getDescription() == Alert.Description.CLOSE_NOTIFY) {
                return -1;
            }
            throw alertException;
        }
        return n;
    }

    public int read() throws IOException {
        if (this.checkHandshake) {
            this.socket.checkHandshakeDone();
        }
        int n = 0;
        try {
            n = this.in.read();
        }
        catch (AlertException alertException) {
            Alert alert = alertException.getAlert();
            if (alert.getDescription() == Alert.Description.CLOSE_NOTIFY) {
                return -1;
            }
            throw alertException;
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.checkHandshake) {
            this.socket.checkHandshakeDone();
        }
        if (byArray == null) {
            throw new NullPointerException();
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        int n3 = 0;
        try {
            n3 = this.in.read(byArray, n, n2);
        }
        catch (AlertException alertException) {
            Alert alert = alertException.getAlert();
            if (alert.getDescription() == Alert.Description.CLOSE_NOTIFY) {
                return -1;
            }
            throw alertException;
        }
        return n3;
    }

    private boolean checkAlert() throws IOException {
        Alert alert = this.socket.checkAlert();
        if (alert == null) {
            return false;
        }
        if (alert.getLevel().equals(Alert.Level.FATAL)) {
            throw new AlertException(alert, false);
        }
        if (alert.getDescription().equals(Alert.Description.CLOSE_NOTIFY)) {
            try {
                return this.in.available() <= 0;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }
}

