/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Enumerated;
import gnu.javax.net.ssl.provider.Handshake;
import gnu.javax.net.ssl.provider.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.LinkedList;

final class CertificateRequest
implements Handshake.Body {
    private final ClientType[] types;
    private final Principal[] authorities;

    CertificateRequest(ClientType[] clientTypeArray, Principal[] principalArray) {
        if (clientTypeArray == null) {
            throw new NullPointerException();
        }
        this.types = clientTypeArray;
        if (principalArray == null) {
            throw new NullPointerException();
        }
        this.authorities = principalArray;
    }

    static CertificateRequest read(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        ClientType[] clientTypeArray = new ClientType[dataInputStream.readUnsignedByte()];
        for (int i = 0; i < clientTypeArray.length; ++i) {
            clientTypeArray[i] = ClientType.read(dataInputStream);
        }
        LinkedList linkedList = new LinkedList();
        byte[] byArray = new byte[dataInputStream.readUnsignedShort()];
        dataInputStream.readFully(byArray);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            String string = Util.getSecurityProperty("jessie.x500.class");
            if (string == null) {
                string = "org.metastatic.jessie.pki.X500Name";
            }
            Class clazz = null;
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
            Constructor constructor = clazz.getConstructor(new Class[]{new byte[0].getClass()});
            while (byteArrayInputStream.available() > 0) {
                byArray = new byte[(byteArrayInputStream.read() & 0xFF) << 8 | byteArrayInputStream.read() & 0xFF];
                byteArrayInputStream.read(byArray);
                linkedList.add(constructor.newInstance(new Object[]{byArray}));
            }
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new Error(exception.toString());
        }
        return new CertificateRequest(clientTypeArray, (Principal[])linkedList.toArray(new Principal[linkedList.size()]));
    }

    public void write(OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        outputStream.write(this.types.length);
        for (int i = 0; i < this.types.length; ++i) {
            outputStream.write(this.types[i].getValue());
        }
        try {
            Class clazz = this.authorities[0].getClass();
            Method method = clazz.getMethod("getEncoded", null);
            for (int i = 0; i < this.authorities.length; ++i) {
                byte[] byArray = (byte[])method.invoke(this.authorities[i], null);
                byteArrayOutputStream.write(byArray.length >>> 8 & 0xFF);
                byteArrayOutputStream.write(byArray.length & 0xFF);
                byteArrayOutputStream.write(byArray, 0, byArray.length);
            }
        }
        catch (Exception exception) {
            throw new Error(exception.toString());
        }
        outputStream.write(byteArrayOutputStream.size() >>> 8 & 0xFF);
        outputStream.write(byteArrayOutputStream.size() & 0xFF);
        byteArrayOutputStream.writeTo(outputStream);
    }

    ClientType[] getTypes() {
        return this.types;
    }

    String[] getTypeStrings() {
        try {
            return (String[])Util.transform(this.types, CertificateRequest.class$("java.lang.String"), "toString", null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) throws NoClassDefFoundError {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    Principal[] getAuthorities() {
        return this.authorities;
    }

    public String toString() {
        int n;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("struct {");
        printWriter.print("  types = ");
        for (n = 0; n < this.types.length; ++n) {
            printWriter.print(this.types[n]);
            if (n == this.types.length - 1) continue;
            printWriter.print(", ");
        }
        printWriter.println(";");
        printWriter.println("  authorities =");
        for (n = 0; n < this.authorities.length; ++n) {
            printWriter.print("    ");
            printWriter.print(this.authorities[n].getName());
            if (n == this.types.length - 1) continue;
            printWriter.println(",");
        }
        printWriter.println(";");
        printWriter.println("} CertificateRequest;");
        return stringWriter.toString();
    }

    static final class ClientType
    implements Enumerated {
        static final ClientType RSA_SIGN = new ClientType(1);
        static final ClientType DSS_SIGN = new ClientType(2);
        static final ClientType RSA_FIXED_DH = new ClientType(3);
        static final ClientType DSS_FIXED_DH = new ClientType(4);
        private final int value;

        ClientType(int n) {
            this.value = n;
        }

        static ClientType read(InputStream inputStream) throws IOException {
            int n = inputStream.read();
            if (n == -1) {
                throw new EOFException("unexpected end of input stream");
            }
            switch (n & 0xFF) {
                case 1: {
                    return RSA_SIGN;
                }
                case 2: {
                    return DSS_SIGN;
                }
                case 3: {
                    return RSA_FIXED_DH;
                }
                case 4: {
                    return DSS_FIXED_DH;
                }
            }
            return new ClientType(n);
        }

        public byte[] getEncoded() {
            return new byte[]{(byte)this.value};
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            switch (this.value) {
                case 1: {
                    return "rsa_sign";
                }
                case 2: {
                    return "dss_sign";
                }
                case 3: {
                    return "rsa_fixed_dh";
                }
                case 4: {
                    return "dss_fixed_dh";
                }
            }
            return "unknown(" + this.value + ")";
        }
    }
}

