/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.io;

public class PlatformHelper {
    public static final boolean isWindows = System.getProperty("os.name").indexOf("Windows") >= 0;
    public static final String separator = System.getProperty("file.separator");
    public static final char separatorChar = separator.charAt(0);
    public static final String pathSeparator = System.getProperty("path.separator");
    public static final char pathSeparatorChar = pathSeparator.charAt(0);
    public static final int INITIAL_MAX_PATH = 130;

    public static final int beginWithRootPathPrefix(String string) {
        if (string.startsWith("/") || string.startsWith("\\")) {
            return 1;
        }
        if (!isWindows) {
            return 0;
        }
        if (string.length() > 2 && Character.isLetter(string.charAt(0)) && string.charAt(1) == ':' && (string.charAt(2) == '/' || string.charAt(2) == '\\')) {
            return 3;
        }
        return 0;
    }

    public static final boolean isRootDirectory(String string) {
        int n = string.length();
        return n > 0 && PlatformHelper.beginWithRootPathPrefix(string) == n;
    }

    public static final boolean endWithSeparator(String string) {
        return string.endsWith("\\") || string.endsWith("/");
    }

    public static final String removeTailSeparator(String string) {
        if (PlatformHelper.endWithSeparator(string) && !PlatformHelper.isRootDirectory(string)) {
            return string.substring(0, string.length() - 1);
        }
        return string;
    }

    public static final int lastIndexOfSeparator(String string) {
        return Math.max(string.lastIndexOf("/"), string.lastIndexOf("\\"));
    }
}

