/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt;

import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferDouble;
import java.awt.image.DataBufferFloat;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;

public final class Buffers {
    public static DataBuffer createBuffer(int n, Object object, int n2) {
        if (object == null) {
            return Buffers.createBuffer(n, n2, 1);
        }
        return Buffers.createBufferFromData(n, object, n2);
    }

    public static DataBuffer createBuffer(int n, int n2) {
        return Buffers.createBuffer(n, n2, 1);
    }

    public static DataBuffer createBuffer(int n, int n2, int n3) {
        switch (n) {
            case 0: {
                return new DataBufferByte(n2, n3);
            }
            case 2: {
                return new DataBufferShort(n2, n3);
            }
            case 1: {
                return new DataBufferUShort(n2, n3);
            }
            case 3: {
                return new DataBufferInt(n2, n3);
            }
            case 4: {
                return new DataBufferFloat(n2, n3);
            }
            case 5: {
                return new DataBufferDouble(n2, n3);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static DataBuffer createBufferFromData(int n, Object object, int n2) {
        switch (n) {
            case 0: {
                return new DataBufferByte((byte[])object, n2);
            }
            case 2: {
                return new DataBufferShort((short[])object, n2);
            }
            case 1: {
                return new DataBufferUShort((short[])object, n2);
            }
            case 3: {
                return new DataBufferInt((int[])object, n2);
            }
            case 4: {
                return new DataBufferFloat((float[])object, n2);
            }
            case 5: {
                return new DataBufferDouble((double[])object, n2);
            }
        }
        throw new UnsupportedOperationException();
    }

    public static Object getData(DataBuffer dataBuffer) {
        return Buffers.getData(dataBuffer, 0, null, 0, dataBuffer.getSize());
    }

    public static Object getData(DataBuffer dataBuffer, int n, Object object, int n2, int n3) {
        switch (dataBuffer.getDataType()) {
            case 0: {
                if (object == null) {
                    object = new byte[n3 + n2];
                }
                for (int i = 0; i < n3; ++i) {
                    ((byte[])object)[i + n2] = (byte)dataBuffer.getElem(i + n);
                }
                break;
            }
            case 5: {
                if (object == null) {
                    object = new double[n3 + n2];
                }
                for (int i = 0; i < n3; ++i) {
                    ((double[])object)[i + n2] = dataBuffer.getElemDouble(i + n);
                }
                break;
            }
            case 4: {
                if (object == null) {
                    object = new float[n3 + n2];
                }
                for (int i = 0; i < n3; ++i) {
                    ((float[])object)[i + n2] = dataBuffer.getElemFloat(i + n);
                }
                break;
            }
            case 3: {
                if (object == null) {
                    object = new int[n3 + n2];
                }
                for (int i = 0; i < n3; ++i) {
                    ((int[])object)[i + n2] = dataBuffer.getElem(i + n);
                }
                break;
            }
            case 1: 
            case 2: {
                if (object == null) {
                    object = new short[n3 + n2];
                }
                for (int i = 0; i < n3; ++i) {
                    ((short[])object)[i + n2] = (short)dataBuffer.getElem(i + n);
                }
                break;
            }
            case 32: {
                throw new ClassCastException("Unknown data buffer type");
            }
        }
        return object;
    }

    public static int smallestAppropriateTransferType(int n) {
        if (n <= 8) {
            return 0;
        }
        if (n <= 16) {
            return 1;
        }
        if (n <= 32) {
            return 3;
        }
        return 32;
    }
}

