/*
 * Decompiled with CFR 0.152.
 */
package gnu.CORBA.CDR;

import gnu.CORBA.BigDecimalHelper;
import gnu.CORBA.CDR.AbstractDataInput;
import gnu.CORBA.CDR.BigEndianInputStream;
import gnu.CORBA.CDR.BufferredCdrInput;
import gnu.CORBA.CDR.LittleEndianInputStream;
import gnu.CORBA.CDR.gnuRuntime;
import gnu.CORBA.GIOP.CharSets_OSF;
import gnu.CORBA.GIOP.CodeSetServiceContext;
import gnu.CORBA.IOR;
import gnu.CORBA.IorDelegate;
import gnu.CORBA.OrbFunctional;
import gnu.CORBA.StubLocator;
import gnu.CORBA.TypeCodeHelper;
import gnu.CORBA.Unexpected;
import gnu.CORBA.Version;
import gnu.CORBA.gnuAny;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.math.BigDecimal;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnySeqHolder;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BooleanSeqHolder;
import org.omg.CORBA.CharSeqHolder;
import org.omg.CORBA.DataInputStream;
import org.omg.CORBA.DoubleSeqHolder;
import org.omg.CORBA.FloatSeqHolder;
import org.omg.CORBA.LongLongSeqHolder;
import org.omg.CORBA.LongSeqHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.OctetSeqHolder;
import org.omg.CORBA.ShortSeqHolder;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.ULongLongSeqHolder;
import org.omg.CORBA.ULongSeqHolder;
import org.omg.CORBA.UShortSeqHolder;
import org.omg.CORBA.WCharSeqHolder;
import org.omg.CORBA.portable.ObjectImpl;

public abstract class AbstractCdrInput
extends org.omg.CORBA_2_3.portable.InputStream
implements DataInputStream {
    public transient gnuRuntime runtime;
    protected static final String UNEXP_EOF = "Unexpected end of stream";
    protected AbstractDataInput b;
    protected InputStream actual_stream;
    protected ORB orb;
    protected Version giop;
    protected CodeSetServiceContext codeset;
    private String narrow_charset;
    private String wide_charset;
    private boolean narrow_native;
    private boolean wide_native;
    private boolean little_endian;

    private /* synthetic */ void finit$() {
        this.giop = new Version(1, 2);
        this.codeset = CodeSetServiceContext.STANDARD;
        this.narrow_charset = null;
        this.wide_charset = null;
    }

    public AbstractCdrInput(InputStream inputStream) {
        this.finit$();
        this.setInputStream(inputStream);
        this.setCodeSet(CodeSetServiceContext.STANDARD);
    }

    public AbstractCdrInput() {
        this.finit$();
        this.setCodeSet(CodeSetServiceContext.STANDARD);
    }

    public void setBigEndian(boolean bl) {
        this.little_endian = bl ^ true;
        this.setInputStream(this.actual_stream);
    }

    public boolean isBigEndian() {
        return this.little_endian ^ true;
    }

    public void cloneSettings(AbstractCdrInput abstractCdrInput) {
        abstractCdrInput.setBigEndian(this.isBigEndian());
        abstractCdrInput.setCodeSet(this.getCodeSet());
        abstractCdrInput.setVersion(this.giop);
        abstractCdrInput.setOrb(this.orb);
    }

    public void setInputStream(InputStream inputStream) {
        this.b = this.little_endian ? new LittleEndianInputStream(inputStream) : new BigEndianInputStream(inputStream);
        this.actual_stream = inputStream;
    }

    public abstract void setOffset(int var1);

    public void setOrb(ORB oRB) {
        this.orb = oRB;
    }

    public void setVersion(Version version) {
        this.giop = version;
    }

    public abstract void align(int var1);

    public long gnu_read_ulong() {
        try {
            long l = this.b.readInt();
            return l &= 0xFFFFFFFL;
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
        catch (IOException iOException) {
            throw new Unexpected(iOException);
        }
    }

    public int gnu_read_ushort() {
        try {
            this.align(2);
            return this.b.readUnsignedShort();
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
        catch (IOException iOException) {
            throw new Unexpected(iOException);
        }
    }

    public ORB orb() {
        return this.orb;
    }

    public int read() throws IOException {
        try {
            return this.b.read();
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        try {
            return this.b.read(byArray, n, n2);
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
    }

    public int read(byte[] byArray) throws IOException {
        try {
            return this.b.read(byArray);
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
    }

    public Object read_Object() {
        try {
            java.lang.Object object;
            Object object2;
            IOR iOR = new IOR();
            iOR._read_no_endian(this);
            if (iOR.Id == null) {
                return null;
            }
            if (this.orb instanceof OrbFunctional && (object2 = ((OrbFunctional)(object = (OrbFunctional)this.orb)).find_local_object(iOR)) != null) {
                return object2;
            }
            object = StubLocator.search(this.orb, iOR);
            try {
                if (((ObjectImpl)object)._get_delegate() == null) {
                    ((ObjectImpl)object)._set_delegate(new IorDelegate(this.orb, iOR));
                }
            }
            catch (BAD_OPERATION bAD_OPERATION) {
                ((ObjectImpl)object)._set_delegate(new IorDelegate(this.orb, iOR));
            }
            return object;
        }
        catch (IOException iOException) {
            MARSHAL mARSHAL = new MARSHAL();
            mARSHAL.minor = 1195573273;
            mARSHAL.initCause(iOException);
            throw mARSHAL;
        }
    }

    public TypeCode read_TypeCode() {
        try {
            return TypeCodeHelper.read(this);
        }
        catch (Bounds bounds) {
            throw new Unexpected();
        }
        catch (BadKind badKind) {
            throw new Unexpected();
        }
    }

    public Any read_any() {
        TypeCode typeCode = this.read_TypeCode();
        gnuAny gnuAny2 = new gnuAny();
        gnuAny2.read_value(this, typeCode);
        return gnuAny2;
    }

    public boolean read_boolean() {
        try {
            return this.b.read() != 0;
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
        catch (IOException iOException) {
            throw new Unexpected(iOException);
        }
    }

    public void read_boolean_array(boolean[] blArray, int n, int n2) {
        try {
            for (int i = n; i < n + n2; ++i) {
                blArray[i] = this.b.read() != 0;
            }
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
        catch (IOException iOException) {
            throw new Unexpected(iOException);
        }
    }

    public char read_char() {
        try {
            if (this.narrow_native) {
                return (char)this.b.read();
            }
            return (char)new InputStreamReader((InputStream)((org.omg.CORBA.portable.InputStream)((java.lang.Object)this.b)), this.narrow_charset).read();
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
        catch (IOException iOException) {
            throw new Unexpected(iOException);
        }
    }

    public void read_char_array(char[] cArray, int n, int n2) {
        try {
            if (this.narrow_native) {
                for (int i = n; i < n + n2; ++i) {
                    cArray[i] = (char)this.b.read();
                }
            } else {
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)((org.omg.CORBA.portable.InputStream)((java.lang.Object)this.b)), this.narrow_charset);
                inputStreamReader.read(cArray, n, n2);
            }
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
        catch (IOException iOException) {
            throw new Unexpected(iOException);
        }
    }

    public double read_double() {
        try {
            this.align(8);
            return this.b.readDouble();
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
        catch (IOException iOException) {
            throw new Unexpected();
        }
    }

    public void read_double_array(double[] dArray, int n, int n2) {
        try {
            this.align(8);
            for (int i = n; i < n + n2; ++i) {
                dArray[i] = this.b.readDouble();
            }
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
        catch (IOException iOException) {
            throw new Unexpected(iOException);
        }
    }

    public BufferredCdrInput read_encapsulation() {
        try {
            int n = this.read_long();
            byte[] byArray = new byte[n];
            for (int i = 0; i < byArray.length; i += this.read(byArray, i, byArray.length - i)) {
            }
            BufferredCdrInput bufferredCdrInput = new BufferredCdrInput(byArray);
            bufferredCdrInput.setOrb(this.orb);
            byte by = bufferredCdrInput.read_octet();
            if (by != 0) {
                bufferredCdrInput.setBigEndian(false);
            }
            return bufferredCdrInput;
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
        catch (IOException iOException) {
            throw new Unexpected(iOException);
        }
    }

    public BigDecimal read_fixed() {
        try {
            return BigDecimalHelper.read(this, 0);
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
        catch (IOException iOException) {
            throw new Unexpected(iOException);
        }
    }

    public float read_float() {
        try {
            this.align(4);
            return this.b.readFloat();
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
        catch (IOException iOException) {
            throw new Unexpected(iOException);
        }
    }

    public void read_float_array(float[] fArray, int n, int n2) {
        try {
            this.align(4);
            for (int i = n; i < n + n2; ++i) {
                fArray[i] = this.b.readFloat();
            }
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
        catch (IOException iOException) {
            throw new Unexpected(iOException);
        }
    }

    public int read_long() {
        try {
            this.align(4);
            return this.b.readInt();
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
        catch (IOException iOException) {
            throw new Unexpected(iOException);
        }
    }

    public void read_long_array(int[] nArray, int n, int n2) {
        try {
            this.align(4);
            for (int i = n; i < n + n2; ++i) {
                nArray[i] = this.b.readInt();
            }
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
        catch (IOException iOException) {
            throw new Unexpected(iOException);
        }
    }

    public long read_longlong() {
        try {
            this.align(8);
            return this.b.readLong();
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            throw mARSHAL;
        }
        catch (IOException iOException) {
            throw new Unexpected(iOException);
        }
    }

    public void read_longlong_array(long[] lArray, int n, int n2) {
        try {
            this.align(8);
            for (int i = n; i < n + n2; ++i) {
                lArray[i] = this.b.readLong();
            }
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
        catch (IOException iOException) {
            throw new Unexpected(iOException);
        }
    }

    public byte read_octet() {
        try {
            return this.b.readByte();
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
        catch (IOException iOException) {
            throw new Unexpected(iOException);
        }
    }

    public void read_octet_array(byte[] byArray, int n, int n2) {
        try {
            this.b.read(byArray, n, n2);
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
        catch (IOException iOException) {
            throw new Unexpected(iOException);
        }
    }

    public byte[] read_sequence() {
        try {
            int n = this.read_long();
            byte[] byArray = new byte[n];
            if (n > 0) {
                this.b.readFully(byArray);
            }
            return byArray;
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
        catch (IOException iOException) {
            throw new Unexpected(iOException);
        }
    }

    public short read_short() {
        try {
            this.align(2);
            return this.b.readShort();
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
        catch (IOException iOException) {
            throw new Unexpected(iOException);
        }
    }

    public void read_short_array(short[] sArray, int n, int n2) {
        try {
            this.align(2);
            for (int i = n; i < n + n2; ++i) {
                sArray[i] = this.b.readShort();
            }
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
        catch (IOException iOException) {
            throw new Unexpected(iOException);
        }
    }

    public String read_string() {
        int n = 0;
        try {
            this.align(4);
            n = this.b.readInt();
            byte[] byArray = new byte[n];
            this.b.read(byArray);
            if (this.narrow_charset == null) {
                return new String(byArray, 0, n - 1);
            }
            return new String(byArray, 0, n - 1, this.narrow_charset);
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
        catch (IOException iOException) {
            throw new Unexpected();
        }
        catch (NegativeArraySizeException negativeArraySizeException) {
            MARSHAL mARSHAL = new MARSHAL("Input stream broken, got " + n + "(0x" + Integer.toHexString(n) + ") as a string size");
            mARSHAL.minor = 1195573260;
            throw mARSHAL;
        }
    }

    public int read_ulong() {
        return this.read_long();
    }

    public void read_ulong_array(int[] nArray, int n, int n2) {
        this.read_long_array(nArray, n, n2);
    }

    public long read_ulonglong() {
        return this.read_longlong();
    }

    public void read_ulonglong_array(long[] lArray, int n, int n2) {
        this.read_longlong_array(lArray, n, n2);
    }

    public short read_ushort() {
        return this.read_short();
    }

    public void read_ushort_array(short[] sArray, int n, int n2) {
        this.read_short_array(sArray, n, n2);
    }

    public char read_wchar() {
        try {
            String string;
            if (this.giop.until_inclusive(1, 1)) {
                this.align(2);
                if (this.wide_native) {
                    return (char)this.b.readShort();
                }
                return (char)new InputStreamReader((InputStream)((org.omg.CORBA.portable.InputStream)((java.lang.Object)this.b)), this.wide_charset).read();
            }
            int n = this.b.read();
            if (n == 2 && this.wide_native) {
                return this.b.readChar();
            }
            if (n <= 0) {
                MARSHAL mARSHAL = new MARSHAL("wchar size " + n);
                mARSHAL.minor = 1195573260;
                throw mARSHAL;
            }
            byte[] byArray = new byte[n];
            this.b.readFully(byArray);
            if (byArray.length > 2 && byArray[0] == 254 && byArray[1] == 255) {
                string = new String(byArray, 2, byArray.length - 2, this.wide_charset);
            } else if (byArray.length > 2 && byArray[0] == 255 && byArray[1] == 254) {
                for (int i = 3; i < byArray.length; i += 2) {
                    byte by = byArray[i];
                    byArray[i - 1] = byArray[i];
                    byArray[i] = by;
                }
                string = new String(byArray, 2, byArray.length - 2, this.wide_charset);
            } else {
                string = new String(byArray, this.wide_charset);
            }
            return string.charAt(0);
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
        catch (IOException iOException) {
            throw new Unexpected();
        }
    }

    public void read_wchar_array(char[] cArray, int n, int n2) {
        try {
            if (this.giop.until_inclusive(1, 1)) {
                this.align(2);
            }
            if (this.wide_native) {
                for (int i = n; i < n + n2; ++i) {
                    cArray[i] = this.b.readShort();
                }
            } else {
                InputStreamReader inputStreamReader = new InputStreamReader((InputStream)((org.omg.CORBA.portable.InputStream)((java.lang.Object)this.b)), this.wide_charset);
                inputStreamReader.read(cArray, n, n2);
            }
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
        catch (IOException iOException) {
            throw new Unexpected(iOException);
        }
    }

    public String read_wstring() {
        if (this.wide_native || this.giop.until_inclusive(1, 1)) {
            return this.read_wstring_UTF_16();
        }
        try {
            this.align(4);
            int n = this.b.readInt();
            byte[] byArray = new byte[n];
            this.b.read(byArray);
            return new String(byArray, 0, n, this.wide_charset);
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
        catch (IOException iOException) {
            throw new Unexpected(iOException);
        }
    }

    public String read_wstring_UTF_16() {
        try {
            int n;
            int n2;
            int n3 = 0;
            int n4 = this.read_long();
            if (n4 < 0) {
                MARSHAL mARSHAL = new MARSHAL("Negative string size");
                mARSHAL.minor = 1195573260;
                throw mARSHAL;
            }
            int n5 = n2 = this.giop.since_inclusive(1, 2) ? 0 : 1;
            if ((n4 /= 2) == 0) {
                return "";
            }
            char[] cArray = new char[n4];
            for (n = 0; n < cArray.length; ++n) {
                cArray[n] = this.b.readShort();
            }
            if (cArray[0] == '\ufeff') {
                n3 = 1;
            } else if (cArray[0] == '\ufffe') {
                for (n = n3 = 1; n < cArray.length; ++n) {
                    cArray[n] = AbstractCdrInput.swap(cArray[n]);
                }
            }
            String string = new String(cArray, n3, n4 - n2 - n3);
            return string;
        }
        catch (EOFException eOFException) {
            MARSHAL mARSHAL = new MARSHAL(UNEXP_EOF);
            mARSHAL.minor = 1195573251;
            mARSHAL.initCause(eOFException);
            throw mARSHAL;
        }
        catch (IOException iOException) {
            throw new Unexpected(iOException);
        }
    }

    public static char swap(char c) {
        int n = c & 0xFF;
        int n2 = c >> 8 & 0xFF;
        return (char)(n << 8 | n2);
    }

    public void setCodeSet(CodeSetServiceContext codeSetServiceContext) {
        this.codeset = codeSetServiceContext;
        this.narrow_charset = CharSets_OSF.getName(this.codeset.char_data);
        this.wide_charset = CharSets_OSF.getName(this.codeset.wide_char_data);
        this.narrow_native = 65537 == this.codeset.char_data;
        this.wide_native = 65801 == this.codeset.wide_char_data;
    }

    public CodeSetServiceContext getCodeSet() {
        return this.codeset;
    }

    public Object read_Object(Class clazz) {
        return this.read_Object();
    }

    public Serializable read_Value() {
        return this.read_value();
    }

    public java.lang.Object read_Abstract() {
        return this.read_abstract_interface();
    }

    public void read_char_array(CharSeqHolder charSeqHolder, int n, int n2) {
        charSeqHolder.value = this.ensureArray(charSeqHolder.value, n, n2);
        this.read_char_array(charSeqHolder.value, n, n2);
    }

    public void read_wchar_array(WCharSeqHolder wCharSeqHolder, int n, int n2) {
        wCharSeqHolder.value = this.ensureArray(wCharSeqHolder.value, n, n2);
        this.read_wchar_array(wCharSeqHolder.value, n, n2);
    }

    private char[] ensureArray(char[] cArray, int n, int n2) {
        if (cArray == null) {
            return new char[n + n2];
        }
        if (cArray.length < n + n2) {
            char[] cArray2 = new char[n + n2];
            System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
            return cArray2;
        }
        return cArray;
    }

    public void read_ulong_array(ULongSeqHolder uLongSeqHolder, int n, int n2) {
        uLongSeqHolder.value = this.ensureArray(uLongSeqHolder.value, n, n2);
        this.read_ulong_array(uLongSeqHolder.value, n, n2);
    }

    public void read_long_array(LongSeqHolder longSeqHolder, int n, int n2) {
        longSeqHolder.value = this.ensureArray(longSeqHolder.value, n, n2);
        this.read_ulong_array(longSeqHolder.value, n, n2);
    }

    private int[] ensureArray(int[] nArray, int n, int n2) {
        if (nArray == null) {
            return new int[n + n2];
        }
        if (nArray.length < n + n2) {
            int[] nArray2 = new int[n + n2];
            System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
            return nArray2;
        }
        return nArray;
    }

    public void read_float_array(FloatSeqHolder floatSeqHolder, int n, int n2) {
        floatSeqHolder.value = this.ensureArray(floatSeqHolder.value, n, n2);
        this.read_float_array(floatSeqHolder.value, n, n2);
    }

    private float[] ensureArray(float[] fArray, int n, int n2) {
        if (fArray == null) {
            return new float[n + n2];
        }
        if (fArray.length < n + n2) {
            float[] fArray2 = new float[n + n2];
            System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
            return fArray2;
        }
        return fArray;
    }

    public void read_double_array(DoubleSeqHolder doubleSeqHolder, int n, int n2) {
        doubleSeqHolder.value = this.ensureArray(doubleSeqHolder.value, n, n2);
        this.read_double_array(doubleSeqHolder.value, n, n2);
    }

    private double[] ensureArray(double[] dArray, int n, int n2) {
        if (dArray == null) {
            return new double[n + n2];
        }
        if (dArray.length < n + n2) {
            double[] dArray2 = new double[n + n2];
            System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
            return dArray2;
        }
        return dArray;
    }

    public void read_short_array(ShortSeqHolder shortSeqHolder, int n, int n2) {
        shortSeqHolder.value = this.ensureArray(shortSeqHolder.value, n, n2);
        this.read_short_array(shortSeqHolder.value, n, n2);
    }

    public void read_ushort_array(UShortSeqHolder uShortSeqHolder, int n, int n2) {
        uShortSeqHolder.value = this.ensureArray(uShortSeqHolder.value, n, n2);
        this.read_ushort_array(uShortSeqHolder.value, n, n2);
    }

    private short[] ensureArray(short[] sArray, int n, int n2) {
        if (sArray == null) {
            return new short[n + n2];
        }
        if (sArray.length < n + n2) {
            short[] sArray2 = new short[n + n2];
            System.arraycopy(sArray, 0, sArray2, 0, sArray.length);
            return sArray2;
        }
        return sArray;
    }

    public void read_octet_array(OctetSeqHolder octetSeqHolder, int n, int n2) {
        octetSeqHolder.value = this.ensureArray(octetSeqHolder.value, n, n2);
        this.read_octet_array(octetSeqHolder.value, n, n2);
    }

    private byte[] ensureArray(byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return new byte[n + n2];
        }
        if (byArray.length < n + n2) {
            byte[] byArray2 = new byte[n + n2];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            return byArray2;
        }
        return byArray;
    }

    public void read_longlong_array(LongLongSeqHolder longLongSeqHolder, int n, int n2) {
        longLongSeqHolder.value = this.ensureArray(longLongSeqHolder.value, n, n2);
        this.read_longlong_array(longLongSeqHolder.value, n, n2);
    }

    public void read_ulonglong_array(ULongLongSeqHolder uLongLongSeqHolder, int n, int n2) {
        uLongLongSeqHolder.value = this.ensureArray(uLongLongSeqHolder.value, n, n2);
        this.read_ulonglong_array(uLongLongSeqHolder.value, n, n2);
    }

    private long[] ensureArray(long[] lArray, int n, int n2) {
        if (lArray == null) {
            return new long[n + n2];
        }
        if (lArray.length < n + n2) {
            long[] lArray2 = new long[n + n2];
            System.arraycopy(lArray, 0, lArray2, 0, lArray.length);
            return lArray2;
        }
        return lArray;
    }

    public void read_boolean_array(BooleanSeqHolder booleanSeqHolder, int n, int n2) {
        booleanSeqHolder.value = this.ensureArray(booleanSeqHolder.value, n, n2);
        this.read_boolean_array(booleanSeqHolder.value, n, n2);
    }

    private boolean[] ensureArray(boolean[] blArray, int n, int n2) {
        if (blArray == null) {
            return new boolean[n + n2];
        }
        if (blArray.length < n + n2) {
            boolean[] blArray2 = new boolean[n + n2];
            System.arraycopy(blArray, 0, blArray2, 0, blArray.length);
            return blArray2;
        }
        return blArray;
    }

    public void read_any_array(AnySeqHolder anySeqHolder, int n, int n2) {
        anySeqHolder.value = this.ensureArray(anySeqHolder.value, n, n2);
        for (int i = n; i < n + n2; ++i) {
            anySeqHolder.value[i] = this.read_any();
        }
    }

    private Any[] ensureArray(Any[] anyArray, int n, int n2) {
        if (anyArray == null) {
            return new Any[n + n2];
        }
        if (anyArray.length < n + n2) {
            Any[] anyArray2 = new Any[n + n2];
            System.arraycopy(anyArray, 0, anyArray2, 0, anyArray.length);
            return anyArray2;
        }
        return anyArray;
    }

    public String[] _truncatable_ids() {
        return new String[]{"IDL:omg.org/CORBA/DataInputStream:1.0"};
    }
}

