/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JPasswordField;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.FieldView;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.Utilities;

public class PasswordView
extends FieldView {
    private char[] oneCharBuffer;

    private /* synthetic */ void finit$() {
        this.oneCharBuffer = new char[1];
    }

    public PasswordView(Element element) {
        super(element);
        this.finit$();
    }

    protected int drawEchoCharacter(Graphics graphics, int n, int n2, char c) {
        this.updateMetrics();
        this.oneCharBuffer[0] = c;
        graphics.drawChars(this.oneCharBuffer, 0, 1, n, n2);
        return n + this.metrics.charWidth(c);
    }

    private char getEchoChar() {
        char c = ((JPasswordField)this.getContainer()).getEchoChar();
        if (c == '\u0000') {
            c = '*';
        }
        return (char)c;
    }

    protected int drawSelectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        this.updateMetrics();
        char c = this.getEchoChar();
        graphics.setColor(this.selectedColor);
        graphics.setColor(Color.BLACK);
        for (int i = n3; i < n4; ++i) {
            n = this.drawEchoCharacter(graphics, n, n2, c);
        }
        return n;
    }

    protected int drawUnselectedText(Graphics graphics, int n, int n2, int n3, int n4) throws BadLocationException {
        this.updateMetrics();
        char c = this.getEchoChar();
        graphics.setColor(this.unselectedColor);
        graphics.setColor(Color.BLACK);
        for (int i = n3; i < n4; ++i) {
            n = this.drawEchoCharacter(graphics, n, n2, c);
        }
        return n;
    }

    public float getPreferredSpan(int n) {
        String string;
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException();
        }
        FontMetrics fontMetrics = this.getFontMetrics();
        if (n == 1) {
            return fontMetrics.getHeight();
        }
        Element element = this.getElement();
        try {
            string = element.getDocument().getText(element.getStartOffset(), element.getEndOffset());
        }
        catch (BadLocationException badLocationException) {
            string = "";
        }
        return fontMetrics.stringWidth(string);
    }

    public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
        int n2;
        Shape shape2 = this.adjustAllocation(shape);
        this.updateMetrics();
        int n3 = this.getElement().getElementIndex(n);
        Rectangle rectangle = this.lineToRect(shape2, n3);
        Element element = this.getElement().getElement(n3);
        int n4 = element.getStartOffset();
        Segment segment = this.getLineBuffer();
        segment.array = new char[n - n4];
        char c = this.getEchoChar();
        for (n2 = 0; n2 < segment.array.length; ++n2) {
            segment.array[n2] = c;
        }
        segment.offset = 0;
        segment.count = segment.array.length;
        n2 = Utilities.getTabbedTextWidth(segment, this.metrics, rectangle.x, this, n4);
        rectangle.x += n2;
        rectangle.width = 1;
        rectangle.height = this.metrics.getHeight();
        return rectangle;
    }

    public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
        return super.viewToModel(f, f2, shape, biasArray);
    }
}

