/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.Certificate;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public abstract class JarURLConnection
extends URLConnection {
    private final URL jarFileURL;
    protected URLConnection jarFileURLConnection;
    private final String entryName;

    protected JarURLConnection(URL uRL) throws MalformedURLException {
        super(uRL);
        if (!uRL.getProtocol().equals("jar")) {
            throw new MalformedURLException(uRL + ": Not jar protocol.");
        }
        String string = uRL.getFile();
        int n = string.indexOf("!/");
        if (n == -1) {
            throw new MalformedURLException(uRL + ": No `!/' in spec.");
        }
        this.jarFileURL = new URL(string.substring(0, n));
        this.entryName = string.length() == n + 2 ? null : string.substring(n + 2);
    }

    public URL getJarFileURL() {
        return this.jarFileURL;
    }

    public String getEntryName() {
        return this.entryName;
    }

    public JarEntry getJarEntry() throws IOException {
        if (this.entryName == null) {
            return null;
        }
        JarFile jarFile = this.getJarFile();
        if (jarFile != null) {
            return jarFile.getJarEntry(this.entryName);
        }
        return null;
    }

    public abstract JarFile getJarFile() throws IOException;

    public Certificate[] getCertificates() throws IOException {
        JarEntry jarEntry = this.getJarEntry();
        if (jarEntry != null) {
            return jarEntry.getCertificates();
        }
        return null;
    }

    public Attributes getMainAttributes() throws IOException {
        Manifest manifest = this.getManifest();
        if (manifest != null) {
            return manifest.getMainAttributes();
        }
        return null;
    }

    public Attributes getAttributes() throws IOException {
        JarEntry jarEntry = this.getJarEntry();
        if (jarEntry != null) {
            return jarEntry.getAttributes();
        }
        return null;
    }

    public Manifest getManifest() throws IOException {
        JarFile jarFile = this.getJarFile();
        if (jarFile != null) {
            return jarFile.getManifest();
        }
        return null;
    }
}

