/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.gcj.convert.BytesToCharsetAdaptor;
import gnu.gcj.convert.BytesToUnicode;
import java.io.BufferedInputStream;
import java.io.CharConversionException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;

public class InputStreamReader
extends Reader {
    BufferedInputStream in;
    char[] work;
    int wpos;
    int wcount;
    BytesToUnicode converter;

    public InputStreamReader(InputStream inputStream) {
        this(inputStream, BytesToUnicode.getDefaultDecoder());
    }

    public InputStreamReader(InputStream inputStream, String string) throws UnsupportedEncodingException {
        this(inputStream, BytesToUnicode.getDecoder(string));
    }

    public InputStreamReader(InputStream inputStream, Charset charset) {
        this(inputStream, new BytesToCharsetAdaptor(charset));
    }

    public InputStreamReader(InputStream inputStream, CharsetDecoder charsetDecoder) {
        this(inputStream, new BytesToCharsetAdaptor(charsetDecoder));
    }

    private InputStreamReader(InputStream inputStream, BytesToUnicode bytesToUnicode) {
        this.in = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        this.lock = inputStream;
        this.converter = bytesToUnicode;
        this.converter.setInput(this.in.buf, 0, 0);
    }

    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.in != null) {
                    this.in.close();
                }
                this.in = null;
                this.work = null;
                this.wcount = 0;
                this.wpos = 0;
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }

    public String getEncoding() {
        if (this.in != null) {
            return this.converter.getName();
        }
        return null;
    }

    public boolean ready() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            boolean bl;
            try {
                if (this.in == null) {
                    throw new IOException("Stream closed");
                }
                if (this.wpos < this.wcount) {
                    boolean bl2 = true;
                    Object var3_4 = null;
                    return bl2;
                }
                bl = this.in.available() > 0;
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                throw throwable;
            }
            Object var3_5 = null;
            return bl;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read(char[] cArray, int n, int n2) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.in == null) {
                    throw new IOException("Stream closed");
                }
                if (n2 == 0) {
                    return 0;
                }
                int n3 = this.wcount - this.wpos;
                if (n3 <= 0) {
                    return this.refill(cArray, n, n2);
                }
                if (n2 > n3) {
                    n2 = n3;
                }
                System.arraycopy(this.work, this.wpos, cArray, n, n2);
                this.wpos += n2;
                return n2;
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                throw throwable;
            }
        }
    }

    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            char c;
            try {
                if (this.in == null) {
                    throw new IOException("Stream closed");
                }
                int n = this.wcount - this.wpos;
                if (n <= 0) {
                    int n2;
                    this.wcount = 0;
                    this.wpos = 0;
                    if (this.work == null) {
                        this.work = new char[100];
                    }
                    if ((n2 = this.refill(this.work, 0, this.work.length)) == -1) {
                        int n3 = -1;
                        Object var5_6 = null;
                        return n3;
                    }
                    this.wcount += n2;
                }
                c = this.work[this.wpos++];
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                throw throwable;
            }
            Object var5_7 = null;
            return c;
        }
    }

    private int refill(char[] cArray, int n, int n2) throws IOException {
        int n3;
        while (true) {
            boolean bl;
            boolean bl2 = bl = this.in.pos < this.in.count || this.in.refill();
            if (!bl) {
                return -1;
            }
            this.converter.setInput(this.in.buf, this.in.pos, this.in.count);
            n3 = this.converter.read(cArray, n, n2);
            if (n3 == 0 && this.converter.inpos == this.in.pos) {
                this.in.mark(this.in.count);
                if (!this.in.refill()) {
                    throw new CharConversionException();
                }
                this.in.reset();
                continue;
            }
            this.in.skip(this.converter.inpos - this.in.pos);
            if (n3 > 0) break;
        }
        return n3;
    }
}

