/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import gnu.classpath.NotImplementedException;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.FlavorTable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public final class SystemFlavorMap
implements FlavorMap,
FlavorTable {
    private static final Map systemFlavorMaps = new WeakHashMap();
    private static final String GNU_JAVA_MIME_PREFIX = "gnu.java:";
    private HashMap nativeToFlavorMap;
    private HashMap flavorToNativeMap;

    private /* synthetic */ void finit$() {
        this.nativeToFlavorMap = new HashMap();
        this.flavorToNativeMap = new HashMap();
    }

    private SystemFlavorMap() {
        this.finit$();
    }

    public Map getNativesForFlavors(DataFlavor[] dataFlavorArray) {
        return new HashMap();
    }

    public Map getFlavorsForNatives(String[] stringArray) {
        return new HashMap();
    }

    public static FlavorMap getDefaultFlavorMap() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        Map map = systemFlavorMaps;
        synchronized (map) {
            try {
                FlavorMap flavorMap = (FlavorMap)systemFlavorMaps.get(classLoader);
                if (flavorMap == null) {
                    flavorMap = new SystemFlavorMap();
                    systemFlavorMaps.put(classLoader, flavorMap);
                }
                FlavorMap flavorMap2 = flavorMap;
                Object var4_4 = null;
                return flavorMap2;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                throw throwable;
            }
        }
    }

    public static String encodeJavaMIMEType(String string) {
        if (string != null) {
            return GNU_JAVA_MIME_PREFIX + string;
        }
        return null;
    }

    public static String encodeDataFlavor(DataFlavor dataFlavor) {
        if (dataFlavor != null) {
            return SystemFlavorMap.encodeJavaMIMEType(dataFlavor.getMimeType());
        }
        return null;
    }

    public static boolean isJavaMIMEType(String string) {
        return string != null && string.startsWith(GNU_JAVA_MIME_PREFIX);
    }

    public static String decodeJavaMIMEType(String string) {
        if (SystemFlavorMap.isJavaMIMEType(string)) {
            return string.substring(GNU_JAVA_MIME_PREFIX.length());
        }
        return null;
    }

    public static DataFlavor decodeDataFlavor(String string) throws ClassNotFoundException {
        String string2 = SystemFlavorMap.decodeJavaMIMEType(string);
        if (string2 != null) {
            return new DataFlavor(string2);
        }
        return null;
    }

    public List getFlavorsForNative(String string) throws NotImplementedException {
        throw new Error("Not implemented");
    }

    public List getNativesForFlavor(DataFlavor dataFlavor) throws NotImplementedException {
        throw new Error("Not implemented");
    }

    public synchronized void addFlavorForUnencodedNative(String string, DataFlavor dataFlavor) {
        if (string == null || dataFlavor == null) {
            throw new NullPointerException();
        }
        List list2 = (List)this.nativeToFlavorMap.get(string);
        if (list2 == null) {
            list2 = new ArrayList();
            this.nativeToFlavorMap.put(string, list2);
        } else if (!list2.contains(dataFlavor)) {
            list2.add(dataFlavor);
        }
    }

    public synchronized void addUnencodedNativeForFlavor(DataFlavor dataFlavor, String string) {
        if (string == null || dataFlavor == null) {
            throw new NullPointerException();
        }
        List list2 = (List)this.flavorToNativeMap.get(dataFlavor);
        if (list2 == null) {
            list2 = new ArrayList();
            this.flavorToNativeMap.put(dataFlavor, list2);
        } else if (!list2.contains(string)) {
            list2.add(string);
        }
    }

    public synchronized void setNativesForFlavor(DataFlavor dataFlavor, String[] stringArray) {
        if (stringArray == null || dataFlavor == null) {
            throw new NullPointerException();
        }
        this.flavorToNativeMap.remove(dataFlavor);
        for (int i = 0; i < stringArray.length; ++i) {
            this.addUnencodedNativeForFlavor(dataFlavor, stringArray[i]);
        }
    }

    public synchronized void setFlavorsForNative(String string, DataFlavor[] dataFlavorArray) {
        if (string == null || dataFlavorArray == null) {
            throw new NullPointerException();
        }
        this.nativeToFlavorMap.remove(string);
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            this.addFlavorForUnencodedNative(string, dataFlavorArray[i]);
        }
    }

    static {
        GNU_JAVA_MIME_PREFIX = GNU_JAVA_MIME_PREFIX;
    }
}

