/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.util.WeakHashMap;

class LightweightDispatcher {
    private static WeakHashMap instances = new WeakHashMap();
    private Component dragTarget;
    private int dragButton;
    private Component lastTarget;

    static LightweightDispatcher getInstance() {
        Thread thread = Thread.currentThread();
        ThreadGroup threadGroup = thread.getThreadGroup();
        LightweightDispatcher lightweightDispatcher = (LightweightDispatcher)instances.get(threadGroup);
        if (lightweightDispatcher == null) {
            lightweightDispatcher = new LightweightDispatcher();
            instances.put(threadGroup, lightweightDispatcher);
        }
        return lightweightDispatcher;
    }

    private LightweightDispatcher() {
    }

    public boolean dispatchEvent(AWTEvent aWTEvent) {
        if (aWTEvent instanceof MouseEvent && aWTEvent.getSource() instanceof Window) {
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            return this.handleMouseEvent(mouseEvent);
        }
        return false;
    }

    private boolean handleMouseEvent(MouseEvent mouseEvent) {
        Window window = (Window)mouseEvent.getSource();
        Component component = window.findComponentAt(mouseEvent.getX(), mouseEvent.getY());
        if (component == null) {
            return false;
        }
        Container container = component.getParent();
        Point point = mouseEvent.getPoint();
        point = this.convertPointToChild(window, point, container);
        Component component2 = null;
        if (container != null) {
            component2 = this.findTarget(container, point);
            while (component2 == null && container != null) {
                if (container.mouseListener != null || container.mouseMotionListener != null || (container.eventMask & (long)48) != 0L) {
                    component2 = container;
                    continue;
                }
                container = container.getParent();
            }
        }
        if (component2 == null || component2.isLightweight()) {
            Point point2;
            if (component2 != this.lastTarget) {
                MouseEvent mouseEvent2;
                if (this.lastTarget != null) {
                    point2 = this.convertPointToChild(window, mouseEvent.getPoint(), this.lastTarget);
                    mouseEvent2 = new MouseEvent(this.lastTarget, 505, mouseEvent.getWhen(), mouseEvent.getModifiers(), point2.x, point2.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    this.lastTarget.dispatchEvent(mouseEvent2);
                }
                if (component2 != null) {
                    point2 = this.convertPointToChild(window, mouseEvent.getPoint(), component2);
                    mouseEvent2 = new MouseEvent(component2, 504, mouseEvent.getWhen(), mouseEvent.getModifiers(), point2.x, point2.y, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                    component2.dispatchEvent(mouseEvent2);
                }
            }
            switch (mouseEvent.getID()) {
                case 501: {
                    if (this.dragTarget == null) {
                        this.lastTarget = this.dragTarget = component2;
                        this.dragButton = mouseEvent.getButton();
                        break;
                    }
                    return false;
                }
                case 502: {
                    if (this.dragTarget != null && this.dragButton == mouseEvent.getButton()) {
                        if (this.dragTarget.isVisible()) {
                            component2 = this.dragTarget;
                        }
                        this.dragTarget = null;
                    }
                    this.lastTarget = component2;
                    break;
                }
                case 500: {
                    component2 = this.lastTarget;
                    break;
                }
                case 506: {
                    this.lastTarget = component2;
                    component2 = this.dragTarget;
                    break;
                }
                default: {
                    this.lastTarget = component2;
                }
            }
            if (component2 != null) {
                point2 = this.convertPointToChild(window, mouseEvent.getPoint(), component2);
                int n = point2.x - mouseEvent.getX();
                int n2 = point2.y - mouseEvent.getY();
                mouseEvent.translatePoint(n, n2);
                mouseEvent.setSource(component2);
                component2.dispatchEvent(mouseEvent);
                mouseEvent.setSource(window);
                mouseEvent.translatePoint(-n, -n2);
            }
            return true;
        }
        return false;
    }

    private Component findTarget(Container container, Point point) {
        int n = container.getComponentCount();
        Component component = null;
        if (container != null) {
            for (int i = 0; i < n; ++i) {
                Component component2 = container.getComponent(i);
                if (!component2.isShowing() || !component2.contains(point.x - component2.getX(), point.y - component2.getY()) || component2.mouseListener == null && component2.mouseMotionListener == null && (component2.eventMask & (long)48) == 0L) continue;
                component = component2;
                break;
            }
        }
        return component;
    }

    private Point convertPointToChild(Component component, Point point, Component component2) {
        int n = 0;
        int n2 = 0;
        for (Component component3 = component2; component3 != null && component3 != component; component3 = component3.getParent()) {
            n += component3.getX();
            n2 += component3.getY();
        }
        point.x -= n;
        point.y -= n2;
        return point;
    }
}

