/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;

public class CombinedClassLoader
extends ClassLoader {
    ClassLoader[] loaders;

    public CombinedClassLoader(Collection collection) {
        ArrayList arrayList = new ArrayList(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object == null || arrayList.contains(object)) continue;
            arrayList.add(object);
        }
        this.loaders = new ClassLoader[arrayList.size()];
        for (int i = 0; i < this.loaders.length; ++i) {
            this.loaders[i] = (ClassLoader)arrayList.get(i);
        }
    }

    protected Class findClass(String string) throws ClassNotFoundException {
        for (int i = 0; i < this.loaders.length; ++i) {
            try {
                return this.loaders[i].loadClass(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
        }
        return super.findClass(string);
    }

    protected URL findResource(String string) {
        for (int i = 0; i < this.loaders.length; ++i) {
            URL uRL = this.loaders[i].getResource(string);
            if (uRL == null) continue;
            return uRL;
        }
        return super.findResource(string);
    }

    protected Enumeration findResources(String string) throws IOException {
        for (int i = 0; i < this.loaders.length; ++i) {
            Enumeration enumeration = this.loaders[i].getResources(string);
            if (enumeration == null) continue;
            return enumeration;
        }
        return super.findResources(string);
    }
}

