/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.net.protocol.ftp;

import gnu.java.net.CRLFInputStream;
import gnu.java.net.CRLFOutputStream;
import gnu.java.net.EmptyX509TrustManager;
import gnu.java.net.LineInputStream;
import gnu.java.net.protocol.ftp.ActiveModeDTP;
import gnu.java.net.protocol.ftp.DTP;
import gnu.java.net.protocol.ftp.FTPException;
import gnu.java.net.protocol.ftp.FTPResponse;
import gnu.java.net.protocol.ftp.PassiveModeDTP;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class FTPConnection {
    public static final int FTP_PORT = 21;
    public static final int FTP_DATA_PORT = 20;
    protected static final String USER = "USER";
    protected static final String PASS = "PASS";
    protected static final String ACCT = "ACCT";
    protected static final String CWD = "CWD";
    protected static final String CDUP = "CDUP";
    protected static final String SMNT = "SMNT";
    protected static final String REIN = "REIN";
    protected static final String QUIT = "QUIT";
    protected static final String PORT = "PORT";
    protected static final String PASV = "PASV";
    protected static final String TYPE = "TYPE";
    protected static final String STRU = "STRU";
    protected static final String MODE = "MODE";
    protected static final String RETR = "RETR";
    protected static final String STOR = "STOR";
    protected static final String STOU = "STOU";
    protected static final String APPE = "APPE";
    protected static final String ALLO = "ALLO";
    protected static final String REST = "REST";
    protected static final String RNFR = "RNFR";
    protected static final String RNTO = "RNTO";
    protected static final String ABOR = "ABOR";
    protected static final String DELE = "DELE";
    protected static final String RMD = "RMD";
    protected static final String MKD = "MKD";
    protected static final String PWD = "PWD";
    protected static final String LIST = "LIST";
    protected static final String NLST = "NLST";
    protected static final String SITE = "SITE";
    protected static final String SYST = "SYST";
    protected static final String STAT = "STAT";
    protected static final String HELP = "HELP";
    protected static final String NOOP = "NOOP";
    protected static final String AUTH = "AUTH";
    protected static final String PBSZ = "PBSZ";
    protected static final String PROT = "PROT";
    protected static final String CCC = "CCC";
    protected static final String TLS = "TLS";
    public static final int TYPE_ASCII = 1;
    public static final int TYPE_EBCDIC = 2;
    public static final int TYPE_BINARY = 3;
    public static final int STRUCTURE_FILE = 1;
    public static final int STRUCTURE_RECORD = 2;
    public static final int STRUCTURE_PAGE = 3;
    public static final int MODE_STREAM = 1;
    public static final int MODE_BLOCK = 2;
    public static final int MODE_COMPRESSED = 3;
    private static final String US_ASCII = "US-ASCII";
    protected Socket socket;
    protected LineInputStream in;
    protected CRLFOutputStream out;
    protected int connectionTimeout;
    protected int timeout;
    protected boolean debug;
    protected DTP dtp;
    protected int representationType;
    protected int fileStructure;
    protected int transferMode;
    protected boolean passive;

    private /* synthetic */ void finit$() {
        this.representationType = 1;
        this.fileStructure = 1;
        this.transferMode = 1;
        this.passive = false;
    }

    public FTPConnection(String string) throws UnknownHostException, IOException {
        this(string, -1, 0, 0, false);
    }

    public FTPConnection(String string, int n) throws UnknownHostException, IOException {
        this(string, n, 0, 0, false);
    }

    public FTPConnection(String string, int n, int n2, int n3, boolean bl) throws UnknownHostException, IOException {
        this.finit$();
        this.connectionTimeout = n2;
        this.timeout = n3;
        this.debug = bl;
        if (n <= 0) {
            n = 21;
        }
        this.socket = new Socket();
        InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
        if (n2 > 0) {
            this.socket.connect(inetSocketAddress, n2);
        } else {
            this.socket.connect(inetSocketAddress);
        }
        if (n3 > 0) {
            this.socket.setSoTimeout(n3);
        }
        InputStream inputStream = this.socket.getInputStream();
        inputStream = new BufferedInputStream(inputStream);
        inputStream = new CRLFInputStream(inputStream);
        this.in = new LineInputStream(inputStream);
        OutputStream outputStream = this.socket.getOutputStream();
        outputStream = new BufferedOutputStream(outputStream);
        this.out = new CRLFOutputStream(outputStream);
        FTPResponse fTPResponse = this.getResponse();
        if (fTPResponse.getCode() != 220) {
            throw new FTPException(fTPResponse);
        }
    }

    public boolean authenticate(String string, String string2) throws IOException {
        String string3 = "USER " + string;
        this.send(string3);
        FTPResponse fTPResponse = this.getResponse();
        switch (fTPResponse.getCode()) {
            case 230: {
                return true;
            }
            case 331: {
                break;
            }
            case 332: 
            case 530: {
                return false;
            }
            default: {
                throw new FTPException(fTPResponse);
            }
        }
        string3 = "PASS " + string2;
        this.send(string3);
        fTPResponse = this.getResponse();
        switch (fTPResponse.getCode()) {
            case 202: 
            case 230: {
                return true;
            }
            case 332: 
            case 530: {
                return false;
            }
        }
        throw new FTPException(fTPResponse);
    }

    public boolean starttls(boolean bl) throws IOException {
        return this.starttls(bl, new EmptyX509TrustManager());
    }

    public boolean starttls(boolean bl, TrustManager trustManager) throws IOException {
        try {
            SSLContext sSLContext = SSLContext.getInstance(TLS);
            TrustManager[] trustManagerArray = new TrustManager[]{trustManager};
            sSLContext.init(null, trustManagerArray, null);
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            this.send("AUTH TLS");
            FTPResponse fTPResponse = this.getResponse();
            switch (fTPResponse.getCode()) {
                case 431: 
                case 500: 
                case 502: 
                case 504: 
                case 534: {
                    return false;
                }
                case 234: {
                    break;
                }
                default: {
                    throw new FTPException(fTPResponse);
                }
            }
            String string = this.socket.getInetAddress().getHostName();
            int n = this.socket.getPort();
            SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(this.socket, string, n, true);
            String[] stringArray = new String[]{"TLSv1", "SSLv3"};
            sSLSocket.setEnabledProtocols(stringArray);
            sSLSocket.setUseClientMode(true);
            sSLSocket.startHandshake();
            this.send("PBSZ 2147483647");
            fTPResponse = this.getResponse();
            switch (fTPResponse.getCode()) {
                case 501: 
                case 503: {
                    return false;
                }
                case 200: {
                    break;
                }
                default: {
                    throw new FTPException(fTPResponse);
                }
            }
            this.send("PROT " + (bl ? (char)'P' : 'C'));
            fTPResponse = this.getResponse();
            switch (fTPResponse.getCode()) {
                case 503: 
                case 504: 
                case 536: {
                    return false;
                }
                case 200: {
                    break;
                }
                default: {
                    throw new FTPException(fTPResponse);
                }
            }
            if (bl) {
                InputStream inputStream = sSLSocket.getInputStream();
                inputStream = new BufferedInputStream(inputStream);
                inputStream = new CRLFInputStream(inputStream);
                this.in = new LineInputStream(inputStream);
                OutputStream outputStream = sSLSocket.getOutputStream();
                outputStream = new BufferedOutputStream(outputStream);
                this.out = new CRLFOutputStream(outputStream);
            }
            return true;
        }
        catch (GeneralSecurityException generalSecurityException) {
            return false;
        }
    }

    public boolean changeWorkingDirectory(String string) throws IOException {
        if (string.length() == 0) {
            return true;
        }
        String string2 = "CWD " + string;
        this.send(string2);
        FTPResponse fTPResponse = this.getResponse();
        switch (fTPResponse.getCode()) {
            case 250: {
                return true;
            }
            case 550: {
                return false;
            }
        }
        throw new FTPException(fTPResponse);
    }

    public boolean changeToParentDirectory() throws IOException {
        this.send(CDUP);
        FTPResponse fTPResponse = this.getResponse();
        switch (fTPResponse.getCode()) {
            case 250: {
                return true;
            }
            case 550: {
                return false;
            }
        }
        throw new FTPException(fTPResponse);
    }

    public void reinitialize() throws IOException {
        this.send(REIN);
        FTPResponse fTPResponse = this.getResponse();
        if (fTPResponse.getCode() == 220) {
            if (this.dtp != null) {
                this.dtp.complete();
                this.dtp = null;
            }
        } else {
            throw new FTPException(fTPResponse);
        }
    }

    public void logout() throws IOException {
        this.send(QUIT);
        try {
            this.getResponse();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (this.dtp != null) {
            this.dtp.complete();
            this.dtp = null;
        }
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void initialiseDTP() throws IOException {
        if (this.dtp != null) {
            this.dtp.complete();
            this.dtp = null;
        }
        InetAddress inetAddress = this.socket.getLocalAddress();
        if (this.passive) {
            this.send(PASV);
            FTPResponse fTPResponse = this.getResponse();
            if (fTPResponse.getCode() != 227) throw new FTPException(fTPResponse);
            String string = fTPResponse.getMessage();
            try {
                int n;
                int n2 = string.indexOf(44);
                char c = string.charAt(n2 - 1);
                while (c >= '0' && c <= '9') {
                    c = string.charAt(--n2 - 1);
                }
                int n3 = n2;
                for (n = 0; n < 4; ++n) {
                    n3 = string.indexOf(44, n3 + 1);
                }
                n = string.indexOf(44, n3 + 1);
                if (n3 == -1 || n < n3) {
                    throw new ProtocolException("Malformed 227: " + string);
                }
                int n4 = n;
                c = string.charAt(n4 + 1);
                while (c >= '0' && c <= '9') {
                    c = string.charAt(++n4 + 1);
                }
                String string2 = string.substring(n2, n3).replace(',', '.');
                int n5 = Integer.parseInt(string.substring(n3 + 1, n));
                int n6 = Integer.parseInt(string.substring(n + 1, n4 + 1));
                int n7 = n5 << 8 | n6;
                this.dtp = new PassiveModeDTP(string2, n7, inetAddress, this.connectionTimeout, this.timeout);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new ProtocolException(arrayIndexOutOfBoundsException.getMessage() + ": " + string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ProtocolException(numberFormatException.getMessage() + ": " + string);
            }
        } else {
            int n;
            int n8;
            int n9 = this.socket.getLocalPort() + 1;
            int n10 = 0;
            while (this.dtp == null) {
                try {
                    this.dtp = new ActiveModeDTP(inetAddress, n9, this.connectionTimeout, this.timeout);
                }
                catch (BindException bindException) {
                    ++n9;
                    if (++n10 <= 9) continue;
                    throw bindException;
                }
            }
            StringBuffer stringBuffer = new StringBuffer(PORT);
            stringBuffer.append(' ');
            byte[] byArray = inetAddress.getAddress();
            for (n8 = 0; n8 < byArray.length; ++n8) {
                n = byArray[n8];
                if (n < 0) {
                    n += 256;
                }
                stringBuffer.append(n);
                stringBuffer.append(',');
            }
            n8 = (n9 & 0xFF00) >> 8;
            n = n9 & 0xFF;
            stringBuffer.append(n8);
            stringBuffer.append(',');
            stringBuffer.append(n);
            this.send(stringBuffer.toString());
            FTPResponse fTPResponse = this.getResponse();
            if (fTPResponse.getCode() != 200) {
                this.dtp.abort();
                this.dtp = null;
                throw new FTPException(fTPResponse);
            }
        }
        this.dtp.setTransferMode(this.transferMode);
    }

    public void setPassive(boolean bl) throws IOException {
        if (this.passive != bl) {
            this.passive = bl;
            this.initialiseDTP();
        }
    }

    public int getRepresentationType() {
        return this.representationType;
    }

    public void setRepresentationType(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(TYPE);
        stringBuffer.append(' ');
        switch (n) {
            case 1: {
                stringBuffer.append('A');
                break;
            }
            case 2: {
                stringBuffer.append('E');
                break;
            }
            case 3: {
                stringBuffer.append('I');
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(n));
            }
        }
        this.send(stringBuffer.toString());
        FTPResponse fTPResponse = this.getResponse();
        if (fTPResponse.getCode() != 200) {
            throw new FTPException(fTPResponse);
        }
        this.representationType = n;
    }

    public int getFileStructure() {
        return this.fileStructure;
    }

    public void setFileStructure(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(STRU);
        stringBuffer.append(' ');
        switch (n) {
            case 1: {
                stringBuffer.append('F');
                break;
            }
            case 2: {
                stringBuffer.append('R');
                break;
            }
            case 3: {
                stringBuffer.append('P');
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(n));
            }
        }
        this.send(stringBuffer.toString());
        FTPResponse fTPResponse = this.getResponse();
        if (fTPResponse.getCode() != 200) {
            throw new FTPException(fTPResponse);
        }
        this.fileStructure = n;
    }

    public int getTransferMode() {
        return this.transferMode;
    }

    public void setTransferMode(int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(MODE);
        stringBuffer.append(' ');
        switch (n) {
            case 1: {
                stringBuffer.append('S');
                break;
            }
            case 2: {
                stringBuffer.append('B');
                break;
            }
            case 3: {
                stringBuffer.append('C');
                break;
            }
            default: {
                throw new IllegalArgumentException(Integer.toString(n));
            }
        }
        this.send(stringBuffer.toString());
        FTPResponse fTPResponse = this.getResponse();
        if (fTPResponse.getCode() == 200) {
            this.transferMode = n;
            if (this.dtp != null) {
                this.dtp.setTransferMode(n);
            }
        } else {
            throw new FTPException(fTPResponse);
        }
    }

    public InputStream retrieve(String string) throws IOException {
        if (this.dtp == null || this.transferMode == 1) {
            this.initialiseDTP();
        }
        String string2 = "RETR " + string;
        this.send(string2);
        FTPResponse fTPResponse = this.getResponse();
        switch (fTPResponse.getCode()) {
            case 125: 
            case 150: {
                return this.dtp.getInputStream();
            }
        }
        throw new FTPException(fTPResponse);
    }

    public OutputStream store(String string) throws IOException {
        if (this.dtp == null || this.transferMode == 1) {
            this.initialiseDTP();
        }
        String string2 = "STOR " + string;
        this.send(string2);
        FTPResponse fTPResponse = this.getResponse();
        switch (fTPResponse.getCode()) {
            case 125: 
            case 150: {
                return this.dtp.getOutputStream();
            }
        }
        throw new FTPException(fTPResponse);
    }

    public OutputStream append(String string) throws IOException {
        if (this.dtp == null || this.transferMode == 1) {
            this.initialiseDTP();
        }
        String string2 = "APPE " + string;
        this.send(string2);
        FTPResponse fTPResponse = this.getResponse();
        switch (fTPResponse.getCode()) {
            case 125: 
            case 150: {
                return this.dtp.getOutputStream();
            }
        }
        throw new FTPException(fTPResponse);
    }

    public void allocate(long l) throws IOException {
        String string = "ALLO " + l;
        this.send(string);
        FTPResponse fTPResponse = this.getResponse();
        switch (fTPResponse.getCode()) {
            case 200: 
            case 202: {
                break;
            }
            default: {
                throw new FTPException(fTPResponse);
            }
        }
    }

    public boolean rename(String string, String string2) throws IOException {
        String string3 = "RNFR " + string;
        this.send(string3);
        FTPResponse fTPResponse = this.getResponse();
        switch (fTPResponse.getCode()) {
            case 450: 
            case 550: {
                return false;
            }
            case 350: {
                break;
            }
            default: {
                throw new FTPException(fTPResponse);
            }
        }
        string3 = "RNTO " + string2;
        this.send(string3);
        fTPResponse = this.getResponse();
        switch (fTPResponse.getCode()) {
            case 250: {
                return true;
            }
            case 450: 
            case 550: {
                return false;
            }
        }
        throw new FTPException(fTPResponse);
    }

    public boolean abort() throws IOException {
        this.send(ABOR);
        FTPResponse fTPResponse = this.getResponse();
        if (this.dtp != null) {
            this.dtp.abort();
        }
        switch (fTPResponse.getCode()) {
            case 226: {
                return false;
            }
            case 426: {
                fTPResponse = this.getResponse();
                if (fTPResponse.getCode() != 226) break;
                return true;
            }
        }
        throw new FTPException(fTPResponse);
    }

    public boolean delete(String string) throws IOException {
        String string2 = "DELE " + string;
        this.send(string2);
        FTPResponse fTPResponse = this.getResponse();
        switch (fTPResponse.getCode()) {
            case 250: {
                return true;
            }
            case 450: 
            case 550: {
                return false;
            }
        }
        throw new FTPException(fTPResponse);
    }

    public boolean removeDirectory(String string) throws IOException {
        String string2 = "RMD " + string;
        this.send(string2);
        FTPResponse fTPResponse = this.getResponse();
        switch (fTPResponse.getCode()) {
            case 250: {
                return true;
            }
            case 550: {
                return false;
            }
        }
        throw new FTPException(fTPResponse);
    }

    public boolean makeDirectory(String string) throws IOException {
        String string2 = "MKD " + string;
        this.send(string2);
        FTPResponse fTPResponse = this.getResponse();
        switch (fTPResponse.getCode()) {
            case 257: {
                return true;
            }
            case 550: {
                return false;
            }
        }
        throw new FTPException(fTPResponse);
    }

    public String getWorkingDirectory() throws IOException {
        this.send(PWD);
        FTPResponse fTPResponse = this.getResponse();
        if (fTPResponse.getCode() == 257) {
            String string = fTPResponse.getMessage();
            if (string.charAt(0) == '\"') {
                int n = string.indexOf(34, 1);
                if (n == -1) {
                    throw new ProtocolException(string);
                }
                return string.substring(1, n);
            }
            int n = string.indexOf(32);
            if (n == -1) {
                return string;
            }
            return string.substring(0, n);
        }
        throw new FTPException(fTPResponse);
    }

    public InputStream list(String string) throws IOException {
        Object object;
        if (this.dtp == null || this.transferMode == 1) {
            this.initialiseDTP();
        }
        if (string == null) {
            this.send(LIST);
        } else {
            object = "LIST " + string;
            this.send((String)object);
        }
        object = this.getResponse();
        switch (((FTPResponse)object).getCode()) {
            case 125: 
            case 150: {
                return this.dtp.getInputStream();
            }
        }
        throw new FTPException((FTPResponse)object);
    }

    public List nameList(String string) throws IOException {
        Object object;
        if (this.dtp == null || this.transferMode == 1) {
            this.initialiseDTP();
        }
        if (string == null) {
            this.send(NLST);
        } else {
            object = "NLST " + string;
            this.send((String)object);
        }
        object = this.getResponse();
        switch (((FTPResponse)object).getCode()) {
            case 125: 
            case 150: {
                InputStream inputStream = this.dtp.getInputStream();
                inputStream = new BufferedInputStream(inputStream);
                inputStream = new CRLFInputStream(inputStream);
                LineInputStream lineInputStream = new LineInputStream(inputStream);
                ArrayList arrayList = new ArrayList();
                String string2 = lineInputStream.readLine();
                while (string2 != null) {
                    arrayList.add(string2);
                    string2 = lineInputStream.readLine();
                }
                lineInputStream.close();
                return arrayList;
            }
        }
        throw new FTPException((FTPResponse)object);
    }

    public String system() throws IOException {
        this.send(SYST);
        FTPResponse fTPResponse = this.getResponse();
        if (fTPResponse.getCode() == 215) {
            String string = fTPResponse.getMessage();
            int n = string.indexOf(32);
            if (n == -1) {
                return string;
            }
            return string.substring(0, n);
        }
        throw new FTPException(fTPResponse);
    }

    public void noop() throws IOException {
        this.send(NOOP);
        FTPResponse fTPResponse = this.getResponse();
        if (fTPResponse.getCode() != 200) {
            throw new FTPException(fTPResponse);
        }
    }

    protected void send(String string) throws IOException {
        byte[] byArray = string.getBytes(US_ASCII);
        this.out.write(byArray);
        this.out.writeln();
        this.out.flush();
    }

    protected FTPResponse getResponse() throws IOException {
        FTPResponse fTPResponse = this.readResponse();
        if (fTPResponse.getCode() == 226) {
            if (this.dtp != null) {
                this.dtp.transferComplete();
            }
            fTPResponse = this.readResponse();
        }
        return fTPResponse;
    }

    protected FTPResponse readResponse() throws IOException {
        String string = this.in.readLine();
        if (string == null) {
            throw new ProtocolException("EOF");
        }
        if (string.length() < 4) {
            throw new ProtocolException(string);
        }
        int n = FTPConnection.parseCode(string);
        if (n == -1) {
            throw new ProtocolException(string);
        }
        char c = string.charAt(3);
        if (c == ' ') {
            return new FTPResponse(n, string.substring(4));
        }
        if (c == '-') {
            StringBuffer stringBuffer = new StringBuffer(string.substring(4));
            stringBuffer.append('\n');
            while (true) {
                if ((string = this.in.readLine()) == null) {
                    throw new ProtocolException("EOF");
                }
                if (string.length() >= 4 && string.charAt(3) == ' ' && FTPConnection.parseCode(string) == n) {
                    return new FTPResponse(n, string.substring(4), stringBuffer.toString());
                }
                stringBuffer.append(string);
                stringBuffer.append('\n');
            }
        }
        throw new ProtocolException(string);
    }

    static final int parseCode(String string) {
        char[] cArray = new char[]{string.charAt(0), string.charAt(1), string.charAt(2)};
        int n = 0;
        block5: for (int i = 0; i < 3; ++i) {
            int n2 = cArray[i] - 48;
            if (n2 < 0 || n2 > 9) {
                return -1;
            }
            switch (i) {
                case 0: {
                    n += 100 * n2;
                    continue block5;
                }
                case 1: {
                    n += 10 * n2;
                    continue block5;
                }
                case 2: {
                    n += n2;
                }
            }
        }
        return n;
    }
}

