/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.beans.decoder;

import gnu.java.beans.decoder.AbstractContext;
import gnu.java.beans.decoder.AssemblyException;
import gnu.java.beans.decoder.Context;
import java.lang.reflect.Array;

class ArrayContext
extends AbstractContext {
    private Object array;

    ArrayContext(String string, Class clazz, int n) {
        this.setId(string);
        this.array = Array.newInstance(clazz, n);
    }

    public void addParameterObject(Object object) throws AssemblyException {
        throw new AssemblyException(new IllegalStateException("Adding objects without an index to a fixed array is not possible."));
    }

    public void notifyStatement(Context context) {
    }

    public Object endContext(Context context) throws AssemblyException {
        return this.array;
    }

    public boolean subContextFailed() {
        return false;
    }

    public void set(int n, Object object) throws AssemblyException {
        try {
            Array.set(this.array, n, object);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new AssemblyException(arrayIndexOutOfBoundsException);
        }
    }

    public Object get(int n) throws AssemblyException {
        try {
            return Array.get(this.array, n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new AssemblyException(arrayIndexOutOfBoundsException);
        }
    }

    public Object getResult() {
        return this.array;
    }
}

