/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.CairoSurfaceGraphics;
import gnu.java.awt.peer.gtk.GtkImage;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.nio.ByteOrder;
import java.util.Hashtable;

public class CairoSurface
extends DataBuffer {
    int width;
    int height;
    long surfacePointer;
    long bufferPointer;
    static ColorModel nativeModel = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);

    private /* synthetic */ void finit$() {
        this.width = -1;
        this.height = -1;
    }

    private native void create(int var1, int var2, int var3);

    private native void destroy(long var1, long var3);

    private native int nativeGetElem(long var1, int var3);

    private native void nativeSetElem(long var1, int var3, int var4);

    public native void nativeDrawSurface(long var1, long var3, double[] var5, double var6);

    public void drawSurface(long l, double[] dArray, double d) {
        this.nativeDrawSurface(this.surfacePointer, l, dArray, d);
    }

    native int[] nativeGetPixels(long var1, int var3);

    public int[] getPixels(int n) {
        return this.nativeGetPixels(this.bufferPointer, n);
    }

    native void nativeSetPixels(long var1, int[] var3);

    public void setPixels(int[] nArray) {
        this.nativeSetPixels(this.bufferPointer, nArray);
    }

    native long getFlippedBuffer(long var1, int var3);

    public CairoSurface(int n, int n2) {
        super(3, n * n2);
        this.finit$();
        if (n <= 0 || n2 <= 0) {
            throw new IllegalArgumentException("Image must be at least 1x1 pixels.");
        }
        this.width = n;
        this.height = n2;
        this.create(n, n2, n);
        if (this.surfacePointer == 0L || this.bufferPointer == 0L) {
            throw new Error("Could not allocate bitmap.");
        }
    }

    CairoSurface(GtkImage gtkImage) {
        super(3, gtkImage.width * gtkImage.height);
        this.finit$();
        if (gtkImage.width <= 0 || gtkImage.height <= 0) {
            throw new IllegalArgumentException("Image must be at least 1x1 pixels.");
        }
        this.width = gtkImage.width;
        this.height = gtkImage.height;
        this.create(this.width, this.height, this.width);
        if (this.surfacePointer == 0L || this.bufferPointer == 0L) {
            throw new Error("Could not allocate bitmap.");
        }
        int[] nArray = gtkImage.getPixels();
        if (ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN) {
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i] & 0xFF;
                nArray[i] = n == 0 ? 0 : nArray[i] >>> 8 | n << 24;
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                int n = nArray[i] & 0xFF000000;
                if (n == 0) {
                    nArray[i] = 0;
                    continue;
                }
                int n2 = (nArray[i] & 0xFF0000) >> 16;
                int n3 = nArray[i] & 0xFF00;
                int n4 = (nArray[i] & 0xFF) << 16;
                nArray[i] = n | n4 | n3 | n2;
            }
        }
        this.setPixels(nArray);
    }

    public void dispose() {
        if (this.surfacePointer != 0L) {
            this.destroy(this.surfacePointer, this.bufferPointer);
        }
    }

    protected void finalize() {
        this.dispose();
    }

    public GtkImage getGtkImage() {
        return new GtkImage(this.width, this.height, this.getFlippedBuffer(this.bufferPointer, this.width * this.height));
    }

    public static BufferedImage getBufferedImage(int n, int n2) {
        return CairoSurface.getBufferedImage(new CairoSurface(n, n2));
    }

    public static BufferedImage getBufferedImage(GtkImage gtkImage) {
        return CairoSurface.getBufferedImage(new CairoSurface(gtkImage));
    }

    public static BufferedImage getBufferedImage(CairoSurface cairoSurface) {
        WritableRaster writableRaster = Raster.createPackedRaster(cairoSurface, cairoSurface.width, cairoSurface.height, cairoSurface.width, new int[]{255, 65280, 0xFF0000, -16777216}, new Point(0, 0));
        return new BufferedImage(nativeModel, writableRaster, true, new Hashtable());
    }

    public int getElem(int n, int n2) {
        if (n != 0 || n2 < 0 || n2 >= this.width * this.height) {
            throw new IndexOutOfBoundsException(n2 + " size: " + this.width * this.height);
        }
        return this.nativeGetElem(this.bufferPointer, n2);
    }

    public void setElem(int n, int n2, int n3) {
        if (n != 0 || n2 < 0 || n2 >= this.width * this.height) {
            throw new IndexOutOfBoundsException(n2 + " size: " + this.width * this.height);
        }
        this.nativeSetElem(this.bufferPointer, n2, n3);
    }

    public Graphics2D getGraphics() {
        return new CairoSurfaceGraphics(this);
    }

    native long nativeNewCairoContext(long var1);

    public long newCairoContext() {
        return this.nativeNewCairoContext(this.surfacePointer);
    }

    native void copyAreaNative2(long var1, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

    public void copyAreaNative(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.copyAreaNative2(this.bufferPointer, n, n2, n3, n4, n5, n6, n7);
    }
}

