/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.opentype.truetype;

import gnu.java.awt.font.opentype.truetype.GlyphLocator;
import gnu.java.awt.font.opentype.truetype.GlyphMeasurer;
import gnu.java.awt.font.opentype.truetype.VirtualMachine;
import gnu.java.awt.font.opentype.truetype.Zone;
import java.awt.geom.AffineTransform;
import java.nio.ByteBuffer;

final class GlyphLoader {
    private final GlyphLocator glyphLocator;
    private final GlyphMeasurer glyphMeasurer;
    private final VirtualMachine vm;
    private final int unitsPerEm;
    private final int[] contourEndPoints;
    private final byte[] pointFlags;
    private static final short ARGS_ARE_WORDS = 1;
    private static final short ARGS_ARE_XY_VALUES = 2;
    private static final short ROUND_XY_TO_GRID = 4;
    private static final short WE_HAVE_A_SCALE = 8;
    private static final short MORE_COMPONENTS = 32;
    private static final short WE_HAVE_AN_X_AND_Y_SCALE = 64;
    private static final short WE_HAVE_A_TWO_BY_TWO = 128;
    private static final short WE_HAVE_INSTRUCTIONS = 256;
    private static final short USE_MY_METRICS = 512;
    private static final short OVERLAP_COMPOUND = 1024;
    private static final short SCALED_COMPONENT_OFFSET = 2048;
    private static final short UNSCALED_COMPONENT_OFFSET = 4096;

    GlyphLoader(GlyphLocator glyphLocator, VirtualMachine virtualMachine, int n, int n2, int n3, GlyphMeasurer glyphMeasurer) {
        this.glyphLocator = glyphLocator;
        this.glyphMeasurer = glyphMeasurer;
        this.unitsPerEm = n;
        this.vm = virtualMachine;
        this.contourEndPoints = new int[n2];
        this.pointFlags = new byte[n3];
    }

    public void loadGlyph(int n, double d, AffineTransform affineTransform, boolean bl, Zone zone) {
        zone.setNumPoints(4);
        this.loadSubGlyph(n, d, affineTransform, bl, zone, 0, 0);
    }

    private void loadSubGlyph(int n, double d, AffineTransform affineTransform, boolean bl, Zone zone, int n2, int n3) {
        ByteBuffer byteBuffer = this.glyphLocator.getGlyphData(n);
        if (byteBuffer == null) {
            zone.setNumPoints(4);
            this.setPhantomPoints(n, 0, zone);
            zone.transform(d, affineTransform, this.unitsPerEm, n2, n3);
            return;
        }
        short s = byteBuffer.getShort();
        char c = byteBuffer.getChar();
        char c2 = byteBuffer.getChar();
        char c3 = byteBuffer.getChar();
        char c4 = byteBuffer.getChar();
        if (s >= 0) {
            this.loadSimpleGlyph(n, d, affineTransform, bl, s, byteBuffer, zone, n2, n3);
        } else {
            this.loadCompoundGlyph(n, d, affineTransform, bl, byteBuffer, zone, n2, n3);
        }
    }

    private void loadSimpleGlyph(int n, double d, AffineTransform affineTransform, boolean bl, int n2, ByteBuffer byteBuffer, Zone zone, int n3, int n4) {
        int n5;
        boolean bl2 = this.vm.setup(d, affineTransform, bl);
        for (n5 = 0; n5 < n2; ++n5) {
            this.contourEndPoints[n5] = byteBuffer.getChar();
        }
        int n6 = n2 > 0 ? 1 + this.contourEndPoints[n2 - 1] : 0;
        zone.setNumPoints(n6 + 4);
        char c = byteBuffer.getChar();
        int n7 = byteBuffer.position();
        byteBuffer.position(n7 + c);
        this.loadFlags(n6, byteBuffer);
        this.loadCoordinates(n6, byteBuffer, zone);
        for (n5 = 0; n5 < n2; ++n5) {
            zone.setContourEnd(this.contourEndPoints[n5], true);
        }
        this.setPhantomPoints(n, n6, zone);
        zone.transform(d, affineTransform, this.unitsPerEm, n3, n4);
        if (bl2) {
            // empty if block
        }
    }

    private void loadCompoundGlyph(int n, double d, AffineTransform affineTransform, boolean bl, ByteBuffer byteBuffer, Zone zone, int n2, int n3) {
        short s;
        Zone zone2 = new Zone(zone.getCapacity());
        AffineTransform affineTransform2 = new AffineTransform();
        int n4 = n;
        do {
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            double d7;
            short s2;
            short s3;
            s = byteBuffer.getShort();
            char c = byteBuffer.getChar();
            if ((s & 0x200) != 0) {
                n4 = c;
            }
            if ((s & 1) != 0) {
                s3 = byteBuffer.getShort();
                s2 = byteBuffer.getShort();
            } else {
                s3 = byteBuffer.get();
                s2 = byteBuffer.get();
            }
            if ((s & 8) != 0) {
                d6 = d7 = this.getDouble214(byteBuffer);
                d5 = 0.0;
                d4 = 0.0;
            } else if ((s & 0x40) != 0) {
                d6 = this.getDouble214(byteBuffer);
                d7 = this.getDouble214(byteBuffer);
                d5 = 0.0;
                d4 = 0.0;
            } else if ((s & 0x80) != 0) {
                d6 = this.getDouble214(byteBuffer);
                d4 = this.getDouble214(byteBuffer);
                d5 = this.getDouble214(byteBuffer);
                d7 = this.getDouble214(byteBuffer);
            } else {
                d7 = 1.0;
                d6 = 1.0;
                d5 = 0.0;
                d4 = 0.0;
            }
            double d8 = Math.max(Math.abs(d6), Math.abs(d4));
            double d9 = Math.max(Math.abs(d5), Math.abs(d7));
            if (Math.abs(Math.abs(d6) - Math.abs(d4)) <= 5.035400390625E-4) {
                d8 *= 2.0;
            }
            if (Math.abs(Math.abs(d5) - Math.abs(d7)) <= 5.035400390625E-4) {
                d9 *= 2.0;
            }
            if ((s & 2) != 0) {
                d3 = d8 * (double)s3;
                d2 = d9 * (double)s2;
            } else {
                d2 = 0.0;
                d3 = 0.0;
            }
            affineTransform2.setTransform(d6, d4, d5, d7, 0.0, 0.0);
            affineTransform2.concatenate(affineTransform);
            int n5 = byteBuffer.position();
            int n6 = byteBuffer.limit();
            this.loadSubGlyph(c, d, affineTransform2, bl, zone2, Math.round((float)d3 + (float)n2), Math.round(-((float)d2 + (float)n3)));
            zone.combineWithSubGlyph(zone2, 4);
            byteBuffer.limit(n6).position(n5);
        } while ((s & 0x20) != 0);
        this.setPhantomPoints(n4, zone.getSize() - 4, zone);
    }

    private double getDouble214(ByteBuffer byteBuffer) {
        return (double)byteBuffer.getShort() / 16384.0;
    }

    private void loadFlags(int n, ByteBuffer byteBuffer) {
        for (int i = 0; i < n; ++i) {
            byte by;
            this.pointFlags[i] = by = byteBuffer.get();
            if ((by & 8) == 0) continue;
            for (int j = byteBuffer.get() & 0xFF; j > 0; --j) {
                this.pointFlags[++i] = by;
            }
        }
    }

    private void loadCoordinates(int n, ByteBuffer byteBuffer, Zone zone) {
        byte by;
        int n2;
        int n3 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            by = this.pointFlags[n2];
            if ((by & 2) == 0) {
                if ((by & 0x10) == 0) {
                    n3 += byteBuffer.getShort();
                }
            } else {
                n3 = (by & 0x10) != 0 ? (n3 += byteBuffer.get() & 0xFF) : (n3 -= byteBuffer.get() & 0xFF);
            }
            zone.setOriginalX(n2, n3);
            zone.setOnCurve(n2, (by & 1) == 1);
        }
        int n4 = 0;
        for (n2 = 0; n2 < n; ++n2) {
            by = this.pointFlags[n2];
            if ((by & 4) == 0) {
                if ((by & 0x20) == 0) {
                    n4 += byteBuffer.getShort();
                }
            } else {
                n4 = (by & 0x20) != 0 ? (n4 += byteBuffer.get() & 0xFF) : (n4 -= byteBuffer.get() & 0xFF);
            }
            zone.setOriginalY(n2, -n4);
        }
    }

    private void setPhantomPoints(int n, int n2, Zone zone) {
        zone.setOriginalX(n2, 0);
        zone.setOriginalY(n2, 0);
        zone.setOriginalX(n2 + 1, this.glyphMeasurer.getAdvanceWidth(n, true));
        zone.setOriginalY(n2 + 1, this.glyphMeasurer.getAdvanceHeight(n, true));
        int n3 = this.glyphMeasurer.getAscent(false);
        int n4 = this.glyphMeasurer.getAscent(true);
        zone.setOriginalX(n2 + 2, n3);
        zone.setOriginalY(n2 + 2, n4);
        zone.setOriginalX(n2 + 3, n3 + this.glyphMeasurer.getAdvanceWidth(n, false));
        zone.setOriginalY(n2 + 3, n4 + this.glyphMeasurer.getAdvanceHeight(n, false));
    }
}

