/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.rmi;

import gnu.classpath.tools.HelpPrinter;
import gnu.classpath.tools.giop.GRMIC;
import gnu.classpath.tools.rmi.rmic.RmicCompiler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class RMIC {
    public static String VERSION = "0.01 alpha pre";

    public static void main(String[] stringArray) {
        int n;
        for (n = 0; n < stringArray.length; ++n) {
            if (!stringArray[n].equals("-giop") && !stringArray[n].equals("-iiop")) continue;
            GRMIC.main(stringArray);
            return;
        }
        n = 0;
        boolean bl = false;
        String string = "rmi/RMIC.txt";
        HelpPrinter.checkHelpKey(stringArray, string);
        File file = new File(".");
        if (stringArray.length == 0) {
            HelpPrinter.printHelpAndExit(string);
        } else {
            Object object;
            int n2;
            RmicCompiler rmicCompiler = new RmicCompiler();
            int n3 = -1;
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                int n4;
                object = stringArray[n2];
                if (((String)object).equals("-v")) {
                    RMIC.printVersion();
                    System.exit(0);
                    continue;
                }
                if (((String)object).equals("-nowrite")) {
                    n = 1;
                    continue;
                }
                if (((String)object).equals("-nowarn")) {
                    rmicCompiler.setWarnings(false);
                    continue;
                }
                if (((String)object).equals("-verbose")) {
                    bl = true;
                    rmicCompiler.setVerbose(true);
                    continue;
                }
                if (((String)object).equals("-force")) {
                    rmicCompiler.setForce(true);
                    continue;
                }
                if (((String)object).equals("-d")) {
                    n4 = n2 + 1;
                    if (n4 < stringArray.length) {
                        file = new File(stringArray[n4]);
                        ++n2;
                        continue;
                    }
                    HelpPrinter.printHelpAndExit(string);
                    continue;
                }
                if (((String)object).equals("-classpath")) {
                    n4 = n2 + 1;
                    if (n4 < stringArray.length) {
                        rmicCompiler.setClassPath(stringArray[n4]);
                        ++n2;
                        continue;
                    }
                    HelpPrinter.printHelpAndExit(string);
                    continue;
                }
                if (((String)object).charAt(0) == '-') continue;
                n3 = n2;
                break;
            }
            if (n3 < 0) {
                HelpPrinter.printHelpAndExit(string);
            }
            if (bl) {
                System.out.println("Compiling to " + file.getAbsolutePath());
            }
            for (n2 = n3; n2 < stringArray.length; ++n2) {
                if (stringArray[n2].charAt(0) == '-') continue;
                rmicCompiler.reset();
                object = rmicCompiler.loadClass(stringArray[n2]);
                rmicCompiler.compile((Class)object);
                String string2 = rmicCompiler.getPackageName().replace('.', '/');
                File file2 = new File(file, string2);
                String string3 = rmicCompiler.generateStub();
                String string4 = rmicCompiler.getStubName() + "_Stub.java";
                if (n != 0) continue;
                try {
                    file2.mkdirs();
                    FileOutputStream fileOutputStream = new FileOutputStream(new File(file2, string4));
                    ((OutputStream)fileOutputStream).write(string3.getBytes());
                    ((OutputStream)fileOutputStream).close();
                    continue;
                }
                catch (IOException iOException) {
                    System.err.println("Output path not accessible");
                    iOException.printStackTrace();
                    System.exit(1);
                }
            }
        }
    }

    public static void printVersion() {
        System.out.println("rmic v " + VERSION + " - RMI stub generator for java.rmi.* ");
    }
}

