/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.jar;

import gnu.classpath.tools.jar.Action;
import gnu.classpath.tools.jar.Main;
import gnu.classpath.tools.jar.Messages;
import gnu.classpath.tools.jar.WorkSet;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Extractor
extends Action {
    private WorkSet allItems;

    private void copyFile(InputStream inputStream, File file) throws IOException {
        int n;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.close();
    }

    public void run(Main main) throws IOException {
        Object object;
        ZipInputStream zipInputStream;
        this.allItems = new WorkSet(main.entries);
        File file = main.archiveFile;
        if (file == null || "-".equals(file.getName())) {
            zipInputStream = new ZipInputStream(System.in);
        } else {
            object = new BufferedInputStream(new FileInputStream(file));
            zipInputStream = new ZipInputStream((InputStream)object);
        }
        while ((object = zipInputStream.getNextEntry()) != null) {
            Object object2;
            if (!this.allItems.contains(((ZipEntry)object).getName())) continue;
            File file2 = new File(((ZipEntry)object).getName());
            if (((ZipEntry)object).isDirectory()) {
                if (!file2.mkdirs() || !main.verbose) continue;
                object2 = MessageFormat.format(Messages.getString("Extractor.Created"), file2);
                System.err.println((String)object2);
                continue;
            }
            object2 = file2.getParentFile();
            if (object2 != null) {
                ((File)object2).mkdirs();
            }
            this.copyFile(zipInputStream, file2);
            if (!main.verbose) continue;
            String string = ((ZipEntry)object).getMethod() == 0 ? Messages.getString("Extractor.Extracted") : Messages.getString("Extractor.Inflated");
            String string2 = MessageFormat.format(string, file2);
            System.err.println(string2);
        }
    }
}

