#!/bin/bash
# ALPINE(wu-imapd, c-client, pine)
#	BuildScript for Plamo Linux 4.7
#			by Jun Kuwamura <juk@linet.gr.jp> on 2009-09-19
#
#
SRC_URI=ftp://ftp.cac.washington.edu/alpine/alpine-2.00.tar.gz
SRC_FILE=${SRC_URI##*/}
PAC_NAME=${SRC_FILE%%.tar.gz}

REL=P1
CPU=i586
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/network
PAC_DIR=$PLAMO/Packages/4.7/03_ext

BUILD_DIR=$PLAMO/alpine
CUSTOM_DIR=$BUILD_DIR/Custom


echo $PAC_DIR
if [ ! -d $PAC_DIR ]; then
  mkdir -p  $PAC_DIR
fi
echo $SRC_DIR/$SRC_FILE
if [ ! -f $SRC_DIR/$SRC_FILE ]; then
  if [ ! -d $SRC_DIR ]; then
    mkdir -p $SRC_DIR
  fi
  ( cd $SRC_DIR; wget $SRC_URI )
fi


umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p $WORK
export LANG=C
export LC_ALL=C
export CFLAGS="-O2 -march=$CPU"
export PATH=$PATH:/usr/X11R7/bin


tar xvfz $SRC_DIR/$SRC_FILE
cd $PAC_NAME/
./configure --prefix=/usr  --with-krb5-dir=/usr/heimdal
make

make install DESTDIR=$WORK

DOC_DIR=$WORK/usr/share/doc/${PAC_NAME}
mkdir -p $DOC_DIR
cp -p  $BUILD_DIR/`basename $0` \
	NOTICE LICENSE README VERSION \
	doc/tech-notes.txt doc/brochure.txt \
    $DOC_DIR

mkdir -p $WORK/usr/{bin,sbin,lib,include}
cd imap
cp imapd/imapd ipopd/ipop[23]d $WORK/usr/sbin/
chmod 755 $WORK/usr/sbin/*
cp mtest/mtest $WORK/usr/bin/
cp mailutil/mailutil $WORK/usr/bin/

mkdir -p $DOC_DIR/imap
cp -p LICENSE.txt NOTICE README SUPPORT \
	./docs/imaprc.txt ./docs/FAQ.txt \
    $DOC_DIR/imap

cd c-client
cp c-client.a $WORK/usr/lib/
mkdir $WORK/usr/include/c-client
cp -p c-client.h $WORK/usr/include/c-client/
cp -p mail.h osdep.h rfc822.h  smtp.h  nntp.h  utf8.h utf8aux.h  misc.h  $WORK/usr/include/c-client/
cp -p linkage.h env_unix.h  fs.h  ftl.h  nl.h tcp.h env.h imap4r1.h $WORK/usr/include/c-client/
chown -R root.root $WORK/usr/include/c-client/ $WOEK/usr/lib/

chown -R root.root $DOC_DIR
chmod -R a+rX $DOC_DIR

cd $WORK
mkdir install
cat >> install/doinst.sh<<EOF
( cd usr/lib ; rm -rf libc-client.a )
( cd usr/lib ; /bin/ln -sf c-client.a libc-client.a )
EOF

mkdir etc
cat > etc/c-client.cf<<EOF
set disable-plaintext 0
I accept the risk
EOF

mkdir etc/pam.d
cat > etc/pam.d/imap<<EOF
auth	 include	plamo-default
session  include	plamo-default
account	 include	plamo-default
password include	plamo-default
EOF


#( cd usr/include ; for i in c-client/*.h; do ln -sf \$i; done )

tar cvfz ${PAC_NAME}-${SYS_NAME}.tgz usr/{sbin,bin,lib,include}/* etc/c-client.cf etc/pam.d/imap usr/share/doc/${PAC_NAME} install/doinst.sh
mv -v ${PAC_NAME}-${SYS_NAME}.tgz $PAC_DIR/
