/*
 * Decompiled with CFR 0.152.
 */
package sun.security.pkcs11;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import sun.security.pkcs11.P11Key;
import sun.security.pkcs11.Session;
import sun.security.pkcs11.wrapper.PKCS11Exception;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class SessionKeyRef
extends WeakReference<P11Key>
implements Comparable<SessionKeyRef> {
    private static ReferenceQueue<P11Key> refQueue = new ReferenceQueue();
    private static Set<SessionKeyRef> refList = Collections.synchronizedSortedSet(new TreeSet());
    private static final int MAX_ITERATIONS = 2;
    private long keyID;
    private Session session;

    static ReferenceQueue<P11Key> referenceQueue() {
        return refQueue;
    }

    private static void drainRefQueueBounded() {
        for (int i = 0; i < 2; ++i) {
            SessionKeyRef sessionKeyRef = (SessionKeyRef)refQueue.poll();
            if (sessionKeyRef == null) continue;
            sessionKeyRef.dispose();
        }
    }

    SessionKeyRef(P11Key p11Key, long l, Session session) {
        super(p11Key, refQueue);
        this.keyID = l;
        this.session = session;
        this.session.addObject();
        refList.add(this);
        SessionKeyRef.drainRefQueueBounded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() {
        refList.remove(this);
        if (this.session.token.isValid()) {
            Session session = null;
            try {
                session = this.session.token.getOpSession();
                this.session.token.p11.C_DestroyObject(session.id(), this.keyID);
            }
            catch (PKCS11Exception pKCS11Exception) {
            }
            finally {
                this.session.token.releaseSession(session);
                this.session.removeObject();
            }
        }
    }

    @Override
    public int compareTo(SessionKeyRef sessionKeyRef) {
        if (this.keyID == sessionKeyRef.keyID) {
            return 0;
        }
        return this.keyID < sessionKeyRef.keyID ? -1 : 1;
    }
}

