#!/bin/bash
# pam-krb5 	(http://www.eyrie.org/~eagle/software/pam-krb5/)
# PAM module for Heimdal Kerberos5 authenticatoin
#	BuildScript for Plamo Linux 4.5
#			by Jun Kuwamura <juk@linet.gr.jp> on 2008-06-24
# require:
#	heimdal-1.2
#
VERSION=3.10
SRC_URI=http://archives.eyrie.org/software/kerberos/pam-krb5-$VERSION.tar.gz
SRC_FILE=${SRC_URI##*/}
PAC_NAME=${SRC_FILE%%.tar.gz}

REL=P1
CPU=i586
SYS_NAME="${CPU}-${REL}"

PLAMO=/expo/Build
SRC_DIR=$PLAMO/Archive/secure
PAC_DIR=$PLAMO/Packages/4.5/Network
BLD_DIR=$PLAMO/pam-krb5
CUSTOM_DIR=$BLD_DIR/Custom

umask 022
CWD=`pwd`
WORK=$CWD/work
rm -rf $WORK/*
mkdir -p  $WORK
export LANG=C
export CFLAGS="-O2"
export PATH=$PATH:/usr/X11R6/bin

if [ ! -f $SRC_DIR/$SRC_FILE ]; then
    (cd $SRC_DIR; \
	wget -N $SRC_URI ; \
	);
fi;

tar xvfz $SRC_DIR/$SRC_FILE
cd  $PAC_NAME
./configure --prefix=/usr/heimdal
mkdir -p doc-pak
cp $BLD_DIR/`basename $0` doc-pak/
chkinstall -y -P

mv -v ${PAC_NAME}-i386-1.tgz  $PAC_DIR/${PAC_NAME}-${SYS_NAME}.tgz
cd $CWD

