#!/bin/sh
#
# rc.M: Initialize for multi-user mode.
#
# ޥ桼⡼ɤνԤʤ
#
# :
# 饤֥ꡦCD-ROMޥȡͥåȥHotPlug(ǥХưǧ)PCMCIA
# ALSAߥsyslogd/klogdrc.inet2NFSautofslpdapmdcrondatd
# ܸϥƥ(CannaWnnSKKservATOKx2)ndtpdPostgreSQLApache
# netatalkSambaxfsgpminit.dʲѥårc.local
#

# Tell the viewers what's going to happen...
echo "Going multiuser..."

# Remove stale locks and junk files (must be done after mount -a!).
/bin/rm -f /var/lock/* /var/spool/uucp/LCK..* /core > /dev/null 2>&1
for d in /var/lock/*; do
    /bin/rm -f $d/* $d/.* > /dev/null 2>&1
done

# Ensure basic filesystem permissions sanity.
chmod 755 /
chmod 1777 /tmp /var/tmp

# Update all the shared library links automatically.
echo "Updating shared library links..."
/sbin/ldconfig

# Screen blanks after 15 minutes idle time.
/usr/bin/setterm -blank 15

# Look for a CD-ROM and mount it on /cdrom if any.
if [ -x /etc/rc.d/rc.cdrom ]; then
    . /etc/rc.d/rc.cdrom
fi

chk_link () {
    [ "`ls -l $1 | /usr/bin/sed 's/.*-> *//'`" = $2 ]
}
if chk_link /etc/rc.d/rc.inet1 rc.inet1.planet; then
    # Only for Planet.

    # Initialize Planet related work files.
    /usr/bin/sed "/# .* begin/,/# .* end/d" /etc/resolv.conf > /etc/resolv.INI
    /bin/mv -f /etc/resolv.INI /etc/resolv.conf
    /bin/rm -f /var/lib/net/*[-.]* /var/lib/net/plugins/*

    # Initialize network interfaces.
    if [ -x /etc/rc.d/rc.inet1 ]; then
	# Temporary enable HotPlug to handle some (i.e. firmware) events.
	if [ -x /etc/rc.d/rc.murasaki -a \
	     -z "`grep 'hotplug=off' /proc/cmdline`" ]; then
             ln -sf /sbin/hotplug.murasaki /dev/.hotplug.agent
	    . /etc/rc.d/rc.inet1
	     ln -sf /bin/true /dev/.hotplug.agent 
	else
	    . /etc/rc.d/rc.inet1
	fi
    fi
fi

# Initialize HotPlug and autoprobe devices.
if [ -x /etc/rc.d/rc.murasaki ]; then
    echo "Initializing HotPlug stuff and autoprobe devices..."
    . /etc/rc.d/rc.murasaki start
fi
if grep -q usbfs /proc/filesystems && ! grep -q usbfs /etc/mtab; then
    mount -t usbfs usbfs /proc/bus/usb
fi

sleep 3

# Initialize PCMCIA devices.
if [ -x /etc/rc.d/rc.pcmcia -a -n "`lspci -n | grep 'Class 060[57]'`" ]; then
    . /etc/rc.d/rc.pcmcia start
fi

sleep 3

if chk_link /etc/rc.d/rc.inet1 rc.inet1.tradnet; then
    # Only for tradnet.

    # Initialize network interfaces.
    if [ -x /etc/rc.d/rc.inet1 ]; then
	. /etc/rc.d/rc.inet1
    fi
fi

# Initialize ALSA sound mixer.
look_mod () {
    [ -n "`/sbin/modprobe -l $1`" -o -n "`/sbin/modprobe -l $1.o`" ]
}
if [ -d /proc/asound ]; then
    echo "Initializing ALSA sound mixer..."
    if look_mod snd-pcm-oss; then
	modprobe snd-pcm-oss
    fi
    if look_mod snd-seq-oss; then
	modprobe snd-seq-oss
    fi
    if [ -x /usr/sbin/alsactl -a -f /etc/asound.state ]; then
	/usr/sbin/alsactl restore
    else
	/usr/bin/aumix -q -v75 -w75 -c75
    fi
fi

echo -n "Starting services:"

# Start the syslogd/klogd daemons.
if [ -r /syslogd.pid ]; then
    kill `cat /syslogd.pid` `cat /klogd.pid`
    sleep 1
    rm -f /syslogd.pid /klogd.pid /bootlog.conf
fi
if [ -f /bootlog ]; then
    if [ -f /var/adm/bootlog ]; then
	rm -f /var/adm/bootlog.last.gz
	mv -f /var/adm/bootlog /var/adm/bootlog.last
	gzip /var/adm/bootlog.last
    fi
    mv -f /bootlog /var/adm
fi
if [ -x /usr/sbin/syslogd ]; then
    echo -n " syslogd"
    /usr/sbin/syslogd -m 0
    # Prevents a race condition with SMP kernels.
    sleep 1
    echo -n " klogd"
    /usr/sbin/klogd -c 4
fi

# Initialize the NET subsystem.
if [ -x /etc/rc.d/rc.inet1 -a -x /etc/rc.d/rc.inet2 ]; then
    . /etc/rc.d/rc.inet2
fi

echo .

# Mount remote filesystems in fstab.
if [ -n "`/sbin/mount -anfv -t nfs 2> /dev/null`" ]; then
    echo "Mounting remote file systems..."
    /sbin/mount -a -t nfs
fi

# Start automounter.
if [ -x /etc/rc.d/rc.autofs ]; then
    /etc/rc.d/rc.autofs start
fi

echo -n "Starting services:"

# Start the lpd daemon.
if [ -x /usr/sbin/lpd ]; then
    echo -n " lpd"
    /usr/sbin/lpd
fi

# Start the APM daemon if APM is enabled in the kernel.
#if [ -x /usr/sbin/apmd -a -r /proc/apm ]; then
#    echo -n " apmd"
#    /usr/sbin/apmd
#  fi
#fi

# Start crond (Dillon's crond).
# If you want cron to actually log activity to /var/adm/cron, then change
# -l10 to -l8 to increase the logging level.
echo -n " crond"
/usr/sbin/crond -l8 >> /var/adm/cron 2>&1

# Start at daemon (atd).
if [ -x /usr/sbin/atd ]; then
    echo -n " atd"
    /usr/sbin/atd
fi

# Start Japanese conversion servers.
if [ -x /etc/rc.d/can35b2.r ]; then
    echo -n " canna"
    /etc/rc.d/can35b2.r start > /dev/null 2>&1
fi
if [ -x /etc/rc.d/wnn.r ]; then
    echo -n " jserver"
    /etc/rc.d/wnn.r start > /dev/null 2>&1
else
    if [ -x /usr/sbin/dpkeyserv ]; then
	echo -n " dpkeyserv"
	/usr/sbin/dpkeyserv > /dev/null 2>&1
    fi
    if [ -x /usr/sbin/jserver ]; then
	echo -n " jserver"
	/usr/sbin/jserver > /dev/null 2>&1
    fi
fi
if [ -x /usr/libexec/skkserv ]; then
    echo -n " skkserv"
    /usr/libexec/skkserv > /dev/null 2>&1
fi
if [ -x /opt/atokx2/sbin/atokx2mngdaemon ]; then
    echo -n " ATOKx2"
    /opt/atokx2/sbin/atokx2mngdaemon > /dev/null 2>&1
fi
if [ -x /usr/lib/im/htt ]; then
    echo -n " htt"
    /usr/lib/im/htt > /dev/null 2>&1 &
fi

if [ -x /usr/bin/sj3serv ]; then
    echo -n " sj3serv"
    /usr/bin/sj3serv
fi

# Start ndtpd.
if [ -x /usr/sbin/ndtpd -a -r /usr/etc/ndtpd.conf ]; then
    echo -n " ndtpd"
    /usr/sbin/ndtpd
fi

# Start PostgreSQL.
if [ -x /usr/pgsql/bin/pg_ctl ]; then
    echo -n " PostgreSQL"
    /usr/pgsql/bin/pg_ctl -o "-i" start > /dev/null 2>&1
fi

# Start Apache.
if [ -x /etc/rc.d/rc.httpd ]; then
    echo -n " Apache"
    /etc/rc.d/rc.httpd > /dev/null 2>&1
fi

# Start netatalk (a file/print server for Macintosh Appletalk).
if [ -x /etc/rc.d/rc.atalk ]; then
    echo -n " atalk"
    /etc/rc.d/rc.atalk > /dev/null 2>&1
fi

# Start Samba (a file/print server for Windows NBT).
# NOTE: You do not have to start this service here,
#       if you use Planet and enable plugins of it:
if [ -x /etc/rc.d/rc.samba ]; then
    echo -n " samba"
    /etc/rc.d/rc.samba > /dev/null 2>&1
fi

# Start X font server.
if [ -x /etc/rc.d/rc.xfs ]; then
    echo -n " xfs"
    /etc/rc.d/rc.xfs start > /dev/null 2>&1
fi

# Start gpm.
if [ -x /etc/rc.d/rc.gpm ]; then
    echo -n " gpm"
    /etc/rc.d/rc.gpm start > /dev/null 2>&1
fi

echo .

# Run the startup scripts in /etc/rc.d/init.d.
INITDANY=
if [ -d /etc/rc.d/init.d ]; then
    EXCLUDELIST=""
    for i in /etc/rc.d/rc.*; do
	if [ -h $i -a -f $i ]; then
	    EXCLUDE="`ls -l $i | grep "init\.d/" | sed -e 's/.*init\.d\///'`"
	    if [ -n "$EXCLUDE" ]; then
		EXCLUDELIST="$EXCLUDELIST -e $EXCLUDE"
	    fi
	fi
    done
    if [ -z "$EXCLUDELIST" ]; then
	INITDLIST="`ls /etc/rc.d/init.d`"
    else
	INITDLIST="`ls /etc/rc.d/init.d | grep -v $EXCLUDELIST`"
    fi
    for i in $INITDLIST; do
	if [ -x /etc/rc.d/init.d/$i ]; then
	    if [ -z "$INITDANY" ]; then
		echo -n "Starting services:"
		INITDANY=y
	    fi
	    echo -n " $i"
	    /etc/rc.d/init.d/$i start > /dev/null
	fi
    done
fi
if [ -n "$INITDANY" ]; then
    echo .
fi

if [ -x /etc/rc.d/rc.once -o -n "`ls /var/log/initpkg`" ]; then
    echo "Initializing system..."

    # Initialize system only once.
    if [ -x /etc/rc.d/rc.once ]; then
	. /etc/rc.d/rc.once
	mv /etc/rc.d/rc.once /var/adm/rc.once
    fi

    # Run the initpkg scripts if any still.
    if [ -x /etc/rc.d/rc.initpkg ]; then
	. /etc/rc.d/rc.initpkg
    fi
fi

if [ -x /usr/X11R7/bin/Xorg ]; then
    if [ ! -f /etc/X11/xorg.conf ]; then
        echo "making /etc/X11/xorg.conf"
        /usr/X11R7/bin/make_xorg.conf.sh 2>&1 > /dev/null
    fi
fi

# Start the local setup procedure.
if [ -x /etc/rc.d/rc.local ]; then
    . /etc/rc.d/rc.local
fi

# Tell the viewers the system is ready.
echo
echo "The system is ready."

sync

# All done.
