/**
 * @file bidiEntryCUPS.h
 * @breaf Functions for infoCUPS object.
 * @date $Date: 2004/02/18 20:48:05 $
 * @version 1.0.0
   copyright            : (C) 2004 by Turbolinux,Inc.

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Lesser General Public License as        *
 *   published by the Free Software Foundation;                            * 
 *                                                                         *
 ***************************************************************************/

#include "bidiEntry.h"
#include "bidiParser.h"

#ifndef BIDI_ENTRY_CUPS_H
#define BIDI_ENTRY_CUPS_H

#ifdef __cplusplus
extern "C" {
#endif

#define MESG_SIZE 128

/**
 * The structure containing the IPP messages. 
 * @struct infoCUPS.
 */
typedef struct _infoCUPS{ 
  struct _infoCUPS *next;        /**< link to self.  */
  char state_reason[MESG_SIZE];  /**< state-reason messages. */
  char state_messages[MESG_SIZE]; /**< state-messages messages. */ 
} infoCUPS;

infoCUPS *makeIPPInfo(Entry *);

#ifdef __cplusplus
}
#endif

#endif

