#!/bin/sh

### Configurations (edit below):

PREFIX=/usr
DOCPREFIX=${DOCPREFIX:-/usr/share/doc}

ORIGVER=2.5.1
PKGVER=P1
PACKAGE=libglade2-$ORIGVER-i386-$PKGVER.tgz

SRCURL1=http://ftp.gnome.org/pub/GNOME/sources/libglade/2.5/libglade-2.5.1.tar.bz2
SRC1=libglade-$ORIGVER.tar.bz2
SRCDIR1=libglade-$ORIGVER

SRC2=patches/catalog.ad.libglade

INITSCRIPTS=patches/libglade-xmlcatalog.sh

if [ ! -f $SRC1 ]; then
    wget -O $SRC1 $SRCURL1
fi

### Common preparations:

TMPDIR=`pwd`
SRCROOT=`pwd`
BUILDROOT=$TMPDIR/.work
PKGROOT=$BUILDROOT/pkgroot
mkdir -p $BUILDROOT
chown 0.0 $BUILDROOT
chmod 0755 $BUILDROOT

### Build and install (edit below):

cd $BUILDROOT
tar jxf $SRCROOT/$SRC1

cd $SRCDIR1
PKG_CONFIG_PATH=/usr/X11R6/lib/pkgconfig ./configure --prefix=$PREFIX --with-xml-catalog= || exit 1
make || exit 1
make install DESTDIR=$PKGROOT || exit 1

mkdir -p $PKGROOT/etc/xml
install -c -o0 -g0 -m0644 $SRCROOT/$SRC2 $PKGROOT/etc/xml

mkdir -p $PKGROOT$DOCPREFIX/$SRCDIR1
cp AUTHORS COPYING ChangeLog INSTALL NEWS README $PKGROOT$DOCPREFIX/$SRCDIR1
mkdir $PKGROOT$DOCPREFIX/$SRCDIR1/examples
cp examples/* $PKGROOT$DOCPREFIX/$SRCDIR1/examples

## Common packaging sequence:

mkdir -p $PKGROOT$DOCPREFIX/$SRCDIR1/build
cp $SRCROOT/$0 $PKGROOT$DOCPREFIX/$SRCDIR1/build
if [ -d $SRCROOT/patches ]; then
    mkdir $PKGROOT$DOCPREFIX/$SRCDIR1/build/patches
    cp $SRCROOT/patches/* $PKGROOT$DOCPREFIX/$SRCDIR1/build/patches
fi

if [ -d $PKGROOT$PREFIX/bin ]; then
    strip $PKGROOT$PREFIX/bin/*
fi
if [ -d $PKGROOT$PREFIX/sbin ]; then
    strip $PKGROOT$PREFIX/sbin/*
fi
if [ -d $PKGROOT$PREFIX/libexec ]; then
    find $PKGROOT$PREFIX/libexec -type f -exec strip {} ';'
fi
if [ -d $PKGROOT$PREFIX/lib ]; then
    find $PKGROOT$PREFIX/lib -type f -name '*.so*' -exec strip -g {} ';'
    find $PKGROOT$PREFIX/lib -mindepth 2 '(' -name '*.a' -o -name '*.la' ')' -exec rm {} ';'
fi
for docdir in $PKGROOT$DOCPREFIX/*; do
    if [ -d $docdir ]; then
	gzip $docdir/*
    fi
done
if [ -d $PKGROOT$PREFIX/man ]; then
    if [ ! -d $PKGROOT$PREFIX/share ]; then
	mkdir $PKGROOT$PREFIX/share
    fi
    ( cd $PKGROOT$PREFIX; tar cf - man ) | ( cd $PKGROOT$PREFIX/share; tar xfp - )
    rm -rf $PKGROOT$PREFIX/man
fi
if [ -d $PKGROOT$PREFIX/share/man ]; then
    symlinks=
    for l in `find $PKGROOT$PREFIX/share/man -type l -print`; do
	symlinks="$symlinks $l:`perl -e "print readlink '$l';"`"
	rm -f $l
    done
    gzip $PKGROOT$PREFIX/share/man/man?/*
    for l in $symlinks; do
	ln -s ${l#*:}.gz ${l%%:*}.gz
    done
fi

if [ -r $PKGROOT$PREFIX/info/dir ]; then
    rm -f $PKGROOT$PREFIX/info/dir
    echo "if [ -x /usr/bin/install-info ]; then" >> $BUILDROOT/initpkg
    echo "  ( cd $PREFIX/info" >> $BUILDROOT/initpkg
    for infofile in $PKGROOT$PREFIX/info/*.info; do
	echo "    /usr/bin/install-info ${infofile##*/} dir" >> $BUILDROOT/initpkg
    done
    echo "  )" >> $BUILDROOT/initpkg
    echo "fi" >> $BUILDROOT/initpkg
fi
for i in $INITSCRIPTS; do
    cat $SRCROOT/$i >> $BUILDROOT/initpkg
done
if [ -s $BUILDROOT/initpkg ]; then
    mkdir $PKGROOT/install
    mv -f $BUILDROOT/initpkg $PKGROOT/install
fi

cd $PKGROOT
echo y | makepkg $PACKAGE

cp -f $PACKAGE $SRCROOT
cd $SRCROOT
rm -rf $BUILDROOT
