#!/bin/sh

# Build script template [20060728]

### Configurations (edit below):

PREFIX=/usr
DOCPREFIX=${DOCPREFIX:-/usr/share/doc}

SHORTNAME=firefox
ORIGVER=1.5.0.7
PKGVER=P1
PACKAGE=$SHORTNAME-${ORIGVER/-/_}-i386-$PKGVER.tgz
SRCPKG=$SHORTNAME-${ORIGVER/-/_}-i386-$PKGVER-Plamosrc.tar.gz

#LOCALEVER=1.5.0.7
LOCALELANGS=ja

SRCURL1=http://ftp.mozilla-japan.org/pub/mozilla.org/firefox/releases/1.5.0.7/source/firefox-1.5.0.7-source.tar.bz2
SRCDIR1=firefox-$ORIGVER

PATCH11=patches/firefox-locales-co.patch
PATCH12=patches/firefox-1.5-startscript.patch
PATCH13=patches/firefox-1.5-software-update.patch
PATCH14=patches/firefox-1.5-no-default-search.patch
PATCH15=patches/firefox-1.5-libdir.patch
PATCH16=patches/firefox-1.5-iconpath-fix.patch
## Patches imported from FC5
PATCH101=patches/firefox-0.7.3-psfonts.patch
PATCH102=patches/firefox-1.1-default-applications.patch
PATCH103=patches/firefox-nopangoxft.patch
PATCH104=patches/firefox-1.5-pango-ua.patch

SRC2=download/firefox-${LOCALEVER:-$ORIGVER}-locales.tar.bz2

PATCH21=patches/firefox-1.5-jplocale-customsearch.patch

SRCURL311=http://mycroft.mozdev.org/nowrapper/submit-install.php/v/2299/wikipedia-ja.src
SRCURL312=http://mycroft.mozdev.org/nowrapper/submit-install.php/i/2299/wikipedia-ja.png

SRCURL321=http://hirohirotest.hp.infoseek.co.jp/Plugin/googlemaps.src
SRCURL322=http://hirohirotest.hp.infoseek.co.jp/Plugin/googlemaps.gif

SRC4=patches/mozconfig-plamobuild
SRC5=patches/unix.js

INITSCRIPTS=

### Common preparations:

TMPDIR=`pwd`
SRCROOT=`pwd`
BUILDROOT=$TMPDIR/.work
PKGROOT=$BUILDROOT/pkgroot

if [ ! -d $SRCROOT/download ]; then
    mkdir -p $SRCROOT/download
fi
for u in ${!SRCURL*}; do
    f=SRC${u#SRCURL}
    if [ -z "${!f}" ]; then
	declare $f=download/${!u##*/}
    fi
    if [ ! -f ${!f} ]; then
	wget -O ${!f} ${!u}
    fi
done

if [ -d $BUILDROOT ]; then
    rm -rf $BUILDROOT
fi
mkdir -p $BUILDROOT
chown 0.0 $BUILDROOT
chmod 0755 $BUILDROOT

### Build and install (edit below):

cd $BUILDROOT
tar jxf $SRCROOT/$SRC1

if [ -f $SRCROOT/$SRC2 ]; then
    tar jxf $SRCROOT/$SRC2
else
    (
	cd mozilla
	cat $SRCROOT/$PATCH11 | patch -p1
	make -f client.mk checkout MOZ_CO_LOCALES="$LOCALELANGS" ${LOCALEVER:+LOCALES_CO_TAG=FIREFOX_${LOCALEVER/./_}_RELEASE}
    )
    test -d l10n || exit 1
    tar jcf $SRCROOT/$SRC2 l10n
fi

cd mozilla
cat $SRCROOT/$PATCH12 | patch -p1
cat $SRCROOT/$PATCH13 | patch -p1
cat $SRCROOT/$PATCH14 | patch -p1
cat $SRCROOT/$PATCH15 | patch -p1
cat $SRCROOT/$PATCH16 | patch -p1
cat $SRCROOT/$PATCH101 | patch -p1
cat $SRCROOT/$PATCH102 | patch -p0
cat $SRCROOT/$PATCH103 | patch -p1
cat $SRCROOT/$PATCH104 | patch -p0
(
    cd ../l10n
    cat $SRCROOT/$PATCH21 | patch -p1
    for s in ${!SRC3*}; do
	cp $SRCROOT/${!s} ja/browser/searchplugins
    done
)
export PKG_CONFIG_PATH=/usr/X11R6/lib/pkgconfig
export MOZCONFIG=$SRCROOT/$SRC4
make -f client.mk build prefix=$PREFIX || exit 1
make -f client.mk install DESTDIR=$PKGROOT prefix=$PREFIX || exit 1

ln -s firefox-$ORIGVER $PKGROOT$PREFIX/lib/firefox

install -c -o0 -g0 -m0644 $SRCROOT/$SRC5 $PKGROOT$PREFIX/lib/firefox/defaults/pref

mkdir $PKGROOT$PREFIX/include/$SRCDIR1/nss
cp -f dist/public/nss/*.h $PKGROOT$PREFIX/include/$SRCDIR1/nss
#mkdir $PKGROOT$PREFIX/include/$SRCDIR1/seccmd
#cp -f dist/public/seccmd/*.h $PKGROOT$PREFIX/include/$SRCDIR1/seccmd

mkdir -p $PKGROOT$DOCPREFIX/$SRCDIR1
cp LEGAL LICENSE README.txt $PKGROOT$DOCPREFIX/$SRCDIR1

(
    cd $PKGROOT$PREFIX/lib/firefox
    LD_LIBRARY_PATH=. ./regxpcom
)

(
    cd $PKGROOT$PREFIX/lib/firefox/plugins
    ln -s ../../plugger/plugger.so .
)

strip $PKGROOT$PREFIX/lib/firefox/*

## Common packaging sequence:

mkdir -p $PKGROOT$DOCPREFIX/$SRCDIR1/$SHORTNAME-build
cp $SRCROOT/$0 $PKGROOT$DOCPREFIX/$SRCDIR1/$SHORTNAME-build
if [ -d $SRCROOT/patches ]; then
    mkdir $PKGROOT$DOCPREFIX/$SRCDIR1/$SHORTNAME-build/patches
    cp $SRCROOT/patches/* $PKGROOT$DOCPREFIX/$SRCDIR1/$SHORTNAME-build/patches
fi

if [ -d $PKGROOT$PREFIX/bin ]; then
    strip $PKGROOT$PREFIX/bin/*
fi
if [ -d $PKGROOT$PREFIX/sbin ]; then
    strip $PKGROOT$PREFIX/sbin/*
fi
if [ -d $PKGROOT$PREFIX/libexec ]; then
    find $PKGROOT$PREFIX/libexec -type f -exec strip {} ';'
fi
if [ -d $PKGROOT$PREFIX/lib ]; then
    find $PKGROOT$PREFIX/lib -type f -name '*.so*' -exec strip -g {} ';'
    find $PKGROOT$PREFIX/lib -mindepth 2 '(' -name '*.a' -o -name '*.la' ')' -exec rm {} ';'
fi
for docdir in $PKGROOT$DOCPREFIX/*; do
    if [ -d $docdir ]; then
	gzip $docdir/*
    fi
done
if [ -d $PKGROOT$PREFIX/man ]; then
    if [ ! -d $PKGROOT$PREFIX/share ]; then
	mkdir $PKGROOT$PREFIX/share
    fi
    ( cd $PKGROOT$PREFIX; tar cf - man ) | ( cd $PKGROOT$PREFIX/share; tar xfp - )
    rm -rf $PKGROOT$PREFIX/man
fi
if [ -d $PKGROOT$PREFIX/share/man ]; then
    symlinks=
    for l in `find $PKGROOT$PREFIX/share/man -type l -print`; do
	symlinks="$symlinks $l:`perl -e "print readlink '$l';"`"
	rm -f $l
    done
    gzip $PKGROOT$PREFIX/share/man/man?/*
    for l in $symlinks; do
	ln -s ${l#*:}.gz ${l%%:*}.gz
    done
fi

if [ -r $PKGROOT$PREFIX/info/dir ]; then
    rm -f $PKGROOT$PREFIX/info/dir
    echo "if [ -x /usr/bin/install-info ]; then" >> $BUILDROOT/initpkg
    echo "  ( cd $PREFIX/info" >> $BUILDROOT/initpkg
    for infofile in $PKGROOT$PREFIX/info/*.info; do
	echo "    /usr/bin/install-info ${infofile##*/} dir" >> $BUILDROOT/initpkg
    done
    echo "  )" >> $BUILDROOT/initpkg
    echo "fi" >> $BUILDROOT/initpkg
fi
for i in $INITSCRIPTS; do
    cat $SRCROOT/$i >> $BUILDROOT/initpkg
done
if [ -s $BUILDROOT/initpkg ]; then
    mkdir $PKGROOT/install
    mv -f $BUILDROOT/initpkg $PKGROOT/install
fi

cd $PKGROOT
echo y | makepkg $PACKAGE
cp -f $PACKAGE $SRCROOT

cd $PKGROOT$DOCPREFIX/$SRCDIR1
tar zcf $SRCPKG $SHORTNAME-build
cp -f $SRCPKG $SRCROOT

cd $SRCROOT
rm -rf $BUILDROOT
