# text.tcl --
#
# This demonstration script creates a text widget that describes
# the basic editing functions.
#
# RCS: @(#) $Id: text.tcl,v 1.1 1999/03/31 15:08:43 m-hirano Exp $

if {![info exists widgetDemo]} {
    error "This script should be run from the \"widget\" demo."
}

set w .text
catch {destroy $w}
toplevel $w
wm title $w "Text Demonstration - Basic Facilities"
wm iconname $w "text"
positionWindow $w

frame $w.buttons
pack $w.buttons -side bottom -fill x -pady 2m
button $w.buttons.dismiss -text [langSel Dismiss $BN;2r(B] -command "destroy $w"
button $w.buttons.code -text [langSel "See Code" "$B%3!<%I;2>H(B"] -command "showCode $w"
pack $w.buttons.dismiss $w.buttons.code -side left -expand 1

text $w.text -relief sunken -bd 2 -yscrollcommand "$w.scroll set" -setgrid 1 \
	-height 30
scrollbar $w.scroll -command "$w.text yview"
pack $w.scroll -side right -fill y
pack $w.text -expand yes -fill both
$w.text insert 0.0 [langSel \
{This window is a text widget.  It displays one or more lines of text
and allows you to edit the text.  Here is a summary of the things you
can do to a text widget:

1. Scrolling. Use the scrollbar to adjust the view in the text window.

2. Scanning. Press mouse button 2 in the text window and drag up or down.
This will drag the text at high speed to allow you to scan its contents.

3. Insert text. Press mouse button 1 to set the insertion cursor, then
type text.  What you type will be added to the widget.

4. Select. Press mouse button 1 and drag to select a range of characters.
Once you've released the button, you can adjust the selection by pressing
button 1 with the shift key down.  This will reset the end of the
selection nearest the mouse cursor and you can drag that end of the
selection by dragging the mouse before releasing the mouse button.
You can double-click to select whole words or triple-click to select
whole lines.

5. Delete and replace. To delete text, select the characters you'd like
to delete and type Backspace or Delete.  Alternatively, you can type new
text, in which case it will replace the selected text.

6. Copy the selection. To copy the selection into this window, select
what you want to copy (either here or in another application), then
click button 2 to copy the selection to the point of the mouse cursor.

7. Edit.  Text widgets support the standard Motif editing characters
plus many Emacs editing characters.  Backspace and Control-h erase the
character to the left of the insertion cursor.  Delete and Control-d
erase the character to the right of the insertion cursor.  Meta-backspace
deletes the word to the left of the insertion cursor, and Meta-d deletes
the word to the right of the insertion cursor.  Control-k deletes from
the insertion cursor to the end of the line, or it deletes the newline
character if that is the only thing left on the line.  Control-o opens
a new line by inserting a newline character to the right of the insertion
cursor.  Control-t transposes the two characters on either side of the
insertion cursor.

7. Resize the window.  This widget has been configured with the "setGrid"
option on, so that if you resize the window it will always resize to an
even number of characters high and wide.  Also, if you make the window
narrow you can see that long lines automatically wrap around onto
additional lines so that all the information is always visible.} \
{$B$3$N%&%#%s%I%&$O%F%-%9%H(B widget $B$G$9!#(B1$B9T$^$?$O$=$l0J>e$N%F%-%9%H$rI=(B
$B<(!&JT=8$9$k$3$H$,$G$-$^$9!#0J2<$O%F%-%9%H(B widget $B$G$G$-$kA`:n$K$D$$$F(B
$B$^$H$a$?$b$N$G$9!#(B

1. $B%9%/%m!<%k!#%9%/%m!<%k%P!<$G%F%-%9%H$NI=<(ItJ,$rF0$+$9$3$H$,$G$-$^$9!#(B

2. $B%9%-%c%K%s%0!#%F%-%9%H$N%&%#%s%I%&$G%^%&%9%\%?%s(B2 ($BCf%\%?%s$r(B) $B$r2!(B
$B$7$F>e2<$K%I%i%C%0$7$F$/$@$5$$!#$=$&$9$k$H%F%-%9%H$,9bB.$G%I%i%C%0$5$l!"(B
$BFbMF$r$6$C$HD/$a$k$3$H$,$G$-$^$9!#(B

3. $B%F%-%9%H$NA^F~!#%^%&%9%\%?%s(B1 ($B:8%\%?%s(B) $B$r2!$7!"A^F~%+!<%=%k$r%;%C(B
$B%H$7$F$+$i%F%-%9%H$rF~NO$7$F$/$@$5$$!#F~NO$7$?$b$N$,(B widget $B$KF~$j$^$9!#(B

4. $BA*Br!#$"$kHO0O$NJ8;z$rA*Br$9$k$K$O%^%&%9%\%?%s(B1 $B$r2!$7!"%I%i%C%0$7(B
$B$F$/$@$5$$!#0lEY%\%?%s$rN%$7$?$i!"%7%U%H%-!<$r2!$7$J$,$i%\%?%s(B1 $B$r2!$9(B
$B$3$H$GA*BrHO0O$ND4@0$,$G$-$^$9!#$3$l$OA*BrHO0O$N:G8e$r%^%&%9%+!<%=%k$K(B
$B:G$b6a$$0LCV$K%j%;%C%H$7!"%\%?%s$rN%$9A0$K%^%&%9$r%I%i%C%0$9$k$3$H$G$5(B
$B$i$KA*BrHO0O$rD4@0$G$-$^$9!#%@%V%k%/%j%C%/$G%o!<%I$r!"$^$?%H%j%W%k%/%j%C(B
$B%/$G9TA4BN$rA*Br$9$k$3$H$,$G$-$^$9!#(B

5. $B>C5n$HCV49!#%F%-%9%H$r>C5n$9$k$K$O!">C5n$7$?$$J8;z$rA*Br$7$F%P%C%/(B
$B%9%Z!<%9$+%G%j!<%H%-!<$rF~NO$7$F$/$@$5$$!#$"$k$$$O!"?7$7$$%F%-%9%H$r(B
$BF~NO$9$k$HA*Br$5$l$?%F%-%9%H$HCV49$5$l$^$9!#(B

6. $BA*BrItJ,$N%3%T!<!#A*BrItJ,$r$3$N%&%#%s%I%&$NCf$N$I$3$+$K%3%T!<$9$k(B
$B$K$O!"$^$:%3%T!<$7$?$$=j$rA*Br(B($B$3$3$G!"$"$k$$$OJL$N%"%W%j%1!<%7%g%s$G(B)
$B$7!"%\%?%s(B 2 $B$r%/%j%C%/$7$F!"A^F~%+!<%=%k$N0LCV$K%3%T!<$7$F$/$@$5$$!#(B

7. $BJT=8!#%F%-%9%H(B widget $B$O(B Emacs $B$N%-!<%P%$%s%I$K2C$($FI8=`E*$J(B Motif
$B$NJT=85!G=$r%5%]!<%H$7$F$$$^$9!#%P%C%/%9%Z!<%9$H%3%s%H%m!<%k(B-H $B$OA^F~(B
$B%+!<%=%k$N:8B&$NJ8;z$r:o=|$7$^$9!#%G%j!<%H%-!<$H%3%s%H%m!<%k(B-D $B$OA^F~(B
$B%+!<%=%k$N1&B&$NJ8;z$r:o=|$7$^$9!#(BMeta-$B%P%C%/%9%Z!<%9$OA^F~%+!<%=%k$N(B
$B1&B&$NC18l$r:o=|$7!"(BMeta-D $B$OA^F~%+!<%=%k$N:8B&$NC18l$r:o=|$7$^$9!#(B
$B%3%s%H%m!<%k(B-K $B$OA^F~%+!<%=%k$+$i9TKv$^$G$r:o=|$7!"$=$N0LCV$K2~9T(B
$B$7$+$J$+$C$?>l9g$O!"2~9T$r:o=|$7$^$9!#(B

8. $B%&%#%s%I%&$N%j%5%$%:!#$3$N(B widget $B$O(B "setGrid" $B%*%W%7%g%s$r%*%s$K$7(B
$B$F$"$j$^$9$N$G!"%&%#%s%I%&$r%j%5%$%:$9$k;~$K$O9b$5$HI}$O>o$KJ8;z9b$HJ8(B
$B;zI}$N@0?tG\$K$J$j$^$9!#$^$?!"%&%#%s%I%&$r69$/$7$?>l9g$K$OD9$$9T$,<+F0(B
$BE*$K@^$jJV$5$l!">o$KA4$F$NFbMF$,8+$($k$h$&$K$J$C$F$$$^$9!#(B}]
$w.text mark set insert 0.0
