#!/bin/sh

# Build script template [20060202]

### Configurations (edit below):

PREFIX=/usr
DOCPREFIX=${DOCPREFIX:-/usr/share/doc}

SHORTNAME=ppp
ORIGVER=2.4.4
PKGVER=P1
PACKAGE=$SHORTNAME-${ORIGVER/-/_}-i386-$PKGVER.tgz
SRCPKG=$SHORTNAME-${ORIGVER/-/_}-i386-$PKGVER-Plamosrc.tar.gz

SRCURL1=ftp://ftp.samba.org/pub/ppp/ppp-2.4.4.tar.gz
SRC1=ppp-$ORIGVER.tar.gz
SRCDIR1=ppp-$ORIGVER
PATCH11=patches/ppp-2.4.4-plamobuild.patch

SRC2=patches/pon.sh
SRC3=patches/poff.sh
SRC4=patches/pppsetup.sh
SRC5=patches/pppselect.sh
SRC6=patches/xpppselect.py
SRC7=patches/ip-up.sh
SRC8=patches/ip-down.sh
SRC9=patches/00README-Plamo.euc

INITSCRIPTS=

if [ ! -f $SRC1 ]; then
    wget -O $SRC1 $SRCURL1
fi

### Common preparations:

TMPDIR=`pwd`
SRCROOT=`pwd`
BUILDROOT=$TMPDIR/.work
PKGROOT=$BUILDROOT/pkgroot
mkdir -p $BUILDROOT
chown 0.0 $BUILDROOT
chmod 0755 $BUILDROOT

### Build and install (edit below):

cd $BUILDROOT
tar zxf $SRCROOT/$SRC1

cd $SRCDIR1
cat $SRCROOT/$PATCH11 | patch -sp1
./configure --prefix=$PREFIX || exit 1
make USE_PAM=y || exit 1
make install INSTROOT=$PKGROOT || exit 1

install_script () {
    DIST=${1##*/}
    DIST=$PKGROOT$2/${DIST%.*}
    cp $1 $DIST
    chown 0.0 $DIST
    chmod $3 $DIST
}

mkdir -p $PKGROOT$PREFIX/bin
mkdir -p $PKGROOT/etc/ppp
install_script $SRCROOT/$SRC2 $PREFIX/sbin 755
install_script $SRCROOT/$SRC3 $PREFIX/sbin 755
install_script $SRCROOT/$SRC4 $PREFIX/sbin 755
install_script $SRCROOT/$SRC5 $PREFIX/bin 755
install_script $SRCROOT/$SRC6 $PREFIX/bin 755
install_script $SRCROOT/$SRC7 /etc/ppp 755
install_script $SRCROOT/$SRC8 /etc/ppp 755

echo "lock" > $PKGROOT/etc/ppp/options
chown 0.0 $PKGROOT/etc/ppp/options
chmod 644 $PKGROOT/etc/ppp/options

mkdir -p $PKGROOT/etc/pam.d
cp pppd/ppp.pam $PKGROOT/etc/pam.d/ppp

mkdir -p $PKGROOT$DOCPREFIX/$SRCDIR1
cp Changes-2.3 FAQ PLUGINS README README.* SETUP $PKGROOT$DOCPREFIX/$SRCDIR1
cp $SRCROOT/$SRC9 $PKGROOT$DOCPREFIX/$SRCDIR1

## Common packaging sequence:

mkdir -p $PKGROOT$DOCPREFIX/$SRCDIR1/$SHORTNAME-build
cp $SRCROOT/$0 $PKGROOT$DOCPREFIX/$SRCDIR1/$SHORTNAME-build
if [ -d $SRCROOT/patches ]; then
    mkdir $PKGROOT$DOCPREFIX/$SRCDIR1/$SHORTNAME-build/patches
    cp $SRCROOT/patches/* $PKGROOT$DOCPREFIX/$SRCDIR1/$SHORTNAME-build/patches
fi

if [ -d $PKGROOT$PREFIX/bin ]; then
    strip $PKGROOT$PREFIX/bin/*
fi
if [ -d $PKGROOT$PREFIX/sbin ]; then
    strip $PKGROOT$PREFIX/sbin/*
fi
if [ -d $PKGROOT$PREFIX/libexec ]; then
    find $PKGROOT$PREFIX/libexec -type f -exec strip {} ';'
fi
if [ -d $PKGROOT$PREFIX/lib ]; then
    find $PKGROOT$PREFIX/lib -type f -name '*.so*' -exec strip -g {} ';'
    find $PKGROOT$PREFIX/lib -mindepth 2 '(' -name '*.a' -o -name '*.la' ')' -exec rm {} ';'
fi
for docdir in $PKGROOT$DOCPREFIX/*; do
    if [ -d $docdir ]; then
	gzip $docdir/*
    fi
done
if [ -d $PKGROOT$PREFIX/man ]; then
    if [ ! -d $PKGROOT$PREFIX/share ]; then
	mkdir $PKGROOT$PREFIX/share
    fi
    ( cd $PKGROOT$PREFIX; tar cf - man ) | ( cd $PKGROOT$PREFIX/share; tar xfp - )
    rm -rf $PKGROOT$PREFIX/man
fi
if [ -d $PKGROOT$PREFIX/share/man ]; then
    symlinks=
    for l in `find $PKGROOT$PREFIX/share/man -type l -print`; do
	symlinks="$symlinks $l:`perl -e "print readlink '$l';"`"
	rm -f $l
    done
    gzip $PKGROOT$PREFIX/share/man/man?/*
    for l in $symlinks; do
	ln -s ${l#*:}.gz ${l%%:*}.gz
    done
fi

if [ -r $PKGROOT$PREFIX/info/dir ]; then
    rm -f $PKGROOT$PREFIX/info/dir
    echo "if [ -x /usr/bin/install-info ]; then" >> $BUILDROOT/initpkg
    echo "  ( cd $PREFIX/info" >> $BUILDROOT/initpkg
    for infofile in $PKGROOT$PREFIX/info/*.info; do
	echo "    /usr/bin/install-info ${infofile##*/} dir" >> $BUILDROOT/initpkg
    done
    echo "  )" >> $BUILDROOT/initpkg
    echo "fi" >> $BUILDROOT/initpkg
fi
for i in $INITSCRIPTS; do
    cat $SRCROOT/$i >> $BUILDROOT/initpkg
done
if [ -s $BUILDROOT/initpkg ]; then
    mkdir $PKGROOT/install
    mv -f $BUILDROOT/initpkg $PKGROOT/install
fi

cd $PKGROOT
echo y | makepkg $PACKAGE
cp -f $PACKAGE $SRCROOT

cd $PKGROOT$DOCPREFIX/$SRCDIR1
tar zcf $SRCPKG $SHORTNAME-build
cp -f $SRCPKG $SRCROOT

cd $SRCROOT
rm -rf $BUILDROOT
