/* This is an OS dependent, generated file */


#ifndef __ROKEN_H__
#define __ROKEN_H__

/* -*- C -*- */
/*
 * Copyright (c) 1995-2005 Kungliga Tekniska Hgskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

/* $Id: roken.h.in,v 1.174 2005/05/11 13:04:04 lha Exp $ */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <signal.h>

#include <sys/param.h>
#include <inttypes.h>
#include <sys/types.h>
#include <sys/bitypes.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/uio.h>
#include <grp.h>
#include <sys/stat.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <arpa/nameser.h>
#include <resolv.h>
#include <syslog.h>
#include <fcntl.h>
#include <errno.h>
#include <err.h>
#include <termios.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <time.h>

#include <paths.h>


#include <roken-common.h>

ROKEN_CPP_START










int ROKEN_LIB_FUNCTION
    asnprintf (char **ret, size_t max_sz, const char *format, ...)
     __attribute__ ((format (printf, 3, 4)));

int ROKEN_LIB_FUNCTION
    vasnprintf (char **ret, size_t max_sz, const char *format, va_list ap)
     __attribute__((format (printf, 3, 0)));



char * ROKEN_LIB_FUNCTION strlwr(char *);



ssize_t ROKEN_LIB_FUNCTION strsep_copy(const char**, const char*, char*, size_t);




char * ROKEN_LIB_FUNCTION strupr(char *);

size_t ROKEN_LIB_FUNCTION strlcpy (char *dst, const char *src, size_t dst_sz);

size_t ROKEN_LIB_FUNCTION strlcat (char *dst, const char *src, size_t dst_sz);









#include <pwd.h>
struct passwd * ROKEN_LIB_FUNCTION k_getpwnam (const char *user);
struct passwd * ROKEN_LIB_FUNCTION k_getpwuid (uid_t uid);

const char * ROKEN_LIB_FUNCTION get_default_username (void);




int ROKEN_LIB_FUNCTION mkstemp(char *);

int ROKEN_LIB_FUNCTION cgetent(char **buf, char **db_array, const char *name);
int ROKEN_LIB_FUNCTION cgetstr(char *buf, const char *cap, char **str);













void ROKEN_LIB_FUNCTION pidfile (const char*);

unsigned int ROKEN_LIB_FUNCTION bswap32(unsigned int);

unsigned short ROKEN_LIB_FUNCTION bswap16(unsigned short);


time_t ROKEN_LIB_FUNCTION tm2time (struct tm tm, int local);

int ROKEN_LIB_FUNCTION unix_verify_user(char *user, char *password);

int ROKEN_LIB_FUNCTION roken_concat (char *s, size_t len, ...);

size_t ROKEN_LIB_FUNCTION roken_mconcat (char **s, size_t max_len, ...);

int ROKEN_LIB_FUNCTION roken_vconcat (char *s, size_t len, va_list args);

size_t ROKEN_LIB_FUNCTION
    roken_vmconcat (char **s, size_t max_len, va_list args);

ssize_t ROKEN_LIB_FUNCTION net_write (int fd, const void *buf, size_t nbytes);

ssize_t ROKEN_LIB_FUNCTION net_read (int fd, void *buf, size_t nbytes);

int ROKEN_LIB_FUNCTION issuid(void);


int ROKEN_LIB_FUNCTION get_window_size(int fd, struct winsize *);




struct hostent * ROKEN_LIB_FUNCTION
getipnodebyname (const char *name, int af, int flags, int *error_num);

struct hostent * ROKEN_LIB_FUNCTION
getipnodebyaddr (const void *src, size_t len, int af, int *error_num);

void ROKEN_LIB_FUNCTION
freehostent (struct hostent *h);

struct hostent * ROKEN_LIB_FUNCTION
copyhostent (const struct hostent *h);








int ROKEN_LIB_FUNCTION
getnameinfo_verified(const struct sockaddr *sa, socklen_t salen,
		     char *host, size_t hostlen,
		     char *serv, size_t servlen,
		     int flags);

int ROKEN_LIB_FUNCTION
roken_getaddrinfo_hostspec(const char *, int, struct addrinfo **); 
int ROKEN_LIB_FUNCTION
roken_getaddrinfo_hostspec2(const char *, int, int, struct addrinfo **);



void * ROKEN_LIB_FUNCTION emalloc (size_t);
void * ROKEN_LIB_FUNCTION ecalloc(size_t num, size_t sz);
void * ROKEN_LIB_FUNCTION erealloc (void *, size_t);
char * ROKEN_LIB_FUNCTION estrdup (const char *);

/*
 * kludges and such
 */

int ROKEN_LIB_FUNCTION
roken_gethostby_setup(const char*, const char*);
struct hostent* ROKEN_LIB_FUNCTION
roken_gethostbyname(const char*);
struct hostent* ROKEN_LIB_FUNCTION 
roken_gethostbyaddr(const void*, size_t, int);

#define roken_getservbyname(x,y) getservbyname(x,y)

#define roken_openlog(a,b,c) openlog(a,b,c)

#define roken_getsockname(a,b,c) getsockname(a,b,c)

void ROKEN_LIB_FUNCTION setprogname(const char *argv0);

const char * ROKEN_LIB_FUNCTION getprogname(void);

extern const char *__progname;

void ROKEN_LIB_FUNCTION mini_inetd_addrinfo (struct addrinfo*);
void ROKEN_LIB_FUNCTION mini_inetd (int port);


int ROKEN_LIB_FUNCTION
strsvis(char *dst, const char *src, int flag, const char *extra);

int ROKEN_LIB_FUNCTION
strunvis(char *dst, const char *src);

int ROKEN_LIB_FUNCTION
strvis(char *dst, const char *src, int flag);

int ROKEN_LIB_FUNCTION
strvisx(char *dst, const char *src, size_t len, int flag);

char * ROKEN_LIB_FUNCTION
svis(char *dst, int c, int flag, int nextc, const char *extra);

int ROKEN_LIB_FUNCTION
unvis(char *cp, int c, int *astate, int flag);

char * ROKEN_LIB_FUNCTION
vis(char *dst, int c, int flag, int nextc);

int ROKEN_LIB_FUNCTION
closefrom(int);

ROKEN_CPP_END
#define ROKEN_VERSION 0.7.2

#endif /* __ROKEN_H__ */
