export PATH=/bin:/usr/bin:/sbin:/usr/sbin

if [ -r /tmp/SeTT_PX ]; then
  ROOT="`cat /tmp/SeTT_PX`"
fi

cd $ROOT/

if ! fgrep "Id: services.append,v 1.6" $ROOT/etc/services 1> /dev/null 2>&1; then
  cat $ROOT/usr/heimdal/etc/services.append >> $ROOT/etc/services
  echo "extra services are appended in $ROOT/etc/services."
fi

TEMPLATE=$ROOT/usr/heimdal/etc/krb5.conf.template
KRB5CONF=$ROOT/etc/krb5.conf
#dname=`hostname -d`
if ! dname=`dnsdomainname`; then
  if [ -f $ROOT/etc/HOSTNAME ]; then
    dname=`cat $ROOT/etc/HOSTNAME  | cut -f2- -d.`
  fi
fi
if [ "_$dname" = "_" ]; then
  dname="localdomain"
fi
rname=`echo $dname | tr '[:lower:]' '[:upper:]'`
sed -e "s/REALM.NAME/$rname/" \
    -e "s/domain.name/$dname/" $TEMPLATE > ${KRB5CONF}.default-plamo
if [ ! -f $KRB5CONF ]; then
  cp ${KRB5CONF}.default-plamo ${KRB5CONF}
fi

if ! fgrep "/usr/heimdal/lib" $ROOT/etc/ld.so.conf 1> /dev/null 2>&1; then
  echo "/usr/heimdal/lib" >> $ROOT/etc/ld.so.conf
else
  echo "Entry /usr/heimdal/lib is already in $ROOT/etc/ld.so.conf."
fi
if [ "$ROOT" != "" ] ; then
  /sbin/ldconfig
fi


kill -HUP `pidof inetd`

if [ -d $ROOT/usr/info ]; then
  INF_DIR=$ROOT/usr/info
else
  if [ -d $ROOT/usr/share/info ]; then
    INF_DIR=$ROOT/usr/share/info
  else
    if [ -d $ROOT/usr/local/info ]; then
      INF_DIR=$ROOT/usr/local/info
    fi
  fi
fi
if [ ."$INF_DIR" != ."" ]; then
  if  ! fgrep "Heimdal" $ROOT/$INF_DIR/dir 1> /dev/null 2>&1; then
    cat >> $ROOT/$INF_DIR/dir<<__EOL__

Heimdal
* Heimdal: (heimdal).           The Kerberos 5 distribution from KTH
__EOL__
  fi
  cp -p $ROOT/usr/heimdal/info/heimdal.info* $ROOT/$INF_DIR/
  echo "heimdal.info installed in $ROOT/$INF_DIR/"
fi


echo "  You have to configure files: "
echo "	  $ROOT/etc/krb5.conf"
echo "	  ..."
echo "You can find sample files in $ROOT/usr/heimdal/etc/ directory."
echo "  You need farther installation work to create Kerberos database"
echo "if you want to make a Kerberos server.  See the documents:"
echo "	  # info -d /usr/heimdal/info/"
echo ""
echo "For clients, please add /usr/heimdal/bin in your path."

( cd usr/heimdal/lib ; rm -rf libroken.so.16 )
( cd usr/heimdal/lib ; ln -sf libroken.so.16.1.0 libroken.so.16 )
( cd usr/heimdal/lib ; rm -rf libroken.so )
( cd usr/heimdal/lib ; ln -sf libroken.so.16.1.0 libroken.so )
( cd usr/heimdal/lib ; rm -rf libeditline.so.0 )
( cd usr/heimdal/lib ; ln -sf libeditline.so.0.0.0 libeditline.so.0 )
( cd usr/heimdal/lib ; rm -rf libeditline.so )
( cd usr/heimdal/lib ; ln -sf libeditline.so.0.0.0 libeditline.so )
( cd usr/heimdal/lib ; rm -rf libcom_err.so.1 )
( cd usr/heimdal/lib ; ln -sf libcom_err.so.1.1.1 libcom_err.so.1 )
( cd usr/heimdal/lib ; rm -rf libcom_err.so )
( cd usr/heimdal/lib ; ln -sf libcom_err.so.1.1.1 libcom_err.so )
( cd usr/heimdal/lib ; rm -rf libsl.so.0 )
( cd usr/heimdal/lib ; ln -sf libsl.so.0.1.2 libsl.so.0 )
( cd usr/heimdal/lib ; rm -rf libsl.so )
( cd usr/heimdal/lib ; ln -sf libsl.so.0.1.2 libsl.so )
( cd usr/heimdal/lib ; rm -rf libss.so.0 )
( cd usr/heimdal/lib ; ln -sf libss.so.0.1.4 libss.so.0 )
( cd usr/heimdal/lib ; rm -rf libss.so )
( cd usr/heimdal/lib ; ln -sf libss.so.0.1.4 libss.so )
( cd usr/heimdal/lib ; rm -rf libasn1.so.6 )
( cd usr/heimdal/lib ; ln -sf libasn1.so.6.1.0 libasn1.so.6 )
( cd usr/heimdal/lib ; rm -rf libasn1.so )
( cd usr/heimdal/lib ; ln -sf libasn1.so.6.1.0 libasn1.so )
( cd usr/heimdal/lib ; rm -rf libkrb5.so.17 )
( cd usr/heimdal/lib ; ln -sf libkrb5.so.17.4.0 libkrb5.so.17 )
( cd usr/heimdal/lib ; rm -rf libkrb5.so )
( cd usr/heimdal/lib ; ln -sf libkrb5.so.17.4.0 libkrb5.so )
( cd usr/heimdal/lib ; rm -rf libkafs.so.0 )
( cd usr/heimdal/lib ; ln -sf libkafs.so.0.4.1 libkafs.so.0 )
( cd usr/heimdal/lib ; rm -rf libkafs.so )
( cd usr/heimdal/lib ; ln -sf libkafs.so.0.4.1 libkafs.so )
( cd usr/heimdal/lib ; rm -rf libhdb.so.7 )
( cd usr/heimdal/lib ; ln -sf libhdb.so.7.1.0 libhdb.so.7 )
( cd usr/heimdal/lib ; rm -rf libhdb.so )
( cd usr/heimdal/lib ; ln -sf libhdb.so.7.1.0 libhdb.so )
( cd usr/heimdal/lib ; rm -rf libkadm5srv.so.7 )
( cd usr/heimdal/lib ; ln -sf libkadm5srv.so.7.0.7 libkadm5srv.so.7 )
( cd usr/heimdal/lib ; rm -rf libkadm5srv.so )
( cd usr/heimdal/lib ; ln -sf libkadm5srv.so.7.0.7 libkadm5srv.so )
( cd usr/heimdal/lib ; rm -rf libkadm5clnt.so.4 )
( cd usr/heimdal/lib ; ln -sf libkadm5clnt.so.4.2.5 libkadm5clnt.so.4 )
( cd usr/heimdal/lib ; rm -rf libkadm5clnt.so )
( cd usr/heimdal/lib ; ln -sf libkadm5clnt.so.4.2.5 libkadm5clnt.so )
( cd usr/heimdal/lib ; rm -rf libgssapi.so.4 )
( cd usr/heimdal/lib ; ln -sf libgssapi.so.4.0.0 libgssapi.so.4 )
( cd usr/heimdal/lib ; rm -rf libgssapi.so )
( cd usr/heimdal/lib ; ln -sf libgssapi.so.4.0.0 libgssapi.so )
( cd usr/heimdal/lib ; rm -rf libotp.so.0 )
( cd usr/heimdal/lib ; ln -sf libotp.so.0.1.3 libotp.so.0 )
( cd usr/heimdal/lib ; rm -rf libotp.so )
( cd usr/heimdal/lib ; ln -sf libotp.so.0.1.3 libotp.so )
( cd usr/heimdal/bin ; rm -rf kauth )
( cd usr/heimdal/bin ; ln -sf kinit kauth )
( cd usr/heimdal/lib ; rm -rf libroken.so.16 )
( cd usr/heimdal/lib ; ln -sf libroken.so.16.1.0 libroken.so.16 )
( cd usr/heimdal/lib ; rm -rf libroken.so )
( cd usr/heimdal/lib ; ln -sf libroken.so.16.1.0 libroken.so )
( cd usr/heimdal/lib ; rm -rf libeditline.so.0 )
( cd usr/heimdal/lib ; ln -sf libeditline.so.0.0.0 libeditline.so.0 )
( cd usr/heimdal/lib ; rm -rf libeditline.so )
( cd usr/heimdal/lib ; ln -sf libeditline.so.0.0.0 libeditline.so )
( cd usr/heimdal/lib ; rm -rf libsl.so.0 )
( cd usr/heimdal/lib ; ln -sf libsl.so.0.1.2 libsl.so.0 )
( cd usr/heimdal/lib ; rm -rf libsl.so )
( cd usr/heimdal/lib ; ln -sf libsl.so.0.1.2 libsl.so )
( cd usr/heimdal/lib ; rm -rf libss.so.0 )
( cd usr/heimdal/lib ; ln -sf libss.so.0.1.4 libss.so.0 )
( cd usr/heimdal/lib ; rm -rf libss.so )
( cd usr/heimdal/lib ; ln -sf libss.so.0.1.4 libss.so )
( cd usr/heimdal/lib ; rm -rf libasn1.so.6 )
( cd usr/heimdal/lib ; ln -sf libasn1.so.6.1.0 libasn1.so.6 )
( cd usr/heimdal/lib ; rm -rf libasn1.so )
( cd usr/heimdal/lib ; ln -sf libasn1.so.6.1.0 libasn1.so )
( cd usr/heimdal/lib ; rm -rf libkrb5.so.17 )
( cd usr/heimdal/lib ; ln -sf libkrb5.so.17.4.0 libkrb5.so.17 )
( cd usr/heimdal/lib ; rm -rf libkrb5.so )
( cd usr/heimdal/lib ; ln -sf libkrb5.so.17.4.0 libkrb5.so )
( cd usr/heimdal/lib ; rm -rf libkafs.so.0 )
( cd usr/heimdal/lib ; ln -sf libkafs.so.0.4.1 libkafs.so.0 )
( cd usr/heimdal/lib ; rm -rf libkafs.so )
( cd usr/heimdal/lib ; ln -sf libkafs.so.0.4.1 libkafs.so )
( cd usr/heimdal/lib ; rm -rf libhdb.so.7 )
( cd usr/heimdal/lib ; ln -sf libhdb.so.7.1.0 libhdb.so.7 )
( cd usr/heimdal/lib ; rm -rf libhdb.so )
( cd usr/heimdal/lib ; ln -sf libhdb.so.7.1.0 libhdb.so )
( cd usr/heimdal/lib ; rm -rf libkadm5srv.so.7 )
( cd usr/heimdal/lib ; ln -sf libkadm5srv.so.7.0.7 libkadm5srv.so.7 )
( cd usr/heimdal/lib ; rm -rf libkadm5srv.so )
( cd usr/heimdal/lib ; ln -sf libkadm5srv.so.7.0.7 libkadm5srv.so )
( cd usr/heimdal/lib ; rm -rf libkadm5clnt.so.4 )
( cd usr/heimdal/lib ; ln -sf libkadm5clnt.so.4.2.5 libkadm5clnt.so.4 )
( cd usr/heimdal/lib ; rm -rf libkadm5clnt.so )
( cd usr/heimdal/lib ; ln -sf libkadm5clnt.so.4.2.5 libkadm5clnt.so )
( cd usr/heimdal/lib ; rm -rf libgssapi.so.4 )
( cd usr/heimdal/lib ; ln -sf libgssapi.so.4.0.0 libgssapi.so.4 )
( cd usr/heimdal/lib ; rm -rf libgssapi.so )
( cd usr/heimdal/lib ; ln -sf libgssapi.so.4.0.0 libgssapi.so )
( cd usr/heimdal/lib ; rm -rf libotp.so.0 )
( cd usr/heimdal/lib ; ln -sf libotp.so.0.1.3 libotp.so.0 )
( cd usr/heimdal/lib ; rm -rf libotp.so )
( cd usr/heimdal/lib ; ln -sf libotp.so.0.1.3 libotp.so )
( cd usr/heimdal/bin ; rm -rf kauth )
( cd usr/heimdal/bin ; ln -sf kinit kauth )
