;;; menu-tree.el --- get/set menu tree title

(defun menu-tree (km)
  (if (not (keymapp km))
      nil
    (let ((lis (cdr (if (symbolp km)
			(symbol-function km)
			km)))
	  (ret nil))
      (while lis
	(let ((entry (car lis))
	      event def name map)
	  (if (not (consp entry))
	      nil
	    (setq event (car entry)
		  def (cdr entry))
	    (if (consp def)
		(cond ((stringp (car def))
		       (setq name (car def)
			     map (cond ((keymapp (cdr def)) (cdr def))
				       ((consp (cdr def)) (cdr (cdr def))))))
		      ((eq 'menu-item (car def))
		       (setq name (nth 1 def)
			     map (nth 2 def)))))
	    (if name
		(setq ret (cons (cons event (cons name (menu-tree map)))
				ret)))))
	(setq lis (cdr lis)))
      (nreverse ret))))
;; (insert (pp (menu-tree (lookup-key global-map [menu-bar]))))

(defvar menu-tree-coding-system
  (if (eq window-system 'x) 'euc-japan)
  "coding system used for menu item")

(defun menu-tree-override (km tree)
  (if (not (keymapp km))
      nil
    (let ((alis (if (symbolp km)
		    (symbol-function km)
		  km)))
      (while tree
	(let ((entry (car tree))
	      event name map cell)
	  (setq event (car entry)
		name (encode-coding-string (car (cdr entry))
					   menu-tree-coding-system)
		map (cdr (cdr entry)))
	  (and (setq cell (assoc event alis))
	       (consp (cdr cell))
	       (cond ((stringp (car (cdr cell)))
		      (setcar (cdr cell) name)
		      (cond ((keymapp (cdr (cdr cell)))
			     (menu-tree-override (cdr (cdr cell)) map))
			    ((consp (cdr (cdr cell)))
			     (menu-tree-override (nthcdr 3 cell) map))))
		     ((eq 'menu-item (car (cdr cell)))
		      (setcar (cdr (cdr cell)) name)
		      (menu-tree-override (nth 3 cell) map)))))
	(setq tree (cdr tree))))))

(defun menu-tree-encode (km)
  (if (not (keymapp km))
      nil
    (let ((alis (if (symbolp km)
		    (symbol-function km)
		  km)))
      (while alis
	(let ((cell (car alis)))
	  (if (not (consp cell))
	      nil
	    (and (consp (cdr cell))
		 (cond ((stringp (car (cdr cell)))
			(setcar (cdr cell) 
				(encode-coding-string (car (cdr cell))
						      menu-tree-coding-system))
			(cond ((keymapp (cdr (cdr cell)))
			       (menu-tree-encode (cdr (cdr cell))))
			      ((consp (cdr (cdr cell)))
			       (menu-tree-encode (nthcdr 3 cell)))))
		       ((eq 'menu-item (car (cdr cell)))
			(setcar (cdr (cdr cell))
				(encode-coding-string (car (cdr (cdr cell)))
						      menu-tree-coding-system))
			(menu-tree-encode (nth 3 cell)))))))
	(setq alis (cdr alis))))))

(defvar menu-tree-alist-ja
  '((global-map
     (buffer "Хåե"
	     ;; ...
	     (list-buffers "Хåե"))
     (files "ե"
	    (open-file "")
	    (dired "ե")
	    (save-buffer "¸")
	    (write-file "̾Ĥ¸")
	    (revert-buffer "ǥɤ߽Ф")
	    (recover-session "å")
	    (print-buffer "Хåեΰ")
	    (print-region "ΰΰ")
	    (ps-print-buffer-faces "Хåեΰ(Postscript )")
	    (ps-print-region-faces "ΰΰ(Postscript )")
	    (ps-print-buffer "Хåեΰ(Postscript )")
	    (ps-print-region "ΰΰ(Postscript )")
	    (insert-file "ե")
	    (kill-buffer "ХåեĤ")
	    (separator-buffers "--")
	    (make-frame "ե졼")
	    (make-frame-on-display "ǥץ쥤")
	    (delete-this-frame "ե졼Ĥ")
	    (split-window "ɥʬ")
	    (one-window "¾Υɥä")
	    (separator-exit "--")
	    (exit-emacs "λ"))
     (tools "ġ"
	    (compare ""
		     (ediff-files "ե")
		     (ediff-buffers "Хåե")
		     (ediff-files3 "3ĤΥե")
		     (ediff-buffers3 "3ĤΥХåե")
		     (separator-ediff-files "--")
		     (ediff-directories "ե")
		     (ediff-directories3 "3ĤΥե")
		     (separator-ediff-directories "--")
		     (ediff-revision "")
		     (ediff-dir-revision "եβ")
		     (separator-ediff-regions "--")
		     (ediff-regions-wordwise "ñ줴(ΰ)")
		     (ediff-regions-linewise "Ԥ(ΰ)")
		     (separator-ediff-windows "--")
		     (ediff-windows-wordwise "ñ줴(ɥ)")
		     (ediff-windows-linewise "Ԥ(ɥ)")
		     (window "ɥ"))
	    (ediff-merge "ޡ"
			 (ediff-merge-files "ե")
			 (ediff-merge-files-with-ancestor "ե(դ)")
			 (ediff-merge-buffers "Хåե")
			 (ediff-merge-buffers-with-ancestor "Хåե(դ)")
			 (separator-ediff-merge-dirs "--")
			 (ediff-merge-directories "ե")
			 (ediff-merge-directories-with-ancestor "ե(դ)")
			 (separator-ediff-merge "--")
			 (ediff-merge-revisions "")
			 (ediff-merge-revisions-with-ancestor "(դ)")
			 (ediff-merge-dir-revisions "եβ")
			 (ediff-merge-dir-revisions-with-ancestor "եβ(դ)"))
	    (epatch "ѥå"
		    (ediff-patch-file "ե")
		    (ediff-patch-buffer "Хåե"))
	    (ediff-misc "Ӥ"
			(ediff-doc "ޥ˥奢")
			(ediff-cust "ޥ")
			(eregistry "å")
			(emultiframe "ե졼/ԻѤڤؤ"))
	    (separator-compare "--")
	    (vc "С"
		(vc-register "Ͽ")
		(vc-next-action "å/")
		(vc-insert-header "إå")
		(vc-revert-buffer "ѹ˴")
		(undo "åμä")
		(separator2 "----")
		(vc-print-log "ɽ")
		(vc-update-change-log "򹹿")
		(vc-diff "ǽǤ")
		(vc-version-other-window "Сɽ(̥ɥ)")
		(vc-rename-file "ե̾ѹ")
		(vc-annotate "Ĥ")
		(separator1 "----")
		(vc-directory "ե")
		(vc-create-snapshot "ʥåץåȤ񤭽Ф")
		(vc-retrieve-snapshot "ʥåץåȤ"))
	    (pcl-cvs "PCL-CVS"
		(examine "ǥ쥯ȥθ")
		(update "ǥ쥯ȥι")
		(checkout "⥸塼Υå")
		(status "ǥ쥯ȥꥹơ"))
	    (directory-search "ǥ쥯ȥ긡"
		(load "ФΥۥåȥꥹȤɤߤ")
		(new "")
		(separator-eudc-query "--")
		(query "ե䤤碌")
		(expand-inline "饤󥯥Ÿ")
		(separator-eudc-email "--")
		(email "Żҥ᡼륢ɥ쥹μ")
		(phone "ֹμ"))
	    (separator-vc "--")
	    (gnus "ͥåȥ˥塼")
	    (rmail "᡼ɤ")
	    (compose-mail "᡼")
	    (speedbar "ԡɥСɽ")
	    (calendar "ɽ")
	    (separator-games "--")
	    (games ""
	        (5x5 "5x5")
		(adventure "ɥ٥㡼")
		(black-box "֥åܥå")
		(gomoku "¤")
		(hanoi "ϥΥ")
		(life "饤ե")
		(mult "ݤѥ")
		(snake "͡")
		(solitaire "ƥ")
		(tetris "ƥȥꥹ")
		(yow "ʸ")
		(zone "󥢥"))
	    (grep "ʸ󸡺")
	    (compile "ѥ")
	    (shell "륳ޥ...")
	    (shell-on-region "꡼ǥ륳ޥ...")
	    (gdb "ǥХå")
	    (spell "ڥå"
		   (ispell-help "إ")
		   (ispell-message "᡼/˥塼")
		   (ispell-buffer "Хåե")
		   (ispell-region "ΰ")
		   (ispell-comments-and-strings "/ʸ")
		   (ispell-word "ñ")
		   (ispell-continue "Ƴ")
		   (ispell-complete-word-interior-frag "ʸ䴰Υե饰")
		   (ispell-complete-word "ʸ䴰")
		   (ispell-pdict-save "¸")
		   (ispell-kill-ispell "λ")
		   (ispell-change-dictionary "եѹ")
		   (default "ɸ")
		   (american "ꥫѸ")
		   (brasileiro "ݥȥ(֥饸)")
		   (british "ꥹѸ")
		   (castellano "ڥ")
		   (castellano8 "ڥ(8ӥå)")
		   (czech "")
		   (dansk "ǥޡ")
		   (deutsch "ɥĸ")
		   (deutsch8 "ɥĸ(8ӥå)")
		   (english "Ѹ")
		   (esperanto "ڥȸ")
		   (esperanto-tex "ڥȸ(TeX)")
		   (francais7 "ե󥹸(7ӥå)")
		   (francais "ե󥹸")
		   (francais-tex "ե󥹸(TeX)")
		   (german "ɥĸ")
		   (german8 "ɥĸ(8ӥå)")
		   (italiano "ꥢ")
		   (nederlands "")
		   (nederlands8 "(8ӥå)")
		   (norsk "Υ륦")
		   (norsk7-tex "Υ륦(7ӥåTeX)")
		   (polish "ݡɸ")
		   (russian "")
		   (svenska "ǥ")
		   (portugues "ݥȥ")
		   (slovak "Х"))
	    )
     (edit "Խ"
	   (undo "᤹")
	   (cut "ڤ")
	   (copy "ԡ")
	   (paste "Žդ")
	   (select-paste "Žդ()"
			 ;; ...
			 )
	   (clear "")
	   (mark-whole-buffer "٤")
	   (separator-edit "--")
	   (search ""
		   (search-forward "")
		   (re-search-forward "(ɽ)")
		   (search-backward "")
		   (re-search-backward "(ɽ)")
		   (query-replace "ִ")
		   (repeat-search-fwd "򸡺")
		   (repeat-regexp-fwd "򸡺(ɽ)")
		   (repeat-search-back "򸡺")
		   (repeat-regexp-back "򸡺(ɽ)")
		   (re-search "ɥХ󥹥ȸ/ִ"
			      (re-search-forward "ɽ")
			      (re-search-backward "ɽ")
			      (repeat-regexp-fwd "ɽη֤")
			      (repeat-regexp-back "ɽθ֤")
			      (query-replace-regexp "ɽִ")
			      (separator-tag-search "--")
			      (tags-srch "դե뤹٤ƤǸ")
			      (tags-repl "դե뤹٤Ƥִ")
			      (tags-continue "/ִη֤")
			      )
		   )
	   (goto ""
		 (go-to-line "Ԥ˥")
		 (go-to-pos "Хåեλ֤˥")
		 (beg-of-buf "ХåեƬ˥")
		 (end-of-buf "Хåե˥")
		 (separator-tags "--")
		 (find-tag "θ")
		 (find-tag-otherw "¾ΥɥΥθ")
		 (next-tag "Υ򸡺")
		 (next-tag-otherw "¾ΥɥμΥθ")
		 (apropos-tags "Apropos")
		 (separator-tag-file "--")
		 (set-tags-name "ե̾")
		 )
	   (bookmark "֥åޡ"
		     (jump "ɽ")
		     (set "å")
		     (insert "Ƥ")
		     (locate "")
		     (rename "̾ѹ")
		     (delete "")
		     (edit "Խ")
		     (save "¸")
		     (write "̾Ĥ¸")
		     (load "եɤ߹"))
	   (find-tag "")
	   (query-replace "ִ")
	   (query-replace-regexp "ִ(ɽ)")
	   (props "°"
		  (fc ""
		      (100 "ɸ")
		      (98 "")
		      (105 "")
		      (108 "")
		      (117 "դ")
		      (111 "¾"))
		  (fg "迧"
		      (111 "¾"))
		  (bg "طʿ"
		      (111 "¾"))
		  (sp "ü"
		      (114 "߶ػ")
		      (118 "ԲĻ")
		      (116 "ԲĿ")
		      (115 "ü°μä"))
		  (s2 "-----------------")
		  (ju ""
		      (117 "ʤ")
		      (108 "")
		      (114 "")
		      (98 "")
		      (99 ""))
		  (in "ǥ"
		      (increase-left-margin "䤹")
		      (decrease-left-margin "餹")
		      (increase-right-margin "䤹()")
		      (decrease-right-margin "餹()"))
		  (s1 "-----------------")
		  (rm "/ɸ᤹")
		  (ra "٤ɸ᤹")
		  (dp "°")
		  (df "/")
		  (dc ""))
	   (fill "ĹԤޤ֤"))
     (options "ץ"
	      (toggle-global-lazy-font-lock-mode "ʸɽ")
	      (auto-fill-mode "ưޤ֤")
	      (toggle-auto-compression "ư̡Ÿ")
	      (transient-mark-mode "ΰζĴɽ")
	      (highlight-paren-mode "פ̤Ĵɽ (ɽ⡼)")
	      (highlight-separator "--")
	      (truncate-lines "ĹԤޤ֤ɽʤ")
	      (case-fold-search "ʸʸƱ뤹")
	      (uniquify "Хåե̾˥ե̾ޤ")
	      (save-place "Խξ֤¸")
	      (options-separator "--")
	      (debug-on-error "顼ȯ˥ǥХåư")
	      (debug-on-quit "ȯ˥ǥХåư")
	      (mule ""
		    (set-language-environment "Ķ"
					      (Default "ɸ")
					      (Chinese ""
						       (Chinese-GB "(GB)")
						       (Chinese-BIG5 "(BIG5)")
						       (Chinese-CNS "(CNS)"))
					      (Cyrillic ""
							(Cyrillic-ISO "(ISO)")
							(Cyrillic-KOI8 "(KOI8)")
							(Cyrillic-ALT "(ALT)"))
					      (Indian "ɸ"
						      (Devanagari "ǡʡ꡼"))
					      (English "Ѹ")
					      (ASCII "ASCII")
					      (Ethiopic "ԥ")
					      (European "衼åѷϸ"
							(Latin-1 "ƥϸ(1)")
							(Latin-2 "ƥϸ(2)")
							(Latin-3 "ƥϸ(3)")
							(Latin-4 "ƥϸ(4)")
							(Latin-5 "ƥϸ(5)")
							(Latin-8 "ƥϸ(8)")
							(Latin-9 "ƥϸ(9)")
							(German "ɥĸ")
							(Slovenian "˥")
							(Spanish "ڥ")
							(Dutch "")
							(Polish "ݡɸ")
							(Czech "")
							(Slovak "Х")
							(Romanian "롼ޥ˥"))
					      (Turkish "ȥ륳")
					      (Greek "ꥷ")
					      (Hebrew "إ֥饤")
					      (Japanese "ܸ")
					      (Korean "ڹ")
					      (Lao "饪")
					      (Thai "")
					      (Tibetan "٥åȸ")
					      (Vietnamese "٥ȥʥ")
					      (IPA "ȯ"))
		    (mouse-set-font "ե")
		    (separator-mule "--")
		    (toggle-input-method "/")
		    (set-input-method "")
		    (separator-input-method "--")
		    (set-various-coding-system "ɷ"
					       (set-buffer-file-coding-system "Хåե")
					       (universal-coding-system-argument "ޥ")
					       (set-terminal-coding-system "ߥʥ")
					       (set-keyboard-coding-system "ܡ")
					       (set-buffer-process-coding-system "ץ")
					       (set-selection-coding-system "åץܡ")
					       (set-next-selection-coding-system "ڤ"))
		    (separator-coding-system "--")
		    (view-hello-file "¿ޤʸ")
		    (describe-language-environment "Ķ"
						   (Default "ɸ")
						   (Chinese ""
							    (Chinese-GB "(GB)")
							    (Chinese-BIG5 "(BIG5)")
							    (Chinese-CNS "(CNS)"))
						   (Cyrillic ""
							     (Cyrillic-ISO "(ISO)")
							     (Cyrillic-KOI8 "(KOI8)")
							     (Cyrillic-ALT "(ALT)"))
						   (Indian "ɸ"
							   (Devanagari "ǡʡ꡼"))
						   (English "Ѹ")
						   (ASCII "ASCII")
						   (Ethiopic "ԥ")
						   (European "衼åѷϸ"
							     (Latin-1 "ƥϸ(1)")
							     (Latin-2 "ƥϸ(2)")
							     (Latin-3 "ƥϸ(3)")
							     (Latin-4 "ƥϸ(4)")
							     (Latin-5 "ƥϸ(5)")
							     (Latin-8 "ƥϸ(8)")
							     (Latin-9 "ƥϸ(9)")	
							     (German "ɥĸ")
							     (Slovenian "˥")
							     (Spanish "ڥ")
							     (Dutch "")
							     (Polish "ݡɸ")
							     (Czech "")
							     (Slovak "Х")
							     (Romanian "롼ޥ˥"))
						   (Turkish "ȥ륳")
						   (Greek "ꥷ")
						   (Hebrew "إ֥饤")
						   (Japanese "ܸ")
						   (Korean "ڹ")
						   (Lao "饪")
						   (Thai "")
						   (Tibetan "٥åȸ")
						   (Vietnamese "٥ȥʥ")
						   (IPA "ȯ"))
		    (describe-input-method "")
		    (describe-coding-system "ɷϤ")
		    (list-character-sets "饯åȤΰ")
		    (mule-diag "¿첽ǽξ֤ɽ"))
	      (save "ץ¸")
	      (customize "ޥ"
			 (customize "ȥåץ٥륰롼")
			 (customize-browse "롼ɽ")
			 (separator-3 "--")
			 (customize-changed-options "ѹ줿ץ")
			 (customize-option "ץ")
			 (customize-face "/")
			 (customize-group "롼")
			 (separator-2 "--")
			 (customize-apropos "ɸ")
			 (customize-apropos-options "ɸ(ץ)")
			 (customize-apropos-faces "ɸ(/)")
			 (customize-apropos-groups "ɸ(롼)"))
	      )
     (help-menu "إ"
		(sep1 "--")
		(emacs-tutorial "Emacs塼ȥꥢ")
		(emacs-tutorial-language-specific "Emacs塼ȥꥢ()")
		(emacs-faq "Emacs ˴ؤ褯Ȥβ")
		(emacs-news "Emacs ˥塼")
		(emacs-problems "EmacsδΤ")
		(emacs-manual "Emacsޥ˥奢ɤ")
		(order-emacs-manuals "Emacsޥ˥奢ʸ")
		(report-emacs-bug "ХݡȤ")
		(manuals "ޥ˥奢"
			 (sep1 "--")
			 (info "Info ư")
			 (command "ޥ")
			 (key "")
			 (sep2 "--")
			 (man "man ޥ˥奢"))
		(describe "ñ"
			  (describe-mode "⡼")
			  (apropos-commands "ɤޤॳޥ")
			  (apropos-variables "ɤޤѿ")
			  (list-keybindings "դ")
			  (describe-language-environment "Ķ"
							 (Chinese ""
								  (Chinese-GB "(GB)")
								  (Chinese-BIG5 "(BIG5)")
								  (Chinese-CNS "(CNS)"))
							 (Cyrillic ""
								   (Cyrillic-ISO "(ISO)")
								   (Cyrillic-KOI8 "(KOI8)")
								   (Cyrillic-ALT "(ALT)"))
							 (Indian "ɸ"
								 (Devanagari "ǡʡ꡼"))
							 (English "Ѹ")
							 (ASCII "ASCII")
							 (Ethiopic "ԥ")
							 (European "衼åѷϸ"
								   (Latin-1 "ƥϸ(1)")
								   (Latin-2 "ƥϸ(2)")
								   (Latin-3 "ƥϸ(3)")
								   (Latin-4 "ƥϸ(4)")
								   (Latin-5 "ƥϸ(5)")
								   (Latin-8 "ƥϸ(8)")
								   (Latin-9 "ƥϸ(9)")
								   (German "ɥĸ")
								   (Slovenian "˥")
								   (Spanish "ڥ")
								   (Dutch "")
								   (Polish "ݡɸ")
								   (Czech "")
								   (Slovak "Х")
								   (Romanian "롼ޥ˥"))
							 (Turkish "ȥ륳")
							 (Greek "ꥷ")
							 (Hebrew "إ֥饤")
							 (Japanese "ܸ")
							 (Korean "ڹ")
							 (Lao "饪")
							 (Thai "")
							 (Tibetan "٥åȸ")
							 (Vietnamese "٥ȥʥ")
							 (IPA "ȯ"))
			  (describe-input-method "")
			  (describe-coding-system "ɷϤ")
			  (mule-diag "Muleξ֤٤Ƥɽ")
			  (describe-key "")
			  (describe-function "ؿ")
			  (describe-variable "ѿ"))
		(finder-by-keyword "Emacsѥå")
		(sep2 "--")
		(emacs-version "Emacs ΥС")
		(more "¾Υѥåõˤ")
		(describe-distribution "СEmacsˡ")
		(describe-copying "Emacsۤ˴ؤ")
		(describe-no-warranty "Emacs̵ݾڤǤ")
		(sep3 "--")
		(eliza "Emacsʬ"))
     )
    (emacs-lisp-mode-map
     (emacs-lisp "Emacs-Lisp"
		 (indent-line "ǥ()")
		 (indent-region "ǥ(ΰ)")
		 (comment-region "ȥ(ΰ)")
		 (separator-format "--")
		 (eval-sexp "S-ɾ")
		 (eval-region "ΰɾ")
		 (eval-buffer "Хåեɾ")
		 (separator-eval "--")
		 (byte-compile "Хȥѥ")
		 (emacs-byte-compile-and-load "Хȥѥɤ߹")
		 (byte-recompile "Хȥѥ(ե)")
		 (edebug-defun "ǥХåϿ")
		 )
     )
    (dired-mode-map
     (operate "ե"
	      (copy "ԡ")
	      (rename "̾ѹ")
	      (delete "")
	      (command "ե˥ޥɤ¹")
	      (symlink "ܥå󥯺")
	      (hardlink "ϡɥ󥯺")
	      (print "")
	      (compress "")
	      (compile "Хȥѥ")
	      (load "")
	      (chmod "°ѹ")
	      (chgrp "롼ѹ")
	      (chown "ͭѹ")
	      (search "")
	      (query-replace "ִ"))
     (mark "ޡ"
	   (toggle-marks "ޡȿž")
	   (mark "ޡ")
	   (unmark "ޡä")
	   (deletion "Ѥ˥ޡ")
	   (auto-save-files "ư¸ե")
	   (backup-files "Хååץե")
	   (garbage-files "")
	   (executables "¹ԥե")
	   (directory "ŤХååץե")
	   (directories "ե")
	   (symlinks "ܥå")
	   (unmark-all "ޡ򤹤٤ƾä")
	   (marks "ޡμѹ")
	   (next "Υޡ")
	   (prev "Υޡ"))
     (regexp "ɽ"
	     (mark-cont "եƤɽޤ")
	     (mark "ޡ")
	     (flag "Ѥ˥ޡ")
	     (copy "ԡ")
	     (rename "̾ѹ")
	     (symlink "ܥå󥯺")
	     (hardlink "ϡɥ󥯺")
	     (upcase "ե̾ʸˤ")
	     (downcase "ե̾ʸˤ"))
     (immediate "¹"
		(create-directory "ե")
		(find-file "")
		(find-file-other-window "̤Υɥǳ")
		(display "̤Υɥɽ")
		(view "⡼ɤǳ")
		(diff "ʬ")
		(backup-diff "ХååפȺʬ")
		(dashes "--")
		(revert-buffer "Хåե"))
     (subdir "֥ե"
	     (insert "")
	     (next-dirline "Υե")
	     (prev-dirline "Υե")
	     (next-subdir "Υ֥ե")
	     (prev-subdir "Υ֥ե")
	     (up "ľΥե")
	     (tree-up "֥ե˰ư")
	     (tree-down "֥ե򲼤˰ư")
	     (hide-subdir "֥ե򱣤")
	     (hide-all "٤ƤΥ֥ե򱣤"))
     )
    ))

(defvar menu-tree-alist menu-tree-alist-ja
  "alist used for overriding menu item string")

(defun menu-tree-override-by-alist (keymap-symbol)
  (menu-tree-override (lookup-key (symbol-value keymap-symbol) [menu-bar])
		      (cdr (assq keymap-symbol menu-tree-alist)))
  (force-mode-line-update))

(menu-tree-override-by-alist 'global-map)
(menu-tree-override-by-alist 'emacs-lisp-mode-map)
(eval-after-load "dired" '(menu-tree-override-by-alist 'dired-mode-map))

;; Emacs-22 ȥ顼ˤʤ褦ʤΤǥȥ
;;; for dynamic overriding menu
;; buffer
;;(add-hook 'menu-bar-update-hook
;;	  (lambda ()
;;	    (if menu-tree-coding-system
;;		(menu-tree-encode (lookup-key (current-global-map)
;;					      [menu-bar buffer])))
;;	    (menu-tree-override (lookup-key (current-global-map) [menu-bar])
;;				(list (assq 'buffer
;;					    (cdr (assq 'global-map
;;						       menu-tree-alist))))))
;;	  t)

(provide 'menu-tree)
;;; menu-tree.el ends here
