#!/bin/sh

if [ -r plamover.hook ]; then
    . plamover.hook
fi

ORGNAME=$1
ORGVER=$2
PLAMONAME=`echo "$ORGNAME" | tr A-Z+- a-zp_`
DESTDIR=$PLAMODESTDIR
PREFIX=$PLAMOPREFIX
PKGNAME=$PLAMONAME-${ORGVER/-/_}-$PLAMOARCH-$PLAMOVER.tgz
DESTPREFIX=$DESTDIR$PREFIX
INITPKG=$TOP_PWD/.work/initpkg

# Strip binaries and remove unnecessary static libs

if [ -d $DESTPREFIX/bin ]; then
    strip $DESTPREFIX/bin/*
fi
if [ -d $DESTPREFIX/sbin ]; then
    strip $DESTPREFIX/sbin/*
fi
if [ -d $DESTPREFIX/libexec ]; then
    find $DESTPREFIX/libexec -type f -exec strip {} ';'
fi
if [ -d $DESTPREFIX/lib ]; then
    find $DESTPREFIX/lib -type f -name '*.so*' -exec strip {} ';'
    find $DESTPREFIX/lib -mindepth 2 '(' -name '*.a' -o -name '*.la' ')' -exec rm {} ';'
fi

# Put and compress documents.

DOC_DEST=$DESTPREFIX/share/doc/$ORGNAME-$ORGVER
for d in $DESTPREFIX/share/doc/*; do
    if [ -d "$d" ]; then
	DOC_DEST=$d
	break
    fi
done

if [ ! -d "$DOC_DEST" ]; then
    mkdir -p $DOC_DEST
fi

cp work/main.d/*/[A-Z][A-Z]* work/main.d/*/Ch* work/main.d/*/*.spec $DOC_DEST
gzip $DOC_DEST/*
ln -s /usr/src/garnome-Ptgz-kit $DOC_DEST/build

# Move and compress manuals.

if [ -d $DESTPREFIX/man ]; then
    if [ ! -d $DESTPREFIX/share ]; then
        mkdir $DESTPREFIX/share
    fi
    ( cd $DESTPREFIX; tar cf - man ) | ( cd $DESTPREFIX/share; tar xfp - )
    rm -rf $DESTPREFIX/man
fi
if [ -d $DESTPREFIX/share/man ]; then
    symlinks=
    for l in `find $DESTPREFIX/share/man -type l -print`; do
	symlinks="$symlinks $l:`perl -e "print readlink '$l';"`"
	rm -f $l
    done
    gzip $DESTPREFIX/share/man/man?/*
    for l in $symlinks; do
	ln -s ${l#*:}.gz ${l%%:*}.gz
    done
fi

# Run hooks.

if [ -r install.hook ]; then
    . install.hook
fi

# Extract install-info process.

if [ -r $DESTPREFIX/info/dir ]; then
    rm -f $DESTPREFIX/info/dir
    echo 'if [ -x /usr/bin/install-info ]; then' >> $INITPKG
    echo "  ( cd ${PREFIX#/}/info" >> $INITPKG
    for f in `cd $DESTPREFIX/info; ls -1 *.info`; do
	echo "    /usr/bin/install-info $f dir" >> $INITPKG
    done
    echo '  )' >> $INITPKG
    echo 'fi' >> $INITPKG
fi

# Append MIME database update process to initpkg script.

if [ -d $DESTPREFIX/share/mime ]; then
    echo "if [ -x $PREFIX/bin/update-mime-database ]; then" >> $INITPKG
    echo "  $PREFIX/bin/update-mime-database $PREFIX/share/mime" >> $INITPKG
    echo 'fi' >> $INITPKG
fi

# Append desktop database update process to initpkg script.

if [ -d $DESTPREFIX/share/applications ] && \
   grep '^MimeType=' $DESTPREFIX/share/applications/* > /dev/null; then
    echo "if [ -x $PREFIX/bin/update-desktop-database ]; then" >> $INITPKG
    echo "  $PREFIX/bin/update-desktop-database $PREFIX/share/applications" >> $INITPKG
    echo 'fi' >> $INITPKG
fi

# Append OMF update process to initpkg script.

if [ -d $DESTPREFIX/share/omf ]; then
    echo "if [ -x $PREFIX/bin/scrollkeeper-update ]; then" >> $INITPKG
    echo "  $PREFIX/bin/scrollkeeper-update -q || exit 1" >> $INITPKG
    echo 'fi' >> $INITPKG
fi

# Append gdk-pixbuf loader update process to initpkg script.

if [ -d $DESTPREFIX/lib/gtk-2.0/`pkg-config --variable=gtk_binary_version gtk+-2.0`/loaders ]; then
    echo "if [ ! -x $PREFIX/bin/gdk-pixbuf-query-loaders -o ! -d $PREFIX/etc/gtk-2.0 ]; then" >> $INITPKG
    echo '  exit 1' >> $INITPKG
    echo 'fi' >> $INITPKG
    echo "$PREFIX/bin/gdk-pixbuf-query-loaders > $PREFIX/etc/gtk-2.0/gdk-pixbuf.loaders" >> $INITPKG
fi

# Append gconf-schema update process to initpkg script.

if [ -d $DESTPREFIX/etc/gconf/schemas ]; then
    echo "GCONFTOOL=$PREFIX/bin/gconftool-2" >> $INITPKG
    echo 'if [ ! -x $GCONFTOOL ]; then' >> $INITPKG
    echo '  exit 1' >> $INITPKG
    echo 'fi' >> $INITPKG
    echo 'GCONF_CONFIG_SOURCE=`$GCONFTOOL --get-default-source`' >> $INITPKG
    echo 'export GCONF_CONFIG_SOURCE' >> $INITPKG
    echo "GCONF_DIR=$PREFIX/etc/gconf" >> $INITPKG
    echo 'SCHEMA_DIR=$GCONF_DIR/schemas' >> $INITPKG
    echo 'SCHEMA_FILES=" \' >> $INITPKG
    (   cd $DESTPREFIX/etc/gconf/schemas
	for f in *.schemas; do
	    echo "  $f \\" >> $INITPKG
	done
    )
    echo '  "' >> $INITPKG
    echo 'for s in $SCHEMA_FILES; do' >> $INITPKG
    echo '  $GCONFTOOL --makefile-install-rule $SCHEMA_DIR/$s > /dev/null' >> $INITPKG
    echo 'done' >> $INITPKG
fi

# Append XML catalog update process to initpkg script.

if [ -r $DESTDIR/etc/xml/catalog.ad ]; then
    mv $DESTDIR/etc/xml/catalog.ad $DESTDIR/etc/xml/catalog.ad.$PLAMONAME
    echo "if [ ! -x $PREFIX/bin/xmlcatalog -o ! -r /etc/xml/catalog ]; then" >> $INITPKG
    echo '  exit 1' >> $INITPKG
    echo 'fi' >> $INITPKG
    echo ". /etc/xml/catalog.ad.$PLAMONAME" >> $INITPKG
fi

# Append already-provided initpkg script.

if [ -r initpkg.dist ]; then
    cat initpkg.dist >> $INITPKG
fi

# Put initpkg script.

if [ -s $INITPKG ]; then
    mkdir $DESTDIR/install
    cp $INITPKG $DESTDIR/install
fi

# Create Plamo package and install it immediately.

(   cd $DESTDIR
    echo y | makepkg $PKGNAME
)
(   cd $TOP_PWD/packages
    if [ -f $PKGNAME -a ! -f $PKGNAME.old ]; then
	mv -f $PKGNAME $PKGNAME.old
    fi
    mv -f $DESTDIR/$PKGNAME .
    . $TOP_PWD/tools/resethook.sh
    installpkg $PKGNAME
)

# Clean up.

(   cd $TOP_PWD
    rm -rf .work
    mkdir .work
    chown root:root .work
    chmod 755 .work
)

# Some tweaks.

. $TOP_PWD/tools/sethook.sh
